@extends('layouts.app')

@section('title')
All Open Files 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Open File Packages List</li>
      </ol>
@stop
@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->

                <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Open Files
                                <div class="pull-right">
                                    @permission('issue-openfile')
                                    <a href="{{route('openfile.package')}}" class="btn  btn-success">
                                        <i class="fa fa-plus-square"></i>&nbsp;Sell A Package
                                    </a>
                                @endpermission
                                    {{-- @permission('issue-openfile')
                                        <a href="{{route('openfile.create')}}" class="btn  btn-success">
                                            <i class="fa fa-plus-square"></i>&nbsp;Issue New Open File
                                        </a>
                                    @endpermission --}}
                                </div>
                            </div>
                        <div class="panel-wrapper collapse in" aria-expanded="true">
                                
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">
                                             
                                             <!--/span-->
                                   
                                 <!--/span-->
                                 @can('isSuperAdmin')
                                 <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By Project</label>
                                            <select id="multipro" class="form-control chosen-select" name="multipro_id">
                                                <option value=""><b>None</b></option>
                                                @foreach ($multi_projects as $pro)
                                                    
                                                        <option value="{{ $pro->id }}">{{ $pro->name }} </option>
                                                    
                                                @endforeach
                                            </select>
                                            </div>
                                    </div>
                                    @endcan

                                    <!--/span-->
                                    <!--/span-->
                                    <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By Dealer</label>
                                            
                                            <select id="dealer" class="form-control chosen-select">
                                                <option  value="0">None</option>
                                                @foreach($dealers as $d)
                                                <option value="{{$d->id}}">{{$d->name}}-{{$d->code}}</option>
                                                @endforeach
                                                </select> </div>
                                    </div>
                                    <!--/span-->

                                    <!--/span-->
                                    <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By status</label>
                                            <select id="status" class="form-control chosen-select">
                                            <option  value="0">None</option>
                                                
                                            
                                            <option  value="{{\App\CustomerProperty::pending}}">Pending</option>
                                            <option value="{{\App\DealerPackage::completed}}">Completed</option>

                                            
                                            </select> </div>
                                    </div>
                                    <!--/span-->

                                     <!--/span-->
                                    <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By Package </label>
                                            
                                            <select id="openfilepackage" class="form-control chosen-select">
                                                <option  value="0">None</option>
                                                @foreach($openfile_package as $p)
                                                <option value="{{$p->id}}">{{$p->name}}</option>
                                                @endforeach
                                                </select> </div>
                                                 
                                    </div>
                                    <!--/span-->

                                     <!--/span-->
                                    <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By Issue Date</label>
                                        <input type='date' name='issue_date' id='date' class='form-control'>    
                                        </div>
                                    </div>
                                    <!--/span-->
                                   

                                    <!--/span-->
                                    <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By Package Inventory</label>
                                            <select id="package_inventory" class="form-control chosen-select">
                                            <option  value="">None</option>
                                            <option  value="{{\App\DealerPackage::inventory_created}}">Created</option>
                                            <option  value="{{\App\DealerPackage::inventory_not_created}}">Not Created</option>
                                           
                                             
                                            
                                            
                                            </select> </div>
                                    </div>
                                    <!--/span--> 
                                   

                                        

                                    <div class="col-md-3">
                                    <div class="form-actions" style="margin-top: 26px">
                                    <button type="button" class="btn btn-success search-customer"> <i class="fa fa-check" ></i> Search</button>

                                    </div>
                                    </div>


                                    </div>
                                                  
                                </div>
                                        
                                    </form>
                                </div>
                            </div> 
                        </div>
                    </div>
                </div>
                <!--./row-->

                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	
                            <h3 class="box-title">All Open Files ({{count($dealer_openfile_package )}})</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr. No.</th>    
                                            <th>Project</th>                                   
                                            <th>Dealer Name</th>
                                            <th>Dealer Code</th>
                                            <th>Package Name</th>
                                            <th>Paid Amount</th>
                                            
                                            <th>Payment Status</th>
                                            <th>Issue Date</th>
                                            <th>Package Inventory</th>
                                            
                                            <th style="width: 185px!important;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($dealer_openfile_package as $dopf)
                                        

                                        <tr>
                                            <td>{{ $count++ }}</td>
                                            <td>
                                             
                                                {{ $dopf->multiProject?$dopf->multiProject->name:'None' }}
                                            
                                            </td>
                                            <td>{{ $dopf->dealer->name }}</td>
                                            <td>{{ $dopf->dealer->code }}</td>
                                            <td>{{($dopf->package)? $dopf->package->name:'' }}</td>
                                            <td>
                                                @php
                                                 $paid_amount=   $dopf->dealerPackagePaymentReceipt->where('dealerpackage_id',$dopf->id)->where('is_approved',1)->sum('amount');    
                                                @endphp
                                                {{  $paid_amount}}
                                                
                                                PKR </td>
                                          
                                            <td>
                                                
                                                @if($dopf->payment_status == \App\DealerPackage::pending)
                                                <span class="label label-danger">Pending</span>
                                                 @elseif($dopf->payment_status == \App\DealerPackage::completed)
                                                 <span class="label label-success">Completed</span>
                                                 @endif 
                                            </td>
                                            <td>{{ $dopf->issue_date }}</td>


                                            <td>
                                                @if($dopf->inventory_status == \App\DealerPackage::inventory_not_created)
                                                <span class="label label-danger">Not Created</span>
                                                 @elseif($dopf->inventory_status == \App\DealerPackage::inventory_created)
                                                 <span class="label label-success">Created</span>
                                                 @endif
                                                </td>

                                                
                                            <td class="text-nowrap">
                                                <a href="{{ route('openfile.detail',['id'=>$dopf->id]) }}"
                                                    data-toggle="tooltip" data-original-title="Inventory List"> <i
                                                        class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                        
                                                        <a href="{{route('openfile.package.payments',$dopf->id)}}"
                                                            data-toggle="tooltip" data-original-title="Payment Receipts"> <i
                                                                class="fa fa-money text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                         
                                                         
                                                      
                                                {{-- <a href="{{ route('openfile.view', [$dopf->id]) }}"
                                                    data-toggle="tooltip" datza-original-title="Edit"> <i
                                                        class="fa fa-pencil text-inverse m-r-10"></i></a> --}}
                                                        
                                                <a href="{{ route('openfile.view',['id'=>$dopf->id]) }}"
                                                    data-toggle="tooltip" data-original-title="Status Pending"> <i
                                                        class="fa-solid fa-pen-field"></i></a>

                                                        

                                                {{-- <form
                                                    action="{{ route('openfile.delete', [$dopf->id]) }}"
                                                    method="post" style='display: inline;'>
                                                    {!! method_field('delete') !!}
                                                    {!! csrf_field() !!}

                                                    <button class="btn btn-link btn-s" style="color:red;" type="submit"
                                                        name="action" value="delete" data-toggle="confirmation"
                                                        data-title="Are you sure to delete?">
                                                        <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                    </button>
                                                </form> --}}
                                            
                                                 
                                            </td>
                                        </tr>
                                        @endforeach
                                        
                                       

                                    </tbody>                                                                                                                    
                                </table>
                                <div style="float: right;"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>


<div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'ordering':false,
            'sorting' : false,
            'info':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            
            dealer = $('#dealer').val();
            status = $('#status').val();
            openfilepackage = $('#openfilepackage').val();
            date = $('#date').val();
            package_inventory = $('#package_inventory').val();
            multipro = $('#multipro').val();

            
        if(multipro == 0 &&  dealer == 0 && status== 0 && openfilepackage == 0 && date == null && package_inventory == 0)
        {
            toastr.warning("please select any option.");
            $('.preloader').fadeOut();
            return false;
        }

            var data = {'multipro':multipro,'dealer':dealer,'status':status, 'openfilepackage' : openfilepackage , 'date' : date , 'package_inventory' : package_inventory};
            $.get('/issue/open-file-update-table',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength':50,
                    'paging':false,
                    'searching':false,
                    'info':true,
                    'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });
    



    function openSmsModal(property_id) {

        var data={'property_id':property_id};
        $.get('/update_sms_modal', data, function (data) {
            document.getElementById('exampleModal').innerHTML = data;
            $('#exampleModal').modal();
        });
    }

    function openReminderModal(property_id) {

        var data={'property_id':property_id};
        $.get('/update_reminder_modal', data, function (data) {
            document.getElementById('exampleModal1').innerHTML = data;
            $('#exampleModal1').modal();
        });
    }







    </script>
@stop