@extends('layouts.app')

@section('title')
 Package Payment
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active"><a href={{route('openfile.pending.package')}}></a>Approved Packags List</li>
        <li class="active">Create Package Inventory</li>
      </ol>
@stop
@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

{{-- <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"> --}}
{{-- <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.1/dist/jquery.slim.min.js"></script> --}}
{{-- <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script> --}}
{{-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script> --}}
<style>
    .my-validation-message::before {
  display: none;
}

.my-validation-message i {
  margin: 0 .4em;
  color: #f27474;
  font-size: 1.4em;
}
body {
    font-size: 1.2rem; /*increase font-size to 1.2rem*/
}
table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop

@section('content')

@php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
@endphp


            <div class="container-fluid">
                <!-- /row -->

                <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Create Package Inventory 
                                <div class="pull-right">
                                     
                                   
                                </div>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>
                <!--./row-->

                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        
                        <div class="white-box">
                        	
                            <h3 class="box-title">Package Inventory</h3>
                            <td style="font-weight: 600; ">Total Package Inventory Created:</td>
                            <td> 
                               <span class="label label-success"> {{count($pending_packages->openFileDealerInfo)}}</span>
                                </td>
                          
                               <div class=col-md-12 id='original_col' style="overflow-y:auto;height:300px;">
                                <table class="table table-bordered table-responsive-md table-striped text-center">
                                    <thead>
                                        <tr>

                                            <th class="text-center">Unit Type</th>
                                            <th class="text-center">Size</th>
                                            <th class="text-center">Total Quantity</th>
                                            <th class="text-center">No of Inventory Created</th>
                                            <th class="text-center">Add Inventory Quantity</th>
                                            <th class="text-center">Action</th>




                                        </tr>

                                    </thead>
                                    <tbody id="tbody_data">
                                        @php 
                                        $i=0;
                                        @endphp
                                      @foreach ($pending_packages->package->packageDetail as $item)
                                      @php 
                                      $i= 1 + $i;
                                      @endphp
                                        
                                        <tr height="2px" id="account_tr"
                                           >

                                            <td class="pt-3-half account" style="width: 20%" contenteditable="true">


                                                <select class="form-control chosen-select us_acnt"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                   >
                                                    <option selected>{{$item->unitType->name}}</option>
                                                    
                                                </select>
                                            </td>
                                            <td class="pt-3-half name" contenteditable="true">
                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                     >
                                                    <option  selected >{{$item->unitSize->name}} {{$size}}</option>
                                                    

                                                </select>
                                            </td>

                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" id='unit_quantity_{{$i}}' type="number" value='{{$item->unit_quantity}}'  readonly>
                                            </td>
                                            @php 
                                         $val=   \App\OpenFileDealerInfo::getDetail($pending_packages->id,$item->unitType->id,$item->unitSize->id);
                                         
                                          @endphp
                                          @if(!empty($val))
                                                      @php
                                                  $count= count($val);
                                                 @endphp
                                            <td class="pt-3-half name" contenteditable="true">
                                                <input class="form-control" id='already_created_inventory_{{$i}}'  type="number"  
                                                style='width:100%' value={{ $count}}  readonly >
                                            </td>
                                           
                                            @if( $count == $item->unit_quantity || $count > $item->unit_quantity )
                                            <td class="pt-3-half name" contenteditable="true">
                                                <input class="form-control " id='inventory_added_{{$i}}'   type="number" name='inventory_added'
                                                style='width:100%' data-id={{$i}} placeholder="Add..." onkeyup="totalFunction(this)" onclick="totalFunction(this)" readonly >
                                            </td>

                                            <td class="pt-3-half name" contenteditable="true">
                                               
                                               <button type='button' class="btn "  disabled >
                                                Submit
                                               </button>
                                            </td>
                                            @else
                                            <td class="pt-3-half name" contenteditable="true">
                                                <input class="form-control " id='inventory_added_{{$i}}'   type="number" name='inventory_added'
                                                style='width:100%' data-id={{$i}} placeholder="Add..." onkeyup="totalFunction(this)" onclick="totalFunction(this)" >
                                            </td>

                                            <td class="pt-3-half name" contenteditable="true">
                                               
                                               <button type='button' class="btn " onclick='submitData(["{{$item->id}}","{{$pending_packages->id}}","{{$i}}"])'>
                                                Submit
                                               </button>
                                            </td>
                                            @endif
                                            

                                            @else
                                            <td class="pt-3-half name" contenteditable="true">
                                                <input class="form-control"   type="number"  
                                                style='width:100%' id='already_created_inventory_{{$i}}'   readonly  value='0'>
                                            </td>
                                            <td class="pt-3-half name" contenteditable="true">
                                                <input class="form-control " id='inventory_added_{{$i}}'   type="number" name='inventory_added'
                                                style='width:100%' data-id={{$i}} placeholder="Add..." onkeyup="totalFunction(this)" onclick="totalFunction(this)" >
                                            </td>

                                            <td class="pt-3-half name" contenteditable="true">
                                               
                                               <button type='button' class="btn " onclick='submitData(["{{$item->id}}","{{$pending_packages->id}}","{{$i}}"])'>
                                                Submit
                                               </button>
                                            </td>
                                            @endif

                                           
                                            

                                        </tr>

                                        @endforeach

                                      

                                     



                                      



                                    </tbody>
                                </table>
                            </div>
                                @if($pending_packages->inventory_status == \App\DealerPackage::inventory_not_created)
                                <form method="post"   action="{{route('openfile.pending.package.store')}}">
                                    {{ csrf_field() }}
                                   <input type='hidden' name='dealer_package_id' value='{{$pending_packages->id}}'> 
                                   <div class="form-group">
                                    <label for="pwd">Create All Package Open Files Inventory:</label>
                                    <select  class="form-control" name="inventory_created" id="inventory_created">
                                   
                                        <option value="1" >Yes</option>
                                        <option value="0" selected="">Not Yet</option>
                                    
                                    
                                    
                                   </select>
                                  </div>
                                 
                                  <button type="submit" class="btn btn-default">Submit</button>
                              </form>
                                 @endif
                              
                                
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="white-box1 ">
                            <h4 class="box-title " style=" color: white; background-color:#1c3752;line-height: 30px" id="text_detail">&nbsp;&nbsp;Package Information</h4>
                               
                            <div class="pull-left" style="width:100%">
                                <div class="table-responsive">
                                    <table class="table bottom-table" id="main_customer_info">
                                        <tbody class="printFW">
                                            
                                            <tr>
                                                <td style="font-weight: 600; ">Project:</td>
                                                <td> {{$pending_packages->multiProject?$pending_packages->multiProject->name:'None'}}</td>
                                                <td style="font-weight: 600; ">Dealer Name:</td>
                                                <td> {{$pending_packages->dealer->name}}</td>
                                 
                                                <td style="font-weight: 600; ">Dealer Code:</td>
                                                <td>{{$pending_packages->dealer->code}} </td>
                                                <td style="font-weight: 600;">Package Name:</td>
                                                <td>{{$pending_packages->package->name}}  </td>
                                                <td style="font-weight: 600; ">Package Total Amount:</td>
                                                <td>{{$pending_packages->package->total_price}}  PKR</td>
                                              

                                               
                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600; ">Package Issue Date:</td>
                                                <td> {{$pending_packages->issue_date}}</td>
                                 
                                                <td style="font-weight: 600; ">Paid Amount:</td>
                                                <td>{{$paid_amount}} PKR </td>
                                                <td style="font-weight: 600;">Remaining Amount:</td>
                                                <td>{{ $pending_packages->package->total_price - $paid_amount }} PKR </td>
                                                {{-- <td style="font-weight: 600; ">Request Paid Amount:</td>
                                                <td>{{$pending_packages->amount}} PKR </td> --}}
                                              

                                                 
                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600; ">Payment Status:</td>
                                                <td>  @if($pending_packages->payment_status == \App\DealerPackage::pending)
                                                    <span class="label label-danger">Pending</span>
                                                     @elseif($pending_packages->payment_status == \App\DealerPackage::completed)
                                                     <span class="label label-success">Completed</span>
                                                     @endif </td>

                                                     <td style="font-weight: 600; ">Package Inventory:</td>
                                                     <td> 
                                                         @if($pending_packages->inventory_status == \App\DealerPackage::inventory_not_created)
                                                        <span class="label label-danger">Not Created</span>
                                                         @elseif($pending_packages->inventory_status == \App\DealerPackage::inventory_created)
                                                         <span class="label label-success">Created</span>
                                                         @endif
                                                         </td>
                                                         <td style="font-weight: 600; ">Total Package Inventory:</td>
                                                         <td> 
                                                             {{$pending_packages->package->packageDetail->sum('unit_quantity')}}
                                                             </td>
                                                             <td style="font-weight: 600; ">Total Package Inventory Created:</td>
                                                             <td> 
                                                                 {{count($pending_packages->openFileDealerInfo)}}
                                                                 </td>
        
                                            </tr>
            
                                        </tbody>
                                    </table>
            
            
            
                                    
            
            
                                </div>
                                <div class="clear"></div>
                            </div>
                          
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>


<div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':false,
            'searching':false,
            'ordering':false,
            'sorting' : false,
            'info':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        



   







    </script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        


            function submitData(value){
                

                var package_detail_id=value[0];
                var dealer_package_id = value[1];
               var value_of_i= value[2];

           var inventory_quantity=  $('#inventory_added_'+value_of_i).val();
           if(!inventory_quantity){
            Swal.fire(
  'Inventory quantity required',
  
  
)
            return false;
           }

            var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
           
              Swal.fire({
                        title: "Are you sure?",
                        text: "you want to create Inventry!",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                        showCancelButton: true,
                         confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                         confirmButtonText: 'Yes, Sure!',
                         
})
                    .then((result) => {
                        if (result.isConfirmed) {
                            $('.preloader').fadeIn();
                            $.ajax({
                                /* the route pointing to the post function */
                                url: '{{route("openfile.store.package.inventory")}}',
                                type: 'POST',
                                /* send the csrf-token and the input to the controller */
                                data: {
                                    _token: CSRF_TOKEN,
                                    dealer_package_id:dealer_package_id,
                                    package_detail_id:package_detail_id,
                                    inventory_quantity: inventory_quantity
                                    


                                },
                                dataType: 'JSON',
                                /* remind that 'data' is the response of the AjaxController */
                                success: function(response) {
                                    $('.preloader').fadeOut();
                                    if (response.success) {
      Swal.fire({
        title: 'Success!',
        text: response.message,
        type: 'success',
      }).then(function() {
        location.reload();
      });
    } else {
      Swal.fire({
        title: 'Error!',
        text: response.message,
        type: 'error',
      });
    }
                                    



                                }
                            });
                        } else {
                          Swal.fire("Ok No Problem!");
                        }
                    });


                }
          
                function totalFunction(e){
    data_id =  e.getAttribute("data-id"); 
 

created_quantity_val = $('#already_created_inventory_'+data_id).val();
unit_quantity= $('#unit_quantity_'+data_id).val();

rem_val= unit_quantity -created_quantity_val ;
 
rem_val = Math.abs(rem_val);

if(parseInt(e.value) > parseInt(rem_val))
{
    
    $('#inventory_added_'+data_id).val(rem_val);
     
}
 





}
    </script>
@stop