@extends('layouts.app')

@section('title')
    Issue Open File
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i>Home</a></li>
        <li><a href="{{ route('openfile.view') }}">All Open files</a></li>
        <li class="active">Issue Open File</li>
    </ol>
@stop

@section('css')

    <style type="text/css">
        .whitebox3 {
            /* background:#ddd; */
            background:#ededed;
            padding: 18px 25px 10px 25px;
            margin-bottom: 30px;
            border-radius: 4px;
        }
     
        html, body {
	 background: #e3e3d8;
	 font-family: sans-serif;
	 padding: 25px;
}
 .wrapper {
	 width: 300px;
	 height: 500px;
	 background: white;
	 margin: auto;
	 position: relative;
	 overflow: hidden;
	 border-radius: 10px 10px 10px 10px;
	 box-shadow: 0;
	 transform: scale(0.95);
	 transition: box-shadow 0.5s, transform 0.5s;
}
 .wrapper:hover {
	 transform: scale(1);
	 box-shadow: 5px 20px 30px rgba(0, 0, 0, 0.2);
}
 .wrapper .container {
	 width: 100%;
	 height: 100%;
}
 .wrapper .container .top {
	 height: 80%;
	 width: 100%;
	 background: url(https://s-media-cache-ak0.pinimg.com/736x/49/80/6f/49806f3f1c7483093855ebca1b8ae2c4.jpg) no-repeat center center;
	 -webkit-background-size: 100%;
	 -moz-background-size: 100%;
	 -o-background-size: 100%;
	 background-size: 100%;
}
 .wrapper .container .bottom {
	 width: 200%;
	 height: 20%;
	 transition: transform 0.5s;
}
 .wrapper .container .bottom.clicked {
	 transform: translateX(-50%);
}
 .wrapper .container .bottom h1 {
	 margin: 0;
	 padding: 0;
}
 .wrapper .container .bottom p {
	 margin: 0;
	 padding: 0;
}
 .wrapper .container .bottom .left {
	 height: 100%;
	 width: 50%;
	 background: #f4f4f4;
	 position: relative;
	 float: left;
}
 .wrapper .container .bottom .left .details {
	 padding: 20px;
	 float: left;
	 width: calc(70% - 40px);
}
 .wrapper .container .bottom .left .buy {
	 float: right;
	 width: calc(30% - 2px);
	 height: 100%;
	 background: #f1f1f1;
	 transition: background 0.5s;
	 border-left: solid thin rgba(0, 0, 0, 0.1);
}
 .wrapper .container .bottom .left .buy i {
	 font-size: 30px;
	 padding: 30px;
	 color: #254053;
	 transition: transform 0.5s;
}
 .wrapper .container .bottom .left .buy:hover {
	 background: #a6cdde;
}
 .wrapper .container .bottom .left .buy:hover i {
	 transform: translateY(5px);
	 color: #00394b;
}
 .wrapper .container .bottom .right {
	 width: 50%;
	 background: #a6cdde;
	 color: white;
	 float: right;
	 height: 200%;
	 overflow: hidden;
}
 .wrapper .container .bottom .right .details {
	 padding: 20px;
	 float: right;
	 width: calc(70% - 40px);
}
 .wrapper .container .bottom .right .done {
	 width: calc(30% - 2px);
	 float: left;
	 transition: transform 0.5s;
	 border-right: solid thin rgba(255, 255, 255, 0.3);
	 height: 50%;
}
 .wrapper .container .bottom .right .done i {
	 font-size: 30px;
	 padding: 30px;
	 color: white;
}
 .wrapper .container .bottom .right .remove {
	 width: calc(30% - 1px);
	 clear: both;
	 border-right: solid thin rgba(255, 255, 255, 0.3);
	 height: 50%;
	 background: #bc3b59;
	 transition: transform 0.5s, background 0.5s;
}
 .wrapper .container .bottom .right .remove:hover {
	 background: #9b2847;
}
 .wrapper .container .bottom .right .remove:hover i {
	 transform: translateY(5px);
}
 .wrapper .container .bottom .right .remove i {
	 transition: transform 0.5s;
	 font-size: 30px;
	 padding: 30px;
	 color: white;
}
 .wrapper .container .bottom .right:hover .remove, .wrapper .container .bottom .right:hover .done {
	 transform: translateY(-100%);
}
 .wrapper .inside {
	 z-index: 9;
	 background: #92879b;
	 width: 140px;
	 height: 140px;
	 position: absolute;
	 top: -70px;
	 right: -70px;
	 border-radius: 0px 0px 200px 200px;
	 transition: all 0.5s, border-radius 2s, top 1s;
	 overflow: hidden;
}
 .wrapper .inside .icon {
	 position: absolute;
	 right: 85px;
	 top: 85px;
	 color: white;
	 opacity: 1;
}
 .wrapper .inside:hover {
	 width: 100%;
	 right: 0;
	 top: 0;
	 border-radius: 0;
	 height: 80%;
}
 .wrapper .inside:hover .icon {
	 opacity: 0;
	 right: 15px;
	 top: 15px;
}
 .wrapper .inside:hover .contents {
	 opacity: 1;
	 transform: scale(1);
	 transform: translateY(0);
}
 .wrapper .inside .contents {
	 padding: 5%;
	 opacity: 0;
	 transform: scale(0.5);
	 transform: translateY(-200%);
	 transition: opacity 0.2s, transform 0.8s;
}
 .wrapper .inside .contents table {
	 text-align: left;
	 width: 100%;
}
 .wrapper .inside .contents h1, .wrapper .inside .contents p, .wrapper .inside .contents table {
	 color: white;
}
 .wrapper .inside .contents p {
	 font-size: 13px;
}
 
 
  
   
    </style>

@stop

@section('content')

    <div class="container-fluid">
        {{-- <form method="post" action="{{ route('openfile.store') }}" class="form-horizontal" id="receipt_form">
            {{ csrf_field() }} --}}
            <div class="row">
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    @if ($errors->any())
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul>
                                {!! implode(
                                    '',
                                    $errors->all('<li><span
                                                                                                                class="help-block"><strong>:message</strong></span></li>'),
                                ) !!}
                            </ul>
                        </div>
                    @endif
                    <div class="whitebox3">
                        <h3 class="box-title">Issue Open File Package</h3>
                        <p>All Open Files Packages are mentioned below:</p>
                        <hr>

                          {{-- Packages --}}
                          <div class="wrapper">
                            <div class="container">
                              <div class="top"></div>
                              <div class="bottom">
                                <div class="left">
                                  <div class="details">
                                    <h1>Chair</h1>
                                    <p>£250</p>
                                  </div>
                                  <div class="buy"><i class="material-icons">add_shopping_cart</i></div>
                                </div>
                                <div class="right">
                                  <div class="done"><i class="material-icons">done</i></div>
                                  <div class="details">
                                    <h1>Chair</h1>
                                    <p>Added to your cart</p>
                                  </div>
                                  <div class="remove"><i class="material-icons">clear</i></div>
                                </div>
                              </div>
                            </div>
                            <div class="inside">
                              <div class="icon"><i class="material-icons">info_outline</i></div>
                              <div class="contents">
                                <table>
                                  <tr>
                                    <th>Width</th>
                                    <th>Height</th>
                                  </tr>
                                  <tr>
                                    <td>3000mm</td>
                                    <td>4000mm</td>
                                  </tr>
                                  <tr>
                                    <th>Something</th>
                                    <th>Something</th>
                                  </tr>
                                  <tr>
                                    <td>200mm</td>
                                    <td>200mm</td>
                                  </tr>
                                  <tr>
                                    <th>Something</th>
                                    <th>Something</th>
                                  </tr>
                                  <tr>
                                    <td>200mm</td>
                                    <td>200mm</td>
                                  </tr>
                                  <tr>
                                    <th>Something</th>
                                    <th>Something</th>
                                  </tr>
                                  <tr>
                                    <td>200mm</td>
                                    <td>200mm</td>
                                  </tr>
                                </table>
                              </div>
                            </div>
                          </div>
                       
                      
                        
                            
                          {{-- End Packages --}}



                        
                    </div>
                </div>
            </div>
         

    {{-- </form> --}}
    </div>

@stop

@section('js')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script></script>

    <script>
        $(document).ready(function() {

            $('.js-example-basic-multiple').select2({
                placeholder: "Select a Unit"
            }).on('change', function(e) {
                var total_amount = 0;
                $.each($(this).find(":selected"), function(i, item) {
                    total_amount += $(item).data("amount");
                });
                $('#total_amount').val(total_amount);
            });
        });
        $('.buy').click(function(){
  $('.bottom').addClass("clicked");
});

$('.remove').click(function(){
  $('.bottom').removeClass("clicked");
});
 
    </script>
@stop


@if ($errors->any())
    <script>
        window.onload = function() {

            updateProperty('{{ old('customer_id') }}');

            var payment_method = $('#payment_method').val();
            changeFunc(payment_method)
        }
    </script>
@endif
