@extends('layouts.app')

@section('title')
    All Package Payments
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Packages Payments</li>
    </ol>
@stop
@section('css')

    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

    <style>
          .swal-wide{
    /* width:850px !important;
    height: 850px !important; */
    font-size: 1.6rem !important;
}
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }
    </style>

@stop

@section('content')


    <div class="container-fluid">
        <!-- /row -->

        <!--.row-->
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-info">
                    <div class="panel-heading">Package Payments
                        <div class="pull-right">
                            



                        </div>
                    </div>


                </div>
            </div>
        </div>
        <!--./row-->

        <div class="row" id="update-table">
            <div class="col-lg-12">
                <div class="white-box1 ">
                    <h4 class="box-title " style=" color: white; background-color:#1c3752;line-height: 30px"
                        id="text_detail">&nbsp;&nbsp;Package Information</h4>

                    <div class="pull-left" style="width:100%">
                        <div class="table-responsive">
                            <table class="table bottom-table" id="main_customer_info">
                                <tbody class="printFW">

                                    <tr>
                                        <td style="font-weight: 600; ">Dealer Name:</td>
                                        <td> {{ $dealer_package->dealer->name }}</td>

                                        <td style="font-weight: 600; ">Dealer Code:</td>
                                        <td>{{ $dealer_package->dealer->code }} </td>
                                        <td style="font-weight: 600;">Package Name:</td>
                                        <td>{{ $dealer_package->package->name }} </td>
                                        <td style="font-weight: 600; ">Package Total Amount:</td>
                                        <td>{{ $dealer_package->package->total_price }} pkr</td>



                                    </tr>

                                    <tr>
                                        <td style="font-weight: 600; ">Package Issue Date:</td>
                                        <td> {{ $dealer_package->issue_date }}</td>

                                        <td style="font-weight: 600; ">Paid Amount:</td>
                                        <td>{{ $paid_amount }} pkr </td>
                                        <td style="font-weight: 600;">Remaining Amount:</td>
                                        <td>{{ $dealer_package->package->total_price - $paid_amount }} pkr </td>
                                        <td style="font-weight: 600;">Rebate Type:</td>
                                        <td><span class="label label-success">{{ $dealer_package->package->rebate_type  }}</span>  </td>




                                    </tr>
                                  
                                    <tr>
                                        @if($dealer_package->package->rebate_type  == 'cash')
                                        <td style="font-weight: 600;">Total Rebate:</td>
                                        <td>{{ $dealer_package->package->rebate_amount  }} pkr </td>
                                        @elseif($dealer_package->package->rebate_type  == 'openfile')
                                        <td style="font-weight: 600;">Remaining Rebate Amount:</td>
                                        <td>{{ $dealer_package->package->remaining_rebate  }} pkr </td>
                                        @endif
                                        <td style="font-weight: 600; ">Payment Status:</td>
                                        <td>
                                            @if ($dealer_package->payment_status == \App\DealerPackage::pending)
                                                <span class="label label-danger">Pending</span>
                                            @elseif($dealer_package->payment_status == \App\DealerPackage::completed)
                                                <span class="label label-success">Completed</span>
                                            @endif
                                        </td>

                                        <td style="font-weight: 600; ">Package Inventory:</td>
                                        <td>
                                            @if ($dealer_package->is_approved == \App\DealerPackage::inventory_not_created)
                                                <span class="label label-danger">Not Created</span>
                                            @elseif($dealer_package->is_approved == \App\DealerPackage::inventory_created)
                                                <span class="label label-success">Created</span>
                                            @endif
                                        </td>

                                    </tr>




                                </tbody>
                            </table>






                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">


                <div class="white-box">

                    <h3 class="box-title">All Payments</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr. No.</th>

                                    <th>Paid Amount</th>
                                    <th>Payment Status</th>
                                    <th>Payment Date</th>

                                    <th>Action</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                                @foreach ($dealer_payment as $dp)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>
                                            {{ $dp->amount }} pkr
                                        </td>
                                        <td>
                                            @if ($dp->is_approved == 0)
                                                <span class="label label-danger">Pending</span>
                                            @elseif($dp->is_approved == 1)
                                                <span class="label label-success">Approved</span>
                                            @endif

                                        </td>
                                        <td>
                                            {{ date('y-m-d', strtotime($dp->receipt_date)) }}
                                        </td>
                                        <td>
                                            <a href="{{route('openfile.package.detailReceipt',['id'=>$dp->id])}}"
                                                data-toggle="tooltip" data-original-title="Receipt"> <i
                                                    class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                        </td>
                                    </tr>
                                @endforeach



                            </tbody>
                        </table>
                        <div style="float: right;"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">

    </div>


    <div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">

    </div>

@stop

@section('js')

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    <script>
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': false,
                'searching': false,
                'ordering': false,
                'sorting': false,
                'info': false,
                'dom': 'Bfrtip',
                'buttons': [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });

        $('.search-customer').on('click', function() {
            $('.preloader').fadeIn();
            unit = $('#unit').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            status = $('#status').val();
            unit_size = $('#unit_size').val();
            unit_type = $('#unit_type').val();
            unit_block = $('#unit_block').val();

            if (unit == 0 && customer == 0 && status == 0 && dealer == 0 && unit_size == 0 && unit_type == 0 &&
                unit_block == 0) {
                toastr.warning("please select any option.");
                $('.preloader').fadeOut();
                return false;
            }

            var data = {
                'unit': unit,
                'customer': customer,
                'dealer': dealer,
                'status': status,
                'unit_size': unit_size,
                'unit_type': unit_type,
                'unit_block': unit_block
            };
            $.get('/statement/updateTable', data, function(data) {
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': false,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });
                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });
        });




        function openSmsModal(property_id) {

            var data = {
                'property_id': property_id
            };
            $.get('/update_sms_modal', data, function(data) {
                document.getElementById('exampleModal').innerHTML = data;
                $('#exampleModal').modal();
            });
        }

        function openReminderModal(property_id) {

            var data = {
                'property_id': property_id
            };
            $.get('/update_reminder_modal', data, function(data) {
                document.getElementById('exampleModal1').innerHTML = data;
                $('#exampleModal1').modal();
            });
        }
    </script>
   
@stop
