@extends('layouts.app')

@section('title')Package Payment Receipt @stop

@section('css')
    <style type="text/css">
        /*.page-wrapper {
        margin-top: -55px;
        padding-bottom: 0px;
    }*/

        .container-fluid {
            padding: 3px 30px 0;
        }

        @media print {
            .page-wrapper {
                font-size: 12px !important;
                font-family: "time-new-roman", Arial, sans-serif !important;
                padding-top: 0px !important;
                padding-bottom: 0;
            }

            h3 {
                margin: 0;
                line-height: 1;
            }

            .white-box {
                border: none !important;
            }
        }
    </style>
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right no-print">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer')
            <li><a href="{{route('openfile.package.payments',$dealerpaid->id)}}">All Package Payment</a></li>
        @endpermission
        <li class="active"> Package Payment Receipt Detail</li>
    </ol>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row printableArea" id="content">
            <!-- /row -->
            <br>
            <div class="row no-print">
                <div class="col-sm-12">
                    <div class="white-box">
                        <h3 class="box-title">

                            <div class="row">
                                <div class="col-sm-6" style="margin-top: 1rem;">
                                    <span> Payment Information</span>
                                </div>

                                <div class="col-sm-6">
                                     
                                </div>
                            </div>

                        </h3>
                        <hr>

                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td>Receipt Number:</td>
                                        <td>{{$dealerpaid->receipt_no}}</td>
                                    </tr>
                                    <tr>
                                        <td>Date</td>
                                        <td>{{ date('Y-m-d',strtotime($dealerpaid->receipt_date))}}</td>
                                    </tr>
                                    <tr>
                                        <td>Dealer</td>
                                        <td>{{$dealerpaid->dealerPackage->dealer->code}} --- {{$dealerpaid->dealerPackage->dealer->name}} </td>
                                    </tr>
                                    <tr>
                                        <td>Package.</td>
                                        <td>{{$dealerpaid->dealerPackage->package->name}} 
                                        </td>
                                    </tr>
                                    
                                    <tr>
                                        <td>Payment Mode</td>

                                        <td>

                                            @if (!empty($dealerpaid->payment_method))

                                            @if ($dealerpaid->payment_method == \App\Receipt::cash)
                                                Cash
                                            @elseif($dealerpaid->payment_method == \App\Receipt::bank)
                                                Bank
                                            @elseif($dealerpaid->payment_method == \App\Receipt::cheque)
                                                Cheque/ DD/ PO
                                            @else
                                                Adjustment
                                            @endif
                                        @else
                                            @if ($dealerpaid->payment_mode == \App\Receipt::cash)
                                                Cash
                                            @elseif($dealerpaid->payment_mode == \App\Receipt::bank)
                                                Bank
                                            @elseif($dealerpaid->payment_mode == \App\Receipt::cheque)
                                                Cheque/ DD/ PO
                                            @else
                                                Adjustment
                                            @endif
    
    
                                        @endif
    



                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Payment Amount</td>

                                        <td>{{$dealerpaid->amount}} pkr



                                        </td>
                                    </tr>

                                    
                                </tbody>

                            </table>

                           

                        </div>

                    </div>

                </div>
            </div>

            <div class="col-lg-12">
                <div class="white-box">

                    <div class="row " style="text-transform: uppercase; font-weight: 600;">

                        <div class="col-sm-12 col-xs-12 text-center">
                            <h3><strong>
                                @if($dealerpaid)
                                    @if($dealerpaid->multiProject)
                                        {{ $dealerpaid->multiProject->name }}
                                    @endif
                                @endif
                            </strong></h3>
                            <h3><strong>Payment Receipt</strong></h3> <span class="payment">Office Copy</span>
                        </div>

                        <div class="col-sm-12 col-xs-12">

                            <div class="row">

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                    <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp;
                                        {{$dealerpaid->receipt_no}} </div>
                                </div>

                                <div class="col-sm-4 col-xs-4"> &nbsp; </div>

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-2 col-xs-2"><b>Ref.No.</b></div>
                                    <div class="col-sm-10 col-xs-10">&nbsp;</div>
                                    <br>
                                    <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                    <div class="col-sm-10 col-xs-10">
                                        <strong> {{ date('Y-m-d',strtotime($dealerpaid->receipt_date))}}</strong>
                                    </div>
                                </div>

                                <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>

                                <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp;
                                    {{$dealerpaid->dealerPackage->dealer->name}}   </div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-7 col-xs-5">
                                    <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                    <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;

                                        <?php $c = str_split($dealerpaid->dealerPackage->dealer->cnic, 1); ?>

                                        <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?>

                                        @if ($i == 5 || $i == 12)
                                            -
                                        @endif {{ $c[$i] }}

                                        <?php } ?>

                                    </div>
                                </div>

                                <div class="col-sm-5 col-xs-7">
                                    <div class="col-sm-6 col-xs-6"> On account of Package </div>
                                    <div class="col-sm-6 col-xs-6" style="border-bottom: 1px dotted">
                                        &nbsp; {{$dealerpaid->dealerPackage->package->name}} 
                                    </div>
                                </div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                


                               
                               


                                

                                <div class="clearfix" style="margin-bottom: 8px"></div>
                                <div class="col-xs-6 col-sm-6">
                                    Payment Head:

                                    @if ($dealerpaid->payment_head == \App\CustomerStatement::down_payment)


                                        @if ($dealerpaid->property->booking_type == \App\CustomerProperty::full_payment)
                                            {{ 'Full Payment' }}
                                        @else
                                            {{ 'Down Payment' }}
                                        @endif
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::possession)
                                        Possession Fee
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::installment)
                                        Installment
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::other)
                                        Other
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::allotment)
                                        Allotment
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::confirmation)
                                        Confirmation
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::booking)
                                        Booking
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::development)
                                        Development
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::file_processing)
                                        File Processing
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::registration)
                                        Registration
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::transfer_fee)
                                        Transfer Fee
                                        @elseif($dealerpaid->payment_head == \App\Receipt::package_payment)
                                     Package Payment
                                    @endif



                                </div>


                                <div class="col-xs-6 col-sm-6">
                                    Payment Mode:


                                    @if (!empty($dealerpaid->payment_method))

                                        @if ($dealerpaid->payment_method == \App\Receipt::cash)
                                            Cash
                                        @elseif($dealerpaid->payment_method == \App\Receipt::bank)
                                            Bank
                                        @elseif($dealerpaid->payment_method == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif
                                    @else
                                        @if ($dealerpaid->payment_mode == \App\Receipt::cash)
                                            Cash
                                        @elseif($dealerpaid->payment_mode == \App\Receipt::bank)
                                            Bank
                                        @elseif($dealerpaid->payment_mode == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif


                                    @endif

                                </div>

                                @if ($dealerpaid->payment_method == \App\Receipt::adjustment)


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                        Adjustment Type:

                                        @if ($dealerpaid->adjustment_type == \App\Receipt::property)
                                            Property
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::vehicle)
                                            Vehicle
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::rebate)
                                            Rebate &nbsp;&nbsp;<span>(
                                                {{ $dealerpaid->rebate->property->inventory->unit_number }} )</span>
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::vendor)
                                            Vendor bill &nbsp;&nbsp;<span>( PO-{{ $dealerpaid->vendor_purchase_order_id }}
                                                )</span>
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::token_receipt)
                                            Token
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::others)
                                            Others
                                        @endif


                                    </div>


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                        Adjustment Details .
                                        <span>{{ $dealerpaid->adjustment_detail }}</span>

                                    </div>


                                @endif


                                @if ($dealerpaid->tax_paid_by == \App\Receipt::company)
                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">
                                        Tax Amount: &nbsp;&nbsp;&nbsp;{{ number_format($dealerpaid->tax_amount) }}

                                    </div>
                                @endif


                                @if ($dealerpaid->payment_method == \App\Receipt::bank || $dealerpaid->payment_method == \App\Receipt::cheque)
                                    <div class="col-xs-4 col-sm-4">
                                        <span class="pull-left">Instruement No.&nbsp;</span>
                                        <div style="border-bottom: 1px dotted;display: flex;">
                                            {{ $dealerpaid->cheque_number }}
                                            <strong></strong>
                                        </div>
                                    </div>

                                    <div class="col-xs-2 col-sm-2">
                                        <b>Drawn ON:</b>
                                        <strong>{{ date('d-m-Y', strtotime($dealerpaid->drawn_date)) }}</strong>
                                    </div>
                                @endif

                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-1 col-xs-1">PKR</div>
                                <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">
                                    &nbsp;<strong>
                                        @if ($dealerpaid->tax_paid_by == \App\Receipt::company)
                                            {{ number_format($dealerpaid->amount + $dealerpaid->tax_amount) }}
                                        @else
                                            {{ number_format($dealerpaid->amount) }}
                                        @endif
                                    </strong></div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                {{-- <div class="col-sm-1 col-xs-1">PKR</div>
                                <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">
                                    &nbsp;<strong>
                                        {{$dealerpaid->amount}}
                                    </strong></div>
                                <div class="clearfix" style="margin-bottom: 8px"></div> --}}

                                <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                                <div class="col-sm-9 col-xs-8"><b>{{$words}}</b></div>
                                <div class="clearfix" style="margin-bottom: 70px"></div>

                                <div class="col-xs-8 col-sm-8">
                                    <b style="border-top: 1px solid;">Payment Received By</b>
                                </div>
                                <div class="col-sm-4 col-xs-4">
                                    <b style="border-top: 1px solid;">Payment Approved By</b>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="sperator"></div>

            <div class="col-lg-12">
                <div class="white-box">

                    <div class="row " style="text-transform: uppercase; font-weight: 600;">
                        <div class="col-sm-12 col-xs-12 text-center">
                            <h3><strong>
                                @if($dealerpaid)
                                    @if($dealerpaid->multiProject)
                                        {{ $dealerpaid->multiProject->name }}
                                    @endif
                                @endif
                            </strong></h3>
                            <h3><strong>Payment Receipt</strong></h3> <span class="payment">ACCOUNTS COPY</span>
                        </div>

                        <div class="col-sm-12 col-xs-12">

                            <div class="row">

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                    <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp;
                                        {{$dealerpaid->receipt_no}}    </div>
                                </div>

                                <div class="col-sm-4 col-xs-4"> &nbsp; </div>

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-2 col-xs-2"><b>Ref.No.</b></div>
                                    <div class="col-sm-10 col-xs-10">&nbsp;</div>
                                    <br>
                                    <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                    <div class="col-sm-10 col-xs-10">
                                        <strong> {{ date('Y-m-d',strtotime($dealerpaid->receipt_date))}}</strong>
                                    </div>
                                </div>

                                <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>

                                <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp;
                                    {{$dealerpaid->dealerPackage->dealer->name}}   </div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-7 col-xs-5">
                                    <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                    <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;

                                        <?php $c = str_split($dealerpaid->dealerPackage->dealer->cnic, 1); ?>

                                        <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?>

                                        @if ($i == 5 || $i == 12)
                                            -
                                        @endif {{ $c[$i] }}

                                        <?php } ?>

                                    </div>
                                </div>

                                <div class="col-sm-5 col-xs-7">
                                    <div class="col-sm-6 col-xs-6"> On account of Package </div>
                                    <div class="col-sm-6 col-xs-6" style="border-bottom: 1px dotted">
                                        &nbsp; {{$dealerpaid->dealerPackage->package->name}} 
                                    </div>
                                </div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                

 
                               


                                

                                <div class="clearfix" style="margin-bottom: 8px"></div>
                                <div class="col-xs-6 col-sm-6">
                                    Payment Head:

                                    @if ($dealerpaid->payment_head == \App\CustomerStatement::down_payment)


                                        @if ($dealerpaid->property->booking_type == \App\CustomerProperty::full_payment)
                                            {{ 'Full Payment' }}
                                        @else
                                            {{ 'Down Payment' }}
                                        @endif
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::possession)
                                        Possession Fee
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::installment)
                                        Installment
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::other)
                                        Other
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::allotment)
                                        Allotment
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::confirmation)
                                        Confirmation
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::booking)
                                        Booking
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::development)
                                        Development
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::file_processing)
                                        File Processing
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::registration)
                                        Registration
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::transfer_fee)
                                        Transfer Fee
                                        @elseif($dealerpaid->payment_head == \App\Receipt::package_payment)
                                     Package Payment
                                    @endif



                                </div>


                                <div class="col-xs-6 col-sm-6">
                                    Payment Mode:


                                    @if (!empty($dealerpaid->payment_method))

                                        @if ($dealerpaid->payment_method == \App\Receipt::cash)
                                            Cash
                                        @elseif($dealerpaid->payment_method == \App\Receipt::bank)
                                            Bank
                                        @elseif($dealerpaid->payment_method == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif
                                    @else
                                        @if ($dealerpaid->payment_mode == \App\Receipt::cash)
                                            Cash
                                        @elseif($dealerpaid->payment_mode == \App\Receipt::bank)
                                            Bank
                                        @elseif($dealerpaid->payment_mode == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif


                                    @endif

                                </div>

                                @if ($dealerpaid->payment_method == \App\Receipt::adjustment)


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                        Adjustment Type:

                                        @if ($dealerpaid->adjustment_type == \App\Receipt::property)
                                            Property
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::vehicle)
                                            Vehicle
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::rebate)
                                            Rebate &nbsp;&nbsp;<span>(
                                                {{ $dealerpaid->rebate->property->inventory->unit_number }} )</span>
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::vendor)
                                            Vendor bill &nbsp;&nbsp;<span>( PO-{{ $dealerpaid->vendor_purchase_order_id }}
                                                )</span>
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::token_receipt)
                                            Token
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::others)
                                            Others
                                        @endif


                                    </div>


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                        Adjustment Details .
                                        <span>{{ $dealerpaid->adjustment_detail }}</span>

                                    </div>


                                @endif


                                @if ($dealerpaid->tax_paid_by == \App\Receipt::company)
                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">
                                        Tax Amount: &nbsp;&nbsp;&nbsp;{{ number_format($dealerpaid->tax_amount) }}

                                    </div>
                                @endif


                                @if ($dealerpaid->payment_method == \App\Receipt::bank || $dealerpaid->payment_method == \App\Receipt::cheque)
                                    <div class="col-xs-4 col-sm-4">
                                        <span class="pull-left">Instruement No.&nbsp;</span>
                                        <div style="border-bottom: 1px dotted;display: flex;">
                                            {{ $dealerpaid->cheque_number }}
                                            <strong></strong>
                                        </div>
                                    </div>

                                    <div class="col-xs-2 col-sm-2">
                                        <b>Drawn ON:</b>
                                        <strong>{{ date('d-m-Y', strtotime($dealerpaid->drawn_date)) }}</strong>
                                    </div>
                                @endif

                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-1 col-xs-1">PKR</div>
                                <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">
                                    &nbsp;<strong>
                                        @if ($dealerpaid->tax_paid_by == \App\Receipt::company)
                                            {{ number_format($dealerpaid->amount + $dealerpaid->tax_amount) }}
                                        @else
                                            {{ number_format($dealerpaid->amount) }}
                                        @endif
                                    </strong></div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>
{{-- 
                                <div class="col-sm-1 col-xs-1">PKR</div>
                                <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">
                                    &nbsp;<strong>
                                        {{$dealerpaid->amount}}
                                    </strong></div>
                                <div class="clearfix" style="margin-bottom: 8px"></div> --}}

                                <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                                <div class="col-sm-9 col-xs-8"><b>{{$words}}</b></div>
                                <div class="clearfix" style="margin-bottom: 70px"></div>

                                <div class="col-xs-8 col-sm-8">
                                    <b style="border-top: 1px solid;">Payment Received By</b>
                                </div>
                                <div class="col-sm-4 col-xs-4">
                                    <b style="border-top: 1px solid;">Payment Approved By</b>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="sperator"></div>


            <div class="col-lg-12">
                <div class="white-box">

                    <div class="row " style="text-transform: uppercase; font-weight: 600;">

                        <div class="col-sm-12 col-xs-12 text-center">
                            <h3><strong>
                                @if($dealerpaid)
                                    @if($dealerpaid->multiProject)
                                        {{ $dealerpaid->multiProject->name }}
                                    @endif
                                @endif
                            </strong></h3>
                            <h3><strong>Payment Receipt</strong></h3> <span class="payment">DEALER COPY</span>
                        </div>

                        <div class="col-sm-12 col-xs-12">

                            <div class="row">

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                    <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp;
                                        {{$dealerpaid->receipt_no}} </div>
                                </div>

                                <div class="col-sm-4 col-xs-4"> &nbsp; </div>

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-2 col-xs-2"><b>Ref.No.</b></div>
                                    <div class="col-sm-10 col-xs-10">&nbsp;</div>
                                    <br>
                                    <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                    <div class="col-sm-10 col-xs-10">
                                        <strong> {{ date('Y-m-d',strtotime($dealerpaid->receipt_date))}}</strong>
                                    </div>
                                </div>

                                <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>

                                <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp;
                                    {{$dealerpaid->dealerPackage->dealer->name}}   </div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-7 col-xs-5">
                                    <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                    <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;

                                        <?php $c = str_split($dealerpaid->dealerPackage->dealer->cnic, 1); ?>

                                        <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?>

                                        @if ($i == 5 || $i == 12)
                                            -
                                        @endif {{ $c[$i] }}

                                        <?php } ?>

                                    </div>
                                </div>

                                <div class="col-sm-5 col-xs-7">
                                    <div class="col-sm-6 col-xs-6"> On account of Package </div>
                                    <div class="col-sm-6 col-xs-6" style="border-bottom: 1px dotted">
                                        &nbsp; {{$dealerpaid->dealerPackage->package->name}} 
                                    </div>
                                </div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                


                                 

                               


                                

                                <div class="clearfix" style="margin-bottom: 8px"></div>
                                <div class="col-xs-6 col-sm-6">
                                    Payment Head:

                                    @if ($dealerpaid->payment_head == \App\CustomerStatement::down_payment)


                                        @if ($dealerpaid->property->booking_type == \App\CustomerProperty::full_payment)
                                            {{ 'Full Payment' }}
                                        @else
                                            {{ 'Down Payment' }}
                                        @endif
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::possession)
                                        Possession Fee
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::installment)
                                        Installment
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::other)
                                        Other
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::allotment)
                                        Allotment
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::confirmation)
                                        Confirmation
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::booking)
                                        Booking
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::development)
                                        Development
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::file_processing)
                                        File Processing
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::registration)
                                        Registration
                                    @elseif($dealerpaid->payment_head == \App\CustomerStatement::transfer_fee)
                                        Transfer Fee
                                        @elseif($dealerpaid->payment_head == \App\Receipt::package_payment)
                                     Package Payment
                                    @endif



                                </div>


                                <div class="col-xs-6 col-sm-6">
                                    Payment Mode:


                                    @if (!empty($dealerpaid->payment_method))

                                        @if ($dealerpaid->payment_method == \App\Receipt::cash)
                                            Cash
                                        @elseif($dealerpaid->payment_method == \App\Receipt::bank)
                                            Bank
                                        @elseif($dealerpaid->payment_method == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif
                                    @else
                                        @if ($dealerpaid->payment_mode == \App\Receipt::cash)
                                            Cash
                                        @elseif($dealerpaid->payment_mode == \App\Receipt::bank)
                                            Bank
                                        @elseif($dealerpaid->payment_mode == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif


                                    @endif

                                </div>

                                @if ($dealerpaid->payment_method == \App\Receipt::adjustment)


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                        Adjustment Type:

                                        @if ($dealerpaid->adjustment_type == \App\Receipt::property)
                                            Property
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::vehicle)
                                            Vehicle
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::rebate)
                                            Rebate &nbsp;&nbsp;<span>(
                                                {{ $dealerpaid->rebate->property->inventory->unit_number }} )</span>
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::vendor)
                                            Vendor bill &nbsp;&nbsp;<span>( PO-{{ $dealerpaid->vendor_purchase_order_id }}
                                                )</span>
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::token_receipt)
                                            Token
                                        @elseif($dealerpaid->adjustment_type == \App\Receipt::others)
                                            Others
                                        @endif


                                    </div>


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                        Adjustment Details .
                                        <span>{{ $dealerpaid->adjustment_detail }}</span>

                                    </div>


                                @endif


                                @if ($dealerpaid->tax_paid_by == \App\Receipt::company)
                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">
                                        Tax Amount: &nbsp;&nbsp;&nbsp;{{ number_format($dealerpaid->tax_amount) }}

                                    </div>
                                @endif


                                @if ($dealerpaid->payment_method == \App\Receipt::bank || $dealerpaid->payment_method == \App\Receipt::cheque)
                                    <div class="col-xs-4 col-sm-4">
                                        <span class="pull-left">Instruement No.&nbsp;</span>
                                        <div style="border-bottom: 1px dotted;display: flex;">
                                            {{ $dealerpaid->cheque_number }}
                                            <strong></strong>
                                        </div>
                                    </div>

                                    <div class="col-xs-2 col-sm-2">
                                        <b>Drawn ON:</b>
                                        <strong>{{ date('d-m-Y', strtotime($dealerpaid->drawn_date)) }}</strong>
                                    </div>
                                @endif

                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-1 col-xs-1">PKR</div>
                                <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">
                                    &nbsp;<strong>
                                        @if ($dealerpaid->tax_paid_by == \App\Receipt::company)
                                            {{ number_format($dealerpaid->amount + $dealerpaid->tax_amount) }}
                                        @else
                                            {{ number_format($dealerpaid->amount) }}
                                        @endif
                                    </strong></div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>
                                {{-- <div class="col-sm-1 col-xs-1">PKR</div>
                                <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">
                                    &nbsp;<strong>
                                        {{$dealerpaid->amount}}
                                    </strong></div>
                                <div class="clearfix" style="margin-bottom: 8px"></div> --}}

                                <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                                <div class="col-sm-9 col-xs-8"><b>{{$words}}</b></div>
                                <div class="clearfix" style="margin-bottom: 70px"></div>

                                <div class="col-xs-8 col-sm-8">
                                    <b style="border-top: 1px solid;">Payment Received By</b>
                                </div>
                                <div class="col-sm-4 col-xs-4">
                                    <b style="border-top: 1px solid;">Payment Approved By</b>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="sperator"></div>
        </div>
        <div style="display: inline-block; ">
            <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
                <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button">
                    <span><i class="fa fa-print"></i> Print</span> </button>
            </div>
        </div>

    </div>
    <!-- /.container-fluid -->



@stop

@section('js')

    <script src="{{ asset('js/jquery.PrintArea.js') }}" type="text/JavaScript"></script>
    <script>
        function upload_receipt_docs(self, receipt_id) {
            $('#upload_btn').html('Uploading...')
            $('#upload_btn').prop('disabled', true)

            var form_data = new FormData();

            // Read selected files
            var totalfiles = document.getElementById('files').files.length;

            for (var index = 0; index < totalfiles; index++) {
                form_data.append("files[]", document.getElementById('files').files[index]);
            }

            form_data.append("receipt_id", receipt_id);


            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // AJAX request
            $.ajax({
                url: "{{ route('receipt.document') }}",
                type: 'post',
                data: form_data,
                dataType: 'json',
                contentType: false,
                processData: false,
                success: function(data) {

                    if (data.response == 'yes') {
                        $('#success_message').html('Uploaded')
                        $('#success_message').show()
                        $('#error_message').hide()
                        location.reload(true);
                    } else if (data.response == 'invalid_document') {
                        $('#upload_btn').html('Upload')
                        $('#upload_btn').prop('disabled', false)
                        $('#error_message').html(data.message)
                        $('#error_message').show()
                    } else {
                        alert('Error! sonething went wrong.')
                        location.reload(true);
                    }

                }
            });



            return false;
        }

        $(function() {
            $("#print").on("click", function() {
                var mode = 'iframe'; //popup
                var close = mode == "popup";
                var options = {
                    mode: mode,
                    popClose: close
                };
                $("div.printableArea").printArea(options);
            });
        });
    </script>
    <script>
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    </script>


@stop
