@extends('layouts.app')

@section('title')
All Receipts 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Dealer Receipts</li>
      </ol>
@stop

@section('content')


            <div class="container-fluid">


                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">

                            <div class="pull-right">


                                <a href="{{route('receipt.package-approved.all')}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Approve All 
                                </a>
                            </div>
                            
                            <h3 class="box-title">All Dealer Pending Receipts</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Project</th>
                                            <th>Receipt No.</th>
                                            <th>Dealer </th>
                                            <th>Package </th>
                                            <th>Payment Method</th>
                                            <th>Payment Head</th>
                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                

                                        @foreach($receipts as $receipt)
                            <tr>
                                <td>{{$receipt->multiProject?$receipt->multiProject->name:'None'}}</td>
                            <td>{{$receipt->receipt_no}}</td>
                            <td>{{$receipt->dealer->code}} --- {{$receipt->dealer->name}}</td>

                            <td>{{$receipt->dealerPackage->package->name}}</td>












    

                            @if($receipt->payment_method == \App\Receipt::cash)
                            <td>Cash</td>
                            @elseif($receipt->payment_method == \App\Receipt::bank)
                            <td>Bank</td>
                            @elseif($receipt->payment_method == \App\Receipt::adjustment)
                            <td>Adjustment</td>
                            @elseif($receipt->payment_method == \App\Receipt::cheque)
                            <td>Cheque</td>
                             @elseif($receipt->payment_method == \App\Receipt::merging)
                                            <td>Merging</td>
                            @else
                            <td></td>
                            @endif

                            @if($receipt->payment_head == \App\Receipt::package_payment)
                            <td>Package Payment</td>
                            @elseif($receipt->payment_head == \App\Receipt::package_rebate)
                            <td>Package Rebate Remaining</td>
                            @endif
                                 

                            
                            @if($receipt->tax_paid_by == \App\Receipt::company)
                            <td>{{number_format($receipt->amount + $receipt->tax_amount)}} PKR</td>
                            @else
                            <td>{{number_format($receipt->amount)}} PKR</td>
                            @endif
                            <td> {{date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
                            <td class="text-nowrap">

                            <a href="{{route('openfile.package.detailReceipt',['id'=>$receipt->id])}}" class="btn btn-default">View</a>



                            {{-- <a href="{{route('receipt.editView',['id'=>$receipt->id])}}"  class="btn btn-success"> Edit </a> --}}

                            <a  href="{{route('receipt.package-payment.view',['id'=>$receipt->id])}}" class="btn btn-success" style="background: #4aa200; border: 1px solid #4aa200;"> 
                            Approve 
                            </a>

                            {{-- @if($receipt->payment_method == \App\Receipt::cheque)
                                <a  href="{{route('receipt.cancelled',['id'=>$receipt->id])}}" class="btn btn-warning" data-toggle="confirmation" data-placement="left" data-title="Are you sure to Cancel?"> 
                                Cancel 
                                </a>
                             @endif --}}
                             <form action="{{ route('dealer-receipt.delete', ['id'=>$receipt->id])}}"
                                 method="post" style='display: inline;'>
                                 {!! method_field('delete') !!}
                                 {!! csrf_field() !!}


                                 <button class="btn btn-danger" type="submit" name="action"
                                     value="delete" data-toggle="confirmation" data-title="Are you sure to
                                     delete?">Delete</button>
                             </form>





                            </td>
                            </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                                <br>
                                <br>
                                <br>
                                <br>
                                <div style="float: right;">{{$receipts->links()}}</div>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
      $('#myTable').DataTable({
            'pageLength':25,
            'paging':false,
            'searching':false,
            'info':false,
            'sorting':false,
            'ordering':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });
        $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            plot = $('#plot').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            payment_head = $('#payment_head').val();
            payment_mode = $('#payment_mode').val();
            receipt_no= $('#receipt_no').val();

            if(plot == 0  && customer== 0 && dealer == 0 && payment_head == 0 && payment_mode == 0 && receipt_no ==0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {'plot':plot,'customer':customer,'dealer':dealer,'payment_mode':payment_mode,'payment_head':payment_head,'receipt_no':receipt_no};
            $.get('/receipt/updateTable',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                 $('#myTable').DataTable({
                'pageLength':50,
                'paging':true,
                'searching':false,
                'info':true,
                'dom': 'Bfrtip',
                'sorting':false,
                'ordering':false,
                "aaSorting": [[ 5, "asc" ]] ,
                'buttons': [
                'copy', 'csv', 'excel', 'pdf', 'print'
                ]
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });
    </script>
@stop