@extends('layouts.app')

@section('title')
Registration Letter
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
    @permission('view-openfile')
        <li><a href="{{ route('openfile.view') }}">All Open File Packages List</a></li>
    @endpermission
    <li class="active">Registration Letter</li>
</ol>
@stop

@section('css')
<style type="text/css">
    .application {
        text-align: center;
        font-weight: bold;
        background-color: #195754;
        color: white;
        margin-bottom: -1px;
        width: 99%;
        margin-left: 8px;
    }

    .table-bordered {
        border: 1px solid #000000 !important;
    }

    .printFH11 th {
        color: #000000 !important;
    }

    .white-box {
        border: none !important;
    }

    .white-box .box-title {
        background-color: #000000 !important;
        color: #fff !important;
    }

    .page-wrapper {
        padding-bottom: 0px;
    }

    .mtn95 {
        margin-top: 400px;
    }

    h1 {
        font-weight: bold;
        color: #315650;
    }

    .container {
        display: table;
        min-width: 100%;
    }

    .table-row {
        display: table-row;
        height: 130px;
    }

    .table-cell {
        display: table-cell;
        font-size: 12px;
    }

    @page {
        size: a4;
    }

    .pag {
        margin-top: 3.9in;
        margin-right: 1in;
        font-weight: bold;
    }

    /* .pagg {
        margin-top: 3.9in;
        margin-right: 4.2in;
    } */
</style>
@stop

@section('content')
<!-- .container-fluid -->
<div class="container-fluid">
    <div class="pag">
        <div class="col-sm-6 col-xs-6" style="margin-top: -1.4cm;">
            <p>APP FORM NO: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>{{$property->inventory->dealerPackageOpenFileUnit->endUserForm->app_form_no}}</p>
            <p>REGISTRATION NO: <span>&nbsp;</span>FT/GR/10M/0123</p>
            <p>PLOT SIZE: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>{{ $property->inventory->size->name }} {{env('SIZE')}}</p>
            <p>CATEGORY: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span style="text-transform: uppercase;">{{ $property->inventory->type->name }}</p>
            <p>OLD REG NO: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>xxxxxxxxx</p><br><br>
            <p style="font-size: 10px; font-weight: bold">PRINTING DATE:
                <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                @php
                    $current_date = date("d-m-Y");
                @endphp
                {{ $current_date }}
            </p>
        </div>
    </div>

    <div class="col-sm-6 col-xs-6" style="margin-bottom: 2in;  font-weight: bold; margin-top: -1.4cm;">
        <p>NAME: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>{{ $property->customer->name }}</p>
        <p>S/D/W: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>{{ $property->customer->father_name }}</p>
        <p>CNIC: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>{{ $property->customer->cnic }}</p>
        <p>CELL NO: <span>&nbsp;&nbsp;&nbsp;&nbsp;</span>{{ $property->customer->mobile_number }}</p>
        <p>EMAIL: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>{{ $property->customer->email ? $property->customer->email : "XXXXXXXXXXXX" }}</p>
        <p>ADDRESS: <span>&nbsp;&nbsp;</span>{{ $property->customer->mailing_address }}</p>
    </div>
    
</div>  
<!-- ./container-fluid -->
    
    <div style="display: inline-block;    margin-bottom: 70px;">
        <div class="text-right" style="display: inline-block;">
            <button id="print" class="btn btn-default btn-outline no-print" type="button"
                onclick="return print_whole_statement()"> <span><i class="fa fa-print"></i>Print</span>
            </button>
        </div>
    </div>
@stop

@section('js')

<script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
</script>

<script>
    function print_whole_statement() {

        window.print();
        return false;
    }
</script>
@stop