@extends('layouts.app')

@section('title')
Registration form
@stop

    @section('breadcrumb')
    <ol class="breadcrumb pull-right no-print">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-openfile')
            <li><a href="{{ route('openfile.view') }}">All Open File Packages List</a></li>
        @endpermission
        <li class="active">Registration Form</li>
    </ol>
    @stop

        @section('css')
        <style type="text/css">
            .table-bordered {
                border: 1px solid #000000 !important;
            }

            .printFH11 th {
                color: #000000 !important;
            }

            .white-box {
                border: none !important;
            }

            .white-box .box-title {
                background-color: #000000 !important;
                color: #fff !important;
            }

            .page-wrapper {
                padding-bottom: 0px;
            }

            .mtn95 {
                margin-top: 400px;
            }

            h1 {
                font-weight: bold;
                color: #315650;
            }

            .container {
                display: table;
                min-width: 100%;
            }

            .table-row {
                display: table-row;
                height: 130px;
            }

            .table-cell {
                display: table-cell;
                font-size: 12px;
            }

            .boxx {
                display: inline-block;
                width: 17px;
                height: 19px;
                border: 1px solid;
                text-align: center;
                line-height: 21px;
                margin-right: -4px;
            }

            @page {
                size: 8.5in 14in ;
            }

            /* .pag {
                margin-top: 8.6in;
                margin-left: 1.13in;
            }

            .inwords {
                margin-top: 38px;
            }

            .remarks {
                margin-left: 0.5in;
            } */
        </style>
        @stop

            @section('content')
            <!-- .container-fluid -->
            <div class="container-fluid">
                <div class="spacer" style="margin-top: 8.6in; margin-left: 1.13in"></div>
                <div class="row">
                    <div class="col-sm-offset-2 col-sm-4 col-xs-offset-2 col-xs-4">
                        <?php $c = str_split($downpayment, 1);?>
                        <?php for($i =0;$i<count($c) ; $i++) {?>
                        <span class="boxx">{{ $c[$i] }}</span>

                        <?php }?>
                        <input type="hidden" id='netpay' value={{ number_format($downpayment) }}>

                    </div>

                    <div class="col-sm-offset-2 col-sm-4 col-xs-offset-3 col-xs-3">
                        <?php $c = str_split($openfiledealerinfo->inventory->total_price, 1);?>
                        <?php for($i =0;$i<count($c) ; $i++) {?>
                        <span class="boxx">{{ $c[$i] }}</span>
                        <?php }?>
                    </div>
                </div>
                <div class="spacer"></div>
                <div class="row">
                    <div class="col-sm-offset-3 col-sm-9 col-xs-offset-3 col-sm-9" style="margin-top: 0.7in;">
                        <p><span id='netpay-label' style="text-transform: uppercase;"></span>
                    </div>
                </div>

                <div class="spacer"></div>
                <div class="row">
                    <div class="col-sm-offset-2 col-sm-10 col-xs-offset-2 col-sm-10">
                        <p>DOWN PAYMENT PAID</p>
                    </div>
                </div>
            </div>



            <div class="clearfix"></div>
            <br>
            <div style="display: inline-block;    margin-bottom: 70px;">
                <div class="text-right" style="display: inline-block;">
                    <button id="print" class="btn btn-default btn-outline no-print" type="button"
                        onclick="return print_whole_statement()"> <span><i class="fa fa-print"></i>Print</span>
                    </button>
                </div>
            </div>
            @stop

                @section('js')

                <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
                </script>

                <script>
                    var a = ['','one ','two ','three ','four ', 'five ','six ','seven ','eight ','nine ','ten ','eleven ','twelve ','thirteen ','fourteen ','fifteen ','sixteen ','seventeen ','eighteen ','nineteen '];
                    var b = ['', '', 'twenty','thirty','forty','fifty', 'sixty','seventy','eighty','ninety'];
                    function number2TextConversion(num) {
                        if ((num = num.toString()).length > 9) return 'overflow';
                        n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
                        if (!n) return; var str = '';
                        str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                        str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                        str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                        str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                        str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';

                        return str;
                    }

                    num=$("#netpay").val();
                    let stringWithoutComma = num.replace(/,/g,'');
                    $("#netpay-label").text(number2TextConversion(stringWithoutComma));


                </script>

                <script>
                    function print_whole_statement() {

                        var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
                        $.ajax({
                            /* the route pointing to the post function */
                            url: '{{ route('openfile.enduser-registrationform.store-count') }}',
                            type: 'POST',
                            /* send the csrf-token and the input to the controller */
                            data: {
                                _token: CSRF_TOKEN,
                                id: "{{ $openfile_enduser->id }}"
                            },
                            dataType: 'JSON',
                            /* remind that 'data' is the response of the AjaxController */
                            success: function (data) {





                            }
                        });
                        window.print();
                        return false;
                    }
                </script>
                @stop