@extends('layouts.app')


@section('title')
Registration Letter
@stop

    @section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-openfile')
            <li><a href="{{ route('openfile.view') }}">All Open File Packages List</a></li>
        @endpermission
        <li class="active">Registration Letter</li>
    </ol>
    @stop

        @section('css')
        <style type="text/css">
            .application {
                text-align: center;
                font-weight: bold;
                background-color: #195754;
                color: white;
                margin-bottom: -1px;
                width: 99%;
                margin-left: 8px;
            }

            .table-bordered {
                border: 1px solid #000000 !important;
            }

            .printFH11 th {
                color: #000000 !important;
            }

            .white-box {
                border: none !important;
            }

            .white-box .box-title {
                background-color: #000000 !important;
                color: #fff !important;
            }

            .page-wrapper {
                padding-bottom: 0px;
            }

            .mtn95 {
                margin-top: 400px;
            }

            h1 {
                font-weight: bold;
                color: #315650;
            }

            .container {
                display: table;
                min-width: 100%;
            }

            .table-row {
                display: table-row;
                height: 130px;
            }

            .table-cell {
                border: 1px solid black;
                display: table-cell;
                font-size: 12px;
            }
        </style>
        @stop

            @section('content')
            <!-- .container-fluid -->
            <div class="container-fluid">
                <div class="row printableArea" id="content">
                    <div class="col-lg-12">
                        <div class="white-box">
                            <div class="row">
                                <div class="col-sm-12 col-xs-12">
                                    <div class="header">
                                        <div class="col-sm-4 col-xs-4">
                                            <img src="{{ asset('images/logo.png') }}"
                                                style="width:80%; margin:5px auto 0;">
                                        </div>
                                        <br>
                                        <div class="col-sm-5 col-xs-5">
                                            <div class="heading">
                                                <h1>REGISTRATION LETTER</h1>
                                                <h3>GENERAL RANGE</h3>
                                            </div>
                                        </div>

                                        <div class="col-sm-3 col-xs-3">
                                            <img src="{{ asset('images/qr-code.png') }}"
                                                alt="QR code" style=" width: 155px; height: 155px; float: right">
                                        </div>
                                    </div>
                                </div>
                                <br>


                                <div class="col-sm-12 col-xs-12">
                                    <h3 class='application'>APPLICANT INFORMATION</h3>
                                    <div class="container">

                                        <div class="table-row">


                                            <div class="table-cell" style='width:50%;'>
                                                <table class="table">
                                                    <tbody>
                                                        <tr>
                                                            <td>APP FORM NO:</td>
                                                            <td>{{$openfile_enduser->app_form_no}}</td>
                                                        </tr>

                                                        <tr>
                                                            <td>SECURITY CODE:</td>
                                                            <td>{{$openfile_enduser->currency_number}}</td>
                                                        </tr>

                                                        <tr>
                                                            <td>PLOT SIZE:</td>
                                                            <td>{{$openfiledealerinfo->inventory->size->name}}  {{env('SIZE')}}</td>
                                                        </tr>

                                                        <tr>
                                                            <td>CATEGORY:</td>
                                                            <td>{{$openfiledealerinfo->inventory->type->name}}</td>
                                                        </tr>

                                                        <tr>
                                                            <td>BLOCK:</td>
                                                            <td>GENERAL RANGE</td>
                                                        </tr>

                                                        <tr style="9px">
                                                            <td>PRINTING DATE:</td>
                                                            <td>
                                                                @php
                                                                    $current_date = date("F j, Y");
                                                                @endphp
                                                                {{ $current_date }}
                                                            </td>
                                                        </tr>
                                                    </tbody>

                                                </table>
                                            </div>

                                            <div class="table-cell" style='width:50%'>
                                                <table class="table">
                                                    <tbody>
                                                        <tr>
                                                            <td>NAME:</td>
                                                            <td> </td>
                                                        </tr>

                                                        <tr>
                                                            <td>S/D/W:</td>
                                                            <td> </td>
                                                        </tr>

                                                        <tr>
                                                            <td>CNIC:</td>
                                                            <td> </td>
                                                        </tr>

                                                        <tr>
                                                            <td>CELL NO:</td>
                                                            <td> </td>
                                                        </tr>

                                                        <tr>
                                                            <td>EMAIL:</td>
                                                            <td></td>
                                                        </tr>

                                                        <tr style="9px">
                                                            <td>ADDRESS:</td>
                                                             <td></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="clearfix"></div>
                                </div>
                                <br><br>
                                <div class="clearfix"></div>

                                <div class="col-sm-12 col-xs-12" style="font-size: 18px ">
                                    <p>With the grace of Almighty Allah (SWT), we are thankful for your interest in
                                        "Forest Town" and welcome you as a valued customer in our project. We are
                                        pleased to inform you that your application has been accepted. It is our
                                        commitment to develop this project which will exceed international standard
                                        and shall be delivered in line with the vision of our company.
                                    </p>
                                </div>

                                <div class="clearfix"></div><br>
                                <div class="mb-3" style='margin-top: 5%;'>
                                    @php
                                    echo '<img style="transform: rotate(90deg);" src="data:image/png;base64,' . DNS1D::getBarcodePNG($openfile_enduser->currency_number, "C128",1) . '" alt="barcode"   />';
                                   @endphp
                                  <span style='    transform: rotate(90deg);
                                  display: inline-table; 
    margin-left: -6%;
'> {{$openfile_enduser->currency_number}}</span>
                                </div>
                                <div class="col-sm-12 col-xs-12">
                                    <div>
                                        <div class="col-sm-4 col-xs-4" style="padding: 50px; text-align: center;">
                                            <p>___________________________</p>
                                            <p>Authorized Signature</p><br>
                                            <table border="2" class="table" style="width: 50%;margin-left: 40px;">
                                                <tbody>
                                                    <tr>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="col-sm-4 col-xs-4" style=" text-align: center;">
                                            <img src="{{ asset('images/qr-code.png') }}"
                                                alt="QR code" style=" width: 140px; height: 140px;"><br>
                                            <p>FOR VERIFICATION</p>
                                        </div>

                                        <div class="col-sm-4 col-xs-4" style="padding: 50px; text-align: center;">
                                            <p>___________________________</p>
                                            <p>Authorized Signature</p><br>
                                            <table border="2" class="table" style="width: 50%;margin-left: 40px;">
                                                <tbody>
                                                    <tr>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div style="display: inline-block;    margin-bottom: 70px;">
                    <div class="text-right" style="display: inline-block;">
                        <button id="print" class="btn btn-default btn-outline no-print" type="button"
                            onclick="return print_whole_statement()"> <span><i class="fa fa-print"></i>Print</span>
                        </button>
                    </div>
                </div>
            </div>














            <!-- ./container-fluid -->
            @stop

                @section('js')

                <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
                </script>

                <script>
                    function print_whole_statement() {

                        window.print();
                        return false;
                    }
                </script>
                @stop