@extends('layouts.app')

@section('title')
Registration Letter
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
    @permission('view-openfile')
        <li><a href="{{ route('openfile.view') }}">All Open File Packages List</a></li>
    @endpermission
    <li class="active">Registration Letter</li>
</ol>
@stop

@section('css')
<style type="text/css">
    .application {
        text-align: center;
        font-weight: bold;
        background-color: #195754;
        color: white;
        margin-bottom: -1px;
        width: 99%;
        margin-left: 8px;
    }

    .table-bordered {
        border: 1px solid #000000 !important;
    }

    .printFH11 th {
        color: #000000 !important;
    }

    .white-box {
        border: none !important;
    }

    .white-box .box-title {
        background-color: #000000 !important;
        color: #fff !important;
    }

    .page-wrapper {
        padding-bottom: 0px;
    }

    .mtn95 {
        margin-top: 400px;
    }

    h1 {
        font-weight: bold;
        color: #315650;
    }

    .container {
        display: table;
        min-width: 100%;
    }

    .table-row {
        display: table-row;
        height: 130px;
    }

    .table-cell {
        display: table-cell;
        font-size: 12px;
    }

    @page {
        size: a4;
    }

    .pag {
        margin-top: 3.9in;
        margin-right: 1in;
        font-weight: bold;
    }

    /* .pagg {
        margin-top: 3.9in;
        margin-right: 4.2in;
    } */
</style>
@stop

@section('content')
<!-- .container-fluid -->
<div class="container-fluid">
    <div class="pag">
        <div class="col-sm-6 col-xs-6" style="margin-top: -2.2cm;">
            <p>APP FORM NO: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>{{ $openfile_enduser->app_form_no }}</p>
            <p>SECURITY CODE: <span>&nbsp;</span> {{ $openfile_enduser->currency_number }}</p>
            <p>PLOT SIZE: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>{{$openfiledealerinfo->inventory->size->name}}  {{env('SIZE')}}</p>
            <p>CATEGORY: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>{{$openfiledealerinfo->inventory->type->name}}</p>
            <p>BLOCK: <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></p><br><br>
            <p style="font-size: 10px; font-weight: bold">PRINTING DATE:
                <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                @php
                    $current_date = date("F , Y");
                @endphp
                {{ $current_date }}
            </p>
        </div>
    </div>

    <div class="col-sm-6 col-xs-6" style="margin-bottom: 2in;  font-weight: bold; margin-top: -2.2cm;">
        <p>NAME:</p>
        <p>S/D/W:</p>
        <p>CNIC:</p>
        <p>CELL NO:</p>
        <p>EMAIL:</p>
        <p>ADDRESS:</p>
    </div>
    <div class="clearfix"></div>
    <div class="mb-3" style='margin-top: 5%;margin-bottom: 100px;'>
        @php
        echo '<img style="transform: rotate(90deg); width: 181px;margin-left: -46px; " src="data:image/png;base64,' . DNS1D::getBarcodePNG($openfile_enduser->currency_number, "C128",1) . '" alt="barcode"   />';
        @endphp
        <span style="display: inline-block;transform: rotate(270deg); margin-left: -142px;letter-spacing: 11px;"> {{$openfile_enduser->currency_number}}</span>
    </div>
</div>  
<!-- ./container-fluid -->
    
    <div style="display: inline-block;    margin-bottom: 70px;">
        <div class="text-right" style="display: inline-block;">
            <button id="print" class="btn btn-default btn-outline no-print" type="button"
                onclick="return print_whole_statement()"> <span><i class="fa fa-print"></i>Print</span>
            </button>
        </div>
    </div>
@stop

@section('js')

<script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
</script>

<script>
    function print_whole_statement() {

        var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
        $.ajax({
                                /* the route pointing to the post function */
                                url: '{{ route('openfile.enduser-registrationletter.store-count') }}',
                                type: 'POST',
                                /* send the csrf-token and the input to the controller */
                                data: {
                                    _token: CSRF_TOKEN,
                                    id:"{{$openfile_enduser->id}}"
                                },
                                dataType: 'JSON',
                                /* remind that 'data' is the response of the AjaxController */
                                success: function(data) {
                                   
                                   



                                }
                            });
       


        window.print();
        return false;
    }
</script>
@stop