@extends('layouts.app')
@section('title')
Overall Booking, Recovery and Receiveable Status
@stop
@section('breadcrumb')
	<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Booking, Recovery and Receiveable Status</li>
    </ol>
@stop
@section('css')
<style type="text/css">
	@page {
    size: landscape;
   }
	.table-bordered, .table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th, .table>thead>tr>td, .table>thead>tr>th {
    border: 1px solid #000000;
	}
	@media print{
		.white-box {
    		border: none !important;
			}
		.page-wrapper{
        	font-size: 12px !important;
        	font-family: "time-new-roman",Arial,sans-serif !important;
        	}
        h3 strong{
        	text-transform: uppercase;
    		}
    	h4 strong{
        	text-transform: uppercase;
    		}
    	h3{
        	margin-bottom: -10px;
    		}
    	.page-wrapper {
    		padding-top: 0px;
    		}	
   		.table>tbody>tr>td, .table>tbody>tr>th {
 		   font-size: 12px;
 			}
		}
</style>
@stop

@section('content')
<!-- ===== Page-Container ===== -->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="white-box">
                        	<div class="text-center">
                            <h3><strong>{{env('APP_NAME')}}</strong></h3>
        					<h4><strong>Overall Booking, Recovery and Receiveable Status </strong></h4>
        						<h6>AS ON <b>{{date('d-m-Y')}}</b></h6>
                        		</div> 
                            <div class="table-responsive" >
                                <table class="table" style="border-top: 1px solid">
                                    <thead>
                                         <tr>
                                         	<th class="text-center" rowspan="2"><strong>APARTMENT TYPE</strong></th>
                                         	<th class="text-center" colspan="3"><strong>NO. OF UNITS</strong></th>
                                         	<th class="text-center" colspan="3"><strong>TOTAL AREA (In Sqft.)</strong></th>
                                         	<th class="text-center" colspan="3"><strong>TOTAL SALES VALUE (In Rs.)</strong></th>
                                         	<th class="text-center" colspan="4"><strong>RECOVERY AND RECEIVEABLE AG. BOOKED UNITS</strong></th>
                                         </tr>
                                         <tr>
                                         	<th class="text-center"><strong>Total</strong></th>
                                         	<th class="text-center"><strong>Booked</strong></th>
                                         	<th class="text-center"><strong>Unbooked</strong></th>
                                         	<th class="text-center"><strong>All Units</strong></th>
                                         	<th class="text-center"><strong>Booked </strong></th>
                                         	<th class="text-center"><strong>Un-Booked</strong></th>
                                         	<th class="text-center"><strong>Booked</strong></th>
                                         	<th class="text-center"><strong>Un-Booked</strong></th>
                                         	<th class="text-center"><strong>Total</strong></th>
                                         	<th class="text-center"><strong>Recovery </strong></th>
                                         	<th class="text-center"><strong>Balance Receivables </strong></th>
                                         	<th class="text-center"><strong>Overdues </strong></th>
                                         	<th class="text-center"><strong>Future Ins.</strong></th>
                                         </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><strong>Floor 1</strong></td>
                                            <td class="text-center">10</td>
                                            <td class="text-center">5</td>
                                            <td class="text-center">4</td>
                                            <td class="text-center">9300</td>
                                            <td class="text-center">2200</td>
                                            <td class="text-center">7100</td>
                                            <td class="text-right">29700000</td>
                                            <td class="text-right">95850000</td>
                                            <td class="text-right">125550000</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Floor 2</strong></td>
                                            <td class="text-center">10</td>
                                            <td class="text-center">5</td>
                                            <td class="text-center">4</td>
                                            <td class="text-center">9300</td>
                                            <td class="text-center">2200</td>
                                            <td class="text-center">7100</td>
                                            <td class="text-right">29700000</td>
                                            <td class="text-right">95850000</td>
                                            <td class="text-right">125550000</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Floor 3</strong></td>
                                            <td class="text-center">10</td>
                                            <td class="text-center">5</td>
                                            <td class="text-center">4</td>
                                            <td class="text-center">9300</td>
                                            <td class="text-center">2200</td>
                                            <td class="text-center">7100</td>
                                            <td class="text-right">29700000</td>
                                            <td class="text-right">95850000</td>
                                            <td class="text-right">125550000</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0</td>
                                            <td class="text-right">0</td>
                                        </tr>
                                        <tr>
                                        <td class="text-center"><strong>Total</strong></td>
                                        <td class="text-center"><strong>98</strong></td>
                                        <td class="text-center"><strong>34</strong></td>
                                        <td class="text-center"><strong>64</strong></td>
                                        <td class="text-center"><strong>86000</strong></td>
                                        <td class="text-center"><strong>28860</strong></td>
                                        <td class="text-center"><strong>57400</strong></td>
                                        <td class="text-center"><strong>38610010</strong></td>
                                        <td class="text-center"><strong>7830000</strong></td>
                                        <td class="text-center"><strong>1169000</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        </tr>
                                        <tr>
                                        	<td colspan="14">&nbsp;</td>
                                        </tr>
                                        <tr>
                                        	<td colspan="14"><strong>Floor 1</strong></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Stu.</strong></td>
                                            <td class="text-center">10</td>
                                            <td class="text-center">5</td>
                                            <td class="text-center">4</td>
                                            <td class="text-center">9300</td>
                                            <td class="text-center">2200</td>
                                            <td class="text-center">7100</td>
                                            <td class="text-right">29700000</td>
                                            <td class="text-right">95850000</td>
                                            <td class="text-right">125550000</td>
                                            <td class="text-right">130000</td>
                                            <td class="text-right">4510000</td>
                                            <td class="text-right">3600000</td>
                                            <td class="text-right">7852020</td>
                                        </tr>
                                        <tr>
                                            <td><strong>1 Bed</strong></td>
                                            <td class="text-center">10</td>
                                            <td class="text-center">5</td>
                                            <td class="text-center">4</td>
                                            <td class="text-center">9300</td>
                                            <td class="text-center">2200</td>
                                            <td class="text-center">7100</td>
                                            <td class="text-right">29700000</td>
                                            <td class="text-right">95850000</td>
                                            <td class="text-right">125550000</td>
                                            <td class="text-right">130000</td>
                                            <td class="text-right">4510000</td>
                                            <td class="text-right">3600000</td>
                                            <td class="text-right">7852020</td>
                                        </tr>
                                        <tr>
                                            <td><strong>2 Bed</strong></td>
                                            <td class="text-center">10</td>
                                            <td class="text-center">5</td>
                                            <td class="text-center">4</td>
                                            <td class="text-center">9300</td>
                                            <td class="text-center">2200</td>
                                            <td class="text-center">7100</td>
                                            <td class="text-right">29700000</td>
                                            <td class="text-right">95850000</td>
                                            <td class="text-right">125550000</td>
                                            <td class="text-right">130000</td>
                                            <td class="text-right">4510000</td>
                                            <td class="text-right">3600000</td>
                                            <td class="text-right">7852020</td>
                                        </tr>
                                        <tr>
                                        <td class="text-center"><strong>Total</strong></td>
                                        <td class="text-center"><strong>98</strong></td>
                                        <td class="text-center"><strong>34</strong></td>
                                        <td class="text-center"><strong>64</strong></td>
                                        <td class="text-center"><strong>86000</strong></td>
                                        <td class="text-center"><strong>28860</strong></td>
                                        <td class="text-center"><strong>57400</strong></td>
                                        <td class="text-center"><strong>38610010</strong></td>
                                        <td class="text-center"><strong>7830000</strong></td>
                                        <td class="text-center"><strong>1169000</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        </tr>
                                        <tr>
                                        <td class="text-center"><strong>Percentage</strong></td>
                                        <td class="text-center"><strong></strong></td>
                                        <td class="text-center"><strong>50%</strong></td>
                                        <td class="text-center"><strong>50%</strong></td>
                                        <td class="text-center"><strong></strong></td>
                                        <td class="text-center"><strong>24%</strong></td>
                                        <td class="text-center"><strong>76%</strong></td>
                                        <td class="text-center"><strong>24%</strong></td>
                                        <td class="text-center"><strong>76%</strong></td>
                                        <td class="text-center"><strong></strong></td>
                                        <td class="text-center"><strong>113%</strong></td>
                                        <td class="text-center"><strong>140%</strong></td>
                                        <td class="text-center"><strong>9%</strong></td>
                                        <td class="text-center"><strong>20%</strong></td>
                                        </tr>
                                        <tr>
                                        	<td colspan="14">&nbsp;</td>
                                        </tr>
                                        <tr>
                                        	<td colspan="14"><strong>Floor 2</strong></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Stu.</strong></td>
                                            <td class="text-center">10</td>
                                            <td class="text-center">5</td>
                                            <td class="text-center">4</td>
                                            <td class="text-center">9300</td>
                                            <td class="text-center">2200</td>
                                            <td class="text-center">7100</td>
                                            <td class="text-right">29700000</td>
                                            <td class="text-right">95850000</td>
                                            <td class="text-right">125550000</td>
                                            <td class="text-right">130000</td>
                                            <td class="text-right">4510000</td>
                                            <td class="text-right">3600000</td>
                                            <td class="text-right">7852020</td>
                                        </tr>
                                        <tr>
                                            <td><strong>1 Bed</strong></td>
                                            <td class="text-center">10</td>
                                            <td class="text-center">5</td>
                                            <td class="text-center">4</td>
                                            <td class="text-center">9300</td>
                                            <td class="text-center">2200</td>
                                            <td class="text-center">7100</td>
                                            <td class="text-right">29700000</td>
                                            <td class="text-right">95850000</td>
                                            <td class="text-right">125550000</td>
                                            <td class="text-right">130000</td>
                                            <td class="text-right">4510000</td>
                                            <td class="text-right">3600000</td>
                                            <td class="text-right">7852020</td>
                                        </tr>
                                        <tr>
                                            <td><strong>2 Bed</strong></td>
                                            <td class="text-center">10</td>
                                            <td class="text-center">5</td>
                                            <td class="text-center">4</td>
                                            <td class="text-center">9300</td>
                                            <td class="text-center">2200</td>
                                            <td class="text-center">7100</td>
                                            <td class="text-right">29700000</td>
                                            <td class="text-right">95850000</td>
                                            <td class="text-right">125550000</td>
                                            <td class="text-right">130000</td>
                                            <td class="text-right">4510000</td>
                                            <td class="text-right">3600000</td>
                                            <td class="text-right">7852020</td>
                                        </tr>
                                        <tr>
                                        <td class="text-center"><strong>Total</strong></td>
                                        <td class="text-center"><strong>98</strong></td>
                                        <td class="text-center"><strong>34</strong></td>
                                        <td class="text-center"><strong>64</strong></td>
                                        <td class="text-center"><strong>86000</strong></td>
                                        <td class="text-center"><strong>28860</strong></td>
                                        <td class="text-center"><strong>57400</strong></td>
                                        <td class="text-center"><strong>38610010</strong></td>
                                        <td class="text-center"><strong>7830000</strong></td>
                                        <td class="text-center"><strong>1169000</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        <td class="text-center"><strong>0</strong></td>
                                        </tr>
                                        <tr>
                                        <td class="text-center"><strong>Percentage</strong></td>
                                        <td class="text-center"><strong></strong></td>
                                        <td class="text-center"><strong>50%</strong></td>
                                        <td class="text-center"><strong>50%</strong></td>
                                        <td class="text-center"><strong></strong></td>
                                        <td class="text-center"><strong>24%</strong></td>
                                        <td class="text-center"><strong>76%</strong></td>
                                        <td class="text-center"><strong>24%</strong></td>
                                        <td class="text-center"><strong>76%</strong></td>
                                        <td class="text-center"><strong></strong></td>
                                        <td class="text-center"><strong>113%</strong></td>
                                        <td class="text-center"><strong>140%</strong></td>
                                        <td class="text-center"><strong>9%</strong></td>
                                        <td class="text-center"><strong>20%</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
                <div class="text-right" style="    margin-bottom: 20px;">
                	<button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> 
                		<span><i class="fa fa-print"></i> Print</span> 
                	</button>
                </div>

        </div>
@stop