@extends('layouts.app')

@section('title')
    Create New Package
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Create New Package</li>
    </ol>
@stop

@section('css')

    <link href="{{ asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet">

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <style type="text/css">
        .h30 {
            /* height: 30px;*/
        }

        .table>tbody>tr>td,
        .table>tbody>tr>th {
            font-size: 14px;
            text-align: left;
        }
    </style>

@endsection

@section('content')

@php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
@endphp

    <div class="container-fluid">
        <!--.row-->
        <div class="row">
            <div class="col-md-12">
                @if ($errors->any())
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                        </ul>


                    </div>
                @endif
                <div class="white-box">
                    <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Create New Package</h3>
                    <hr>
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        <div class="panel-body" style="    margin-bottom: 36px;">
                            {{-- <h3>Add Detail</h3> --}}
                            {{-- <hr> --}}
                            <form id="form-div">
                                {{ csrf_field() }}
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>Name:</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" id="package_name" type="text" name='package_name'
                                                style='width:30.5%' placeholder="Add...">
                                        </div>
                                    </div>
                                 
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>Inventory PriceList:</label>
                                        <div class="col-sm-10"   style="width: 27%;">
                                            <select class="form-control chosen-select"
                                          
                                            name="pricelist" id='pricelist' onchange="changePriceList(this)">
                                            <option >None</option>
                                            @foreach ($pricelist as $l)
                                                <option style="font-size: 11px;" value="{{ $l->id }}">
                                                    {{ $l->l_no }}
                                                </option>
                                            @endforeach

                                        </select>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>Package Price:</label>
                                        <div class="col-sm-10"   style="width: 27%;">
                                            <input class="form-control" id="package_price" type="number" name='package_price'
                                            style='width:100%' placeholder="Add...">
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>Total Rebate:</label>
                                        <div class="col-sm-10"   style="width: 27%;">
                                            <input class="form-control" id="total_rebate" type="number" name='total_rebate'
                                            style='width:100%' placeholder="Add..." onkeyup="totalRebateForRemaining(this)" onclick="totalRebateForRemaining(this)">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label" style='font-size:medium'>Delivered Rebate In:</label>
                                        <div class="col-sm-10"   style="width: 27%;">
                                            <select class="form-control chosen-select"
                                          
                                            name="rebatetype" id='rebatetype' onchange="changeRebateType(this)">
                                            <option value='cash'>Cash</option>
                                            <option value='openfile'>Open File </option>
                                           

                                        </select>
                                        </div>
                                    </div>





                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="panel panel-info">
                                            <div class="panel-heading">Add Detail
                                            </div>

                                <div class=col-md-12 id='original_col' style="overflow-y:auto;height:381px;">
                                    <table class="table table-bordered table-responsive-md table-striped text-center">
                                        <thead>
                                            <tr>

                                                <th class="text-center">Unit Type</th>
                                                <th class="text-center">Size</th>
                                                <th class="text-center">Quantity</th>
                                                <th class="text-center">Price list Per File Downpayment</th>
                                                <th class="text-center">Per File Dealer Downpayment</th>
                                                <th class="text-center">Per File Rebate</th>




                                            </tr>

                                        </thead>
                                        <tbody id="tbody_data">
                                            <?php for($i =0 ; $i<1; $i++) {?>
                                            <tr height="2px" id="account_tr_{{ $i }}"
                                                data-id="{{ $i }}">

                                                <td class="pt-3-half account" style="width: 20%" contenteditable="true">


                                                    <select class="form-control chosen-select us_acnt"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                        name="unit_type[]" id='unit_type_0' data-id='0' onchange='cleanPrice(this)'>
                                                        <option>None</option>
                                                        @foreach ($types as $t)
                                                            <option value="{{ $t->id }}"  >
                                                                {{ $t->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <select class="form-control chosen-select"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                        name="unit_size[]" onchange="getPrice(this)" id='unit_size_0' data-id='0' >
                                                        <option   >None</option>
                                                        @foreach ($sizes as $s)
                                                            <option style="font-size: 11px;" value="{{ $s->id }}"  >
                                                                {{ $s->name }} {{$size}}
                                                            </option>
                                                        @endforeach

                                                    </select>
                                                </td>


                                                



                                                <td class="pt-3-half name" style='width: 20%;'>
                                                    <input class="form-control size unit_quantity" type="number"  data-id='0' name='unit_quantity[]' onclick="totalQuantityChangeFunction(this)"  onkeyup="totalQuantityChangeFunction(this)" id='unit_quantity_0'>
                                                </td>
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control"   type="number"  
                                                    style='width:100%'   readonly  id='pricelist_per_file_downpayment_0'>
                                                </td>

                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control dealer_downpayment" id="package_downpayment_0" type="number" name='downpayment[]'
                                                    style='width:100%' placeholder="Add..." data-id='0' onkeyup="totalDownpaymentFunction(this)" onclick="totalDownpaymentFunction(this)" >
                                                </td>

                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control dealer_rebate" id="package_rebate_0" type="number" name='rebate[]'
                                                    style='width:100%' placeholder="Add..." data-id='0' onkeyup="totalRebateFunction(this)" onclick="totalRebateFunction(this)">
                                                </td>


                                                <td class="pt-3-half name">
                                                    <button type="button" class="btn btn-sm btn-success btn-sm addRowBtn"
                                                        data-id="{{ $i }}" onclick="addNewRow(this)"><i
                                                            class="fa fa-plus"></i></button>

                                                </td>

                                            </tr>

                                            <tr id="narration_tr_{{ $i }}" class="tr_{{ $i }}">

                                            </tr>

                                            <?php } ?>



                                          



                                        </tbody>
                                    </table>
                                </div>

                                        </div>
                                    </div>
                                </div>






                                <hr>
                                <div class="row" id='rebate_in_cah_form' >
                                    
                                </div>


                                <div class="form-actions">

                                    <button style="float: right;margin-right: 20px;" type="button"
                                        class="btn btn-success search-customer" id="search" > <i
                                            class="fa fa-check"></i> Save </button>


                                </div>
                            </form>


                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script>
        function removeParentDiv(self) {
            var id = $(self).closest('tr').data("id");

            $('#account_tr_' + id).remove()
            $('#narration_tr_' + id).remove()
        }

       




        var count =1;
        function addNewRow(self) {
            $(".chosen-select").chosen("destroy");
            count = count +1;
          
            var account_row= `<tr height="2px" id="account_tr_`+count+`"
                                            data-id="`+count+`" >

                                           
                                            <td class="pt-3-half account" style="width: 20%" contenteditable="true">


<select class="form-control chosen-select"
    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
    name="unit_type[]" id="unit_type_`+count+`"   data-id="`+count+`" onchange='cleanPrice(this)'>
    <option 
    >None</option>
    @foreach ($types as $t)
        <option value="{{ $t->id }}"  >
            {{ $t->name }} 
        </option>
    @endforeach

</select>
</td>
<td class="pt-3-half name" contenteditable="true">
<select class="form-control chosen-select"
    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
    name="unit_size[]" data-id="`+count+`" id='unit_size_`+count+`' onchange="getPrice(this)">
    <option 
    >None</option>
    @foreach ($sizes as $s)
        <option style="font-size: 11px;" value="{{ $s->id }}"   >
            {{ $s->name }} {{ $size }}
        </option>
    @endforeach

</select>
</td>
 
<td class="pt-3-half name" style='width: 20%;'>
                                                    <input class="form-control size unit_quantity" type="number" name='unit_quantity[]'  data-id='`+count+`'  onclick="totalQuantityChangeFunction(this)"  onkeyup="totalQuantityChangeFunction(this)"   id='unit_quantity_`+count+`'>
                                                </td>
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control"  type="number"  
                                                    style='width:100%'    data-id='0' readonly  id='pricelist_per_file_downpayment_`+count+`'>
                                                </td>

                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control dealer_downpayment" id="package_downpayment_`+count+`" type="number" name='downpayment[]'
                                                    style='width:100%' placeholder="Add..."   data-id='`+count+`' onkeyup="totalDownpaymentFunction(this)" onclick="totalDownpaymentFunction(this)" >
                                                </td>
                                                
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control dealer_rebate" id="package_rebate_`+count+`" type="number" name='rebate[]'
                                                    style='width:100%' placeholder="Add..." data-id='`+count+`' onkeyup="totalRebateFunction(this)" onclick="totalRebateFunction(this)" >
                                                </td>
                                                



<td class="pt-3-half name">

<button type="button" class="btn btn-sm btn-danger btn-sm"
    onclick="removeParentDiv(this)"><i
        class="fa fa-times"></i></button>
</td>
                                           
                                            

                                        </tr>
                                             `;
            
            

             var tr_id = $(self).data("id");
           $('.tr_' + tr_id).after(account_row);
           $('.chosen-select').chosen();
        }



        function addNewRow2(self) {
            $(".chosen-select").chosen("destroy");
            count = count +1;
            
        //   value =$('#remaining_rebate_amount').val();
        value =$('#remaining_rebate_amount').val();
        
       
if(Number(value) > 0){


            var account_row= `<tr height="2px" id="account_tr_`+count+`"
                                            data-id="`+count+`" >

                                           
                                            <td class="pt-3-half account" style="width: 20%" contenteditable="true">


<select class="form-control chosen-select"
    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
    name="rebate_unit_type[]" id="unit_type_`+count+`"   data-id="`+count+`" onchange='cleanPrice(this)'>
    <option 
    >None</option>
    @foreach ($types as $t)
        <option value="{{ $t->id }}"  >
            {{ $t->name }}
        </option>
    @endforeach

</select>
</td>
<td class="pt-3-half name" contenteditable="true">
<select class="form-control chosen-select"
    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
    name="rebate_unit_size[]" data-id="`+count+`" id='unit_size_`+count+`' onchange="getPrice(this)">
    <option 
    >None</option>
    @foreach ($sizes as $s)
        <option style="font-size: 11px;" value="{{ $s->id }}"   >
            {{ $s->name }}{{ env('SIZE') }}
        </option>
    @endforeach

</select>
</td>
 
<td class="pt-3-half name" style='width: 20%;'>
                                                    <input class="form-control size rebate_unit_quantity" type="number"  data-id='`+count+`' name='unit_quantity[]' onkeyup="totalChangeQuantityFunctionRebate(this)" onclick="totalChangeQuantityFunctionRebate(this)"  id='rebate_unit_quantity_`+count+`'>
                                                </td>
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control"  type="number"  
                                                    style='width:100%'    data-id='0' readonly  id='pricelist_per_file_downpayment_`+count+`'>
                                                </td>

                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control rebate_dealer_downpayment" id="rebate_package_downpayment_`+count+`" type="number" name='downpayment[]'
                                                    style='width:100%' placeholder="Add..."   data-id='`+count+`'   onkeyup="totalDownpaymentFunctionRebate(this)" onclick="totalDownpaymentFunctionRebate(this)">
                                                </td>
                                                
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control rebate_dealer_rebate"  type="number" name='rebate[]'
                                                    style='width:100%' placeholder="Add..." data-id='`+count+`' value='0' readonly  >
                                                </td>
                                                



<td class="pt-3-half name">

<button type="button" class="btn btn-sm btn-danger btn-sm"
    onclick="removeParentDiv(this)"><i
        class="fa fa-times"></i></button>
</td>
                                           
                                            

                                        </tr>
                                             `;
            
            

             var tr_id = $(self).data("id");
           $('.rebate_tr_' + tr_id).after(account_row);
         
                                    }
                                    $('.chosen-select').chosen();
        }







        $(function() {
            $('#myTable').DataTable({
                'pageLength': 50,
                'ordering': false,
            });
        });

        function setZeroBydefault(self) {
            if ($(self).text().length == 0) {
                $(self).text('0');
            }
        }

        $('#search').click(function() {
           
            unit_type = [];
            $('select[name="unit_type[]"]').each(function() {
                if ($(this).val() != 0)
                unit_type.push($(this).val());

            });
            unit_size = [];
            $('select[name="unit_size[]"]').each(function() {
                if ($(this).val() != 0)
                unit_size.push($(this).val());

            });
            unit_quantity = [];
            $('.unit_quantity').each(function() {
               
                if ($(this).val() != 0)
                unit_quantity.push($(this).val());
            });

           
            dealer_rebate = [];
            $('.dealer_rebate').each(function() {
               
                if ($(this).val() != 0)
                dealer_rebate.push($(this).val());
            });


            dealer_downpayment = [];
            $('.dealer_downpayment').each(function() {
               
                if ($(this).val() != 0)
                dealer_downpayment.push($(this).val());
            });
           
            
                                                

           package_name = $('#package_name').val();

        package_price=   $('#package_price').val();
        rebate_amount=   $('#total_rebate').val();
           
        pricelist_id =    $('#pricelist').find(":selected").val();
        rebatetype= $('#rebatetype').find(":selected").val();
        remaining_rebate_amount = $('#remaining_rebate_amount').val();
        if(remaining_rebate_amount < 0){
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Remaining Rebate should not be Negative!',
  
})
    return false;
}
        rebate_unit_type = [];
        rebate_unit_size = [];
        rebate_unit_quantity = [];
        rebate_dealer_rebate = [];
        rebate_dealer_downpayment = [];
        if(rebatetype == 'openfile'){
            
            $('select[name="rebate_unit_type[]"]').each(function() {
                if ($(this).val() != 0)
                rebate_unit_type.push($(this).val());

            });
           
            $('select[name="rebate_unit_size[]"]').each(function() {
                if ($(this).val() != 0)
                rebate_unit_size.push($(this).val());

            });
          
            $('.rebate_unit_quantity').each(function() {
               
                if ($(this).val() != 0)
                rebate_unit_quantity.push($(this).val());
            });

           
            
            $('.rebate_dealer_rebate').each(function() {
               
                if ($(this).val() != 0)
                rebate_dealer_rebate.push($(this).val());
            });


            
            $('.rebate_dealer_downpayment').each(function() {
               
                if ($(this).val() != 0)
                rebate_dealer_downpayment.push($(this).val());
            });
            
       
        
         
            if(!rebate_unit_type.length > 0){
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Rebate File Unit Quantity is Required!',
  
})
    return false;
}      if(!rebate_unit_size.length > 0){
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Rebate File Unit Size is Required!',
  
})
    return false;
}
if(!rebate_unit_quantity.length > 0){
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Rebate File Unit Quantity is Required!',
  
})
    return false;
}

 
if(!rebate_dealer_downpayment.length > 0){
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Rebate File  Downpayment is Required!',
  
})
    return false;
}











           
        }
        
        if (!rebate_amount) {
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Package rebate is Required!',
  
})
    return false;

}
if (!package_name) {
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Package Name is Required!',
  
})
    return false;

}
if (!pricelist_id) {
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Price List is Required!',
  
})
    return false;

}


if (!package_price) {
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Package Price is Required!',
  
})
    return false;

}
if (!rebatetype) {
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Rebate Type is Required!',
  
})
    return false;

}

 
if(!unit_quantity.length > 0){
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Unit Quantity is Required!',
  
})
    return false;
}

if(!unit_type.length > 0){
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Unit Type is Required!',
  
})
    return false; 
}
if(!unit_size.length > 0){
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Unit Size is Required!',
  
})
    return false;  
}

if(!dealer_rebate.length > 0){
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Dealer Rebate is Required!',
  
})
    return false;  
}
if(!dealer_downpayment.length > 0){
    Swal.fire({
  icon: 'error',
  title: 'Oops...',
  text: 'Dealer downpayment is Required!',
  
})
    return false;  
}

            


$('.preloader').fadeIn();
data = {
                "_token": "{{ csrf_token() }}",
               
                'unit_quantity': unit_quantity,
                'unit_size': unit_size,
                'unit_type': unit_type,
                'package_name':package_name,
                'dealer_rebate':dealer_rebate,
                'dealer_downpayment':dealer_downpayment,
                'package_price':package_price,
                'pricelist_id':pricelist_id,
                'rebate_amount':rebate_amount,
                'rebatetype':rebatetype,
                'remaining_rebate_amount':remaining_rebate_amount,
                'rebate_unit_type':rebate_unit_type,
                'rebate_unit_size': rebate_unit_size,
                'rebate_unit_quantity':rebate_unit_quantity,
                'rebate_dealer_rebate':rebate_dealer_rebate,
                'rebate_dealer_downpayment':rebate_dealer_downpayment,
                 
            };

            $.post('{{route("packge.store")}}', data, function(data) {

                $('.preloader').fadeOut();

                if (data == 'date_error') {
                    toastr.error("Invalid date!");
                    document.getElementById("search").disabled = false;
                } else {

                    toastr.success("Entry added successfully.");

                  window.location.href = '{{route("packge.index")}}';
                }

            });
        });



       function getPrice(e){

     size_data_id =  e.getAttribute("data-id");
     unit_size_id = e.value; 
     unit_type_id =  $('#unit_type_'+size_data_id).find(":selected").val(); 
     price_value_id =    $('#pricelist').find(":selected").val();
     if(unit_size_id && unit_type_id != 'None' && price_value_id)
    {
       
         var data = {'unit_size_id':unit_size_id,'unit_type_id':unit_type_id,'price_value_id':price_value_id};
   
         $.get('/package/getPrice', data, function (data) {

          

            $('#pricelist_per_file_downpayment_'+size_data_id).val(data);
           
           });
    }

       }


   



function cleanPrice(e){
    size_data_id =  e.getAttribute("data-id");
    // $('#pricelist_per_file_downpayment_'+size_data_id).val(0);

    unit_size_id =  $('#unit_size_'+size_data_id).find(":selected").val();
    unit_type_id =  $('#unit_type_'+size_data_id).find(":selected").val(); 
     price_value_id =    $('#pricelist').find(":selected").val();
    
     if(unit_size_id!='None' && unit_type_id && price_value_id)
    {
       
         var data = {'unit_size_id':unit_size_id,'unit_type_id':unit_type_id,'price_value_id':price_value_id};
   
         $.get('/package/getPrice', data, function (data) {

           

            $('#pricelist_per_file_downpayment_'+size_data_id).val(data);
           
           });
    }
     
}

function changePriceList(e){

    // $('#pricelist_per_file_downpayment_'+size_data_id).val(data);

  
$('select[name="unit_type[]"]').each( function(keyName, keyValue) {
  unit_size_id =  $('#unit_size_'+keyName).find(":selected").val();
    unit_type_id =  $('#unit_type_'+keyName).find(":selected").val(); 
     price_value_id =    $('#pricelist').find(":selected").val();
    
     if(unit_size_id!='None' && unit_type_id && price_value_id)
    {
         var data = {'unit_size_id':unit_size_id,'unit_type_id':unit_type_id,'price_value_id':price_value_id};
         $.get('/package/getPrice', data, function (data) {
            $('#pricelist_per_file_downpayment_'+keyName).val(data);
           });
    }

});
}
function totalRebateFunction(e){
    data_id =  e.getAttribute("data-id"); 
var totalprice =0;

pricelist_val = $('#pricelist_per_file_downpayment_'+data_id).val();


if(parseInt(e.value) > parseInt(pricelist_val))
{
    $('#package_rebate_'+data_id).val(pricelist_val).trigger('click');;
     
}
for(i=0; i <= data_id ; i++ ){

   quantity= $('#unit_quantity_'+i).val();
  payment=  $('#package_rebate_'+i).val();
if( quantity != undefined && payment != undefined){
result=  quantity * payment;
totalprice = totalprice + result;
}
     
   

}
$('#total_rebate').val(totalprice).trigger('click');




}

function totalDownpaymentFunction(e){


data_id =  e.getAttribute("data-id");
pricelist_val = $('#pricelist_per_file_downpayment_'+data_id).val();
ans=pricelist_val - e.value;
if(parseInt(e.value) > parseInt(pricelist_val))
{
    $('#package_downpayment_'+data_id).val(pricelist_val).trigger('click');
}
$('#package_rebate_'+data_id).val(ans).trigger('click');
 
var totalprice =0;
for(i=0; i <= data_id ; i++ ){

   quantity= $('#unit_quantity_'+i).val();
  payment=  $('#package_downpayment_'+i).val();
if( quantity != undefined && payment != undefined){
result=  quantity * payment;
totalprice = totalprice + result;
}
}
$('#package_price').val(totalprice);


}

function totalQuantityChangeFunction(e){


data_id =  e.getAttribute("data-id");
pricelist_val = $('#pricelist_per_file_downpayment_'+data_id).val();
e_val=$('#package_downpayment_'+data_id).val();
ans=pricelist_val - e_val;
if(parseInt(e.value) > parseInt(pricelist_val))
{
    $('#package_downpayment_'+data_id).val(pricelist_val).trigger('click');
}
$('#package_rebate_'+data_id).val(ans).trigger('click');
 
var totalprice =0;
for(i=0; i <= data_id ; i++ ){

   quantity= $('#unit_quantity_'+i).val();
  payment=  $('#package_downpayment_'+i).val();
if( quantity != undefined && payment != undefined){
result=  quantity * payment;
totalprice = totalprice + result;
}
}
$('#package_price').val(totalprice);


}









function changeRebateType(e){ 
    $("#original_col").css("height", "250px");
    count = count +1;
if(e.value == 'openfile')
{
var add_row =`<div class="col-md-12">
                                        <div class="panel panel-info">
                                            <div class="panel-heading">Add Rebate In Form Of OpenFiles 

                                            </div>
                                <div class=col-md-12 style="overflow-y:auto;height:381px;">
                                    <input type='hidden' value='0' id='remaining_amount_rebate_hidden_input'>
                                    <input type='hidden' value='0' id='remaining_rebate_amount' name='remaining_rebate_amount'>
                                    <input type='hidden' value='0' id='total_utilized_rebate'>
                                    <span class="label label-primary">Remaining Amount PKR <span id='remaining_amount_rebate'></span></span>

                                    <table class="table table-bordered table-responsive-md table-striped text-center">
                                        <thead>
                                            <tr>
                                                <th class="text-center">Unit Type</th>
                                                <th class="text-center">Size</th>
                                                <th class="text-center">Quantity</th>
                                                <th class="text-center">Price list Per File Downpayment</th>
                                                <th class="text-center">Per File Dealer Downpayment</th>
                                                <th class="text-center">Per File Rebate</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbody_data">
                                          
                                            <tr height="2px" id="account_tr_`+count+`"
                                                data-id="`+count+`">
                                                <td class="pt-3-half account" style="width: 20%" contenteditable="true">
                                                    <select class="form-control chosen-select us_acnt"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                        name="rebate_unit_type[]" id='unit_type_`+count+`' data-id='`+count+`' onchange='cleanPrice(this)'>
                                                        <option>None</option>
                                                        @foreach ($types as $t)
                                                            <option value="{{ $t->id }}"  >
                                                                {{ $t->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <select class="form-control chosen-select"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                        name="rebate_unit_size[]" onchange="getPrice(this)" id='unit_size_`+count+`' data-id='`+count+`' >
                                                        <option   >None</option>
                                                        @foreach ($sizes as $s)
                                                            <option style="font-size: 11px;" value="{{ $s->id }}"  >
                                                                {{ $s->name }}{{ env('SIZE') }}
                                                            </option>
                                                        @endforeach

                                                    </select>
                                                </td>
                                                <td class="pt-3-half name" style='width: 20%;'>
                                                    <input class="form-control size rebate_unit_quantity" type="number"  data-id='`+count+`' name='rebate_unit_quantity[]' onkeyup="totalChangeQuantityFunctionRebate(this)" onclick="totalChangeQuantityFunctionRebate(this)" id='rebate_unit_quantity_`+count+`'>
                                                </td>
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control"   type="number"  
                                                    style='width:100%'   readonly  id='pricelist_per_file_downpayment_`+count+`'>
                                                </td>

                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control rebate_dealer_downpayment" id="rebate_package_downpayment_`+count+`" type="number" name='rebate_downpayment[]'
                                                    style='width:100%' placeholder="Add..." data-id='`+count+`' onkeyup="totalDownpaymentFunctionRebate(this)" onclick="totalDownpaymentFunctionRebate(this)">
                                                </td>

                                                <td class="pt-3-half name" contenteditable="true">
                                                    <input class="form-control rebate_dealer_rebate" type="number" name='rebate_dealer_rebate[]'
                                                    style='width:100%' placeholder="Add..." data-id='`+count+`'  value='0' readonly>
                                                </td>


                                                <td class="pt-3-half name">
                                                    <button type="button" class="btn btn-sm btn-success btn-sm addRowBtn"
                                                        data-id="`+count+`" onclick="addNewRow2(this)"><i
                                                            class="fa fa-plus"></i></button>

                                                </td>

                                            </tr>

                                            <tr id="rebate_narration_tr_`+count+`" class="rebate_tr_`+count+`">

                                            </tr>

                                            

                                        </tbody>
                                    </table>
                                         </div>

                                        </div>
                                    </div>`;
                                    $("#rebate_in_cah_form").html(add_row);
                                    $('.chosen-select').chosen();

                                    
                                
                                   remaining_amount= $('#total_rebate').val();
                                   $('#remaining_amount_rebate_hidden_input').val(remaining_amount);
                                   $('#remaining_amount_rebate').text( remaining_amount);

                                   $('#remaining_rebate_amount').val(remaining_amount);
                                  
                                    // remaining_amount_rebate
}
if(e.value =='cash'){
    $("#original_col").css("height", "381px");   
    $("#rebate_in_cah_form").empty();
}

}
function totalDownpaymentFunctionRebate(e){


    data_id =  e.getAttribute("data-id");
    quantity= $('#unit_quantity_'+data_id).val();
  res =  quantity * e.value;

 
// remaining_rebate_amount = $('#remaining_amount_rebate_hidden_input').val();

var totalprice = $('#remaining_amount_rebate_hidden_input').val();
for(i=0; i <= data_id ; i++ ){

   quantity= $('#rebate_unit_quantity_'+i).val();
  payment=  $('#rebate_package_downpayment_'+i).val();
if( quantity != undefined && payment != undefined){
result=  quantity * payment;
 

totalprice = totalprice -result;
}

}
// $('#remaining_amount_rebate_hidden_input').val(totalprice);
$('#remaining_amount_rebate').text( totalprice);
$('#remaining_rebate_amount').val(totalprice);


// remaining=  remaining_rebate_amount - res;
// $('#remaining_amount_rebate_hidden_input').val(remaining);
// $('#remaining_amount_rebate').text( remaining);
}
function totalChangeQuantityFunctionRebate(e){


data_id =  e.getAttribute("data-id");
quantity= $('#unit_quantity_'+data_id).val();
e_val =  $('#rebate_package_downpayment_'+data_id).val();
 
res =  quantity * e_val;



var totalprice = $('#remaining_amount_rebate_hidden_input').val();
 
for(i=0; i <= data_id ; i++ ){

quantity= $('#rebate_unit_quantity_'+i).val();
payment=  $('#rebate_package_downpayment_'+i).val();
if( quantity != undefined && payment != undefined){
result=  quantity * payment;


totalprice = totalprice -result;
}

}
$('#remaining_amount_rebate').text( totalprice);
$('#remaining_rebate_amount').val(totalprice);



}
function totalRebateForRemaining(e){

rebatetype= $('#rebatetype').find(':selected').val();

 if(rebatetype == 'openfile'){
remaining_amount =  $('#remaining_rebate_amount').val();

 // totalprice = Number(remaining_amount) + Number(e.value);
totalprice = Number(e.value);




previous_remaining = $('#remaining_amount_rebate_hidden_input').val();
//  new_remaining = Number(e.value) - Number(previous_remaining) ;
//  console.log(previous_remaining,totalprice,new_remaining);
if(Number(previous_remaining) != Number(e.value)){

 result =0;

for(i=0; i <= count ; i++ ){

quantity= $('#rebate_unit_quantity_'+i).val();
payment=  $('#rebate_package_downpayment_'+i).val();
if( quantity != undefined && payment != undefined){
result=  quantity * payment;



}

}

new_remaining = Number(e.value) - Number(result) ;
 $('#remaining_amount_rebate_hidden_input').val(new_remaining);
 $('#remaining_amount_rebate').text( new_remaining);
 $('#remaining_rebate_amount').val(new_remaining);

}
}
// console.log( $('#remaining_amount_rebate_hidden_input').val());


//                                  

}

    </script>

@stop
