@extends('layouts.app')


@section('title')
Package Details
@stop

    @section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{ route('pricelist.index') }}">All Packages List</a></li>
        <li class="active">Package Details</li>
    </ol>
    @stop

    @section('content')

    @php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
@endphp

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">Package Details</h3>
                    <hr>
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr style="background: #F6F6F6; height: 45px;">
                                    <td>Sr. No:</td>
                                    <?php $count = 1; ?>
                                    <td>{{ $count++ }}</td>
                                </tr>
                                <tr style="background: #F6F6F6; height: 45px;">
                                    <td>Package Name:</td>
                                    <td>{{ $package->name }}</td>
                                </tr>
                                <tr style="background: #F6F6F6; height: 45px;">
                                    <td>Inventory Price List</td>
                                    <td>{{ $package->pricelist->l_no }}</td>
                                </tr>
                                <tr style="background: #F6F6F6; height: 45px;">
                                    <td>Package Price</td>
                                    <td>PKR {{ $package->total_price }}</td>
                                </tr>
                                <tr style="background: #F6F6F6; height: 45px;">
                                    <td>Total Rebate</td>
                                    <td>PKR {{ $package->rebate_amount ? $package->rebate_amount : 'NIL' }}</td>
                                </tr>
                                <tr style="background: #F6F6F6; height: 45px;">
                                    <td>Delivered Rebate In:</td>
                                    <td>{{ $package->rebate_type }}</td>
                                </tr>

                                @if( $package->rebate_type  == 'openfile')
                                <tr style="background: #F6F6F6; height: 45px;">
                                    <td>Remaining Rebate In:</td>
                                    <td>PKR {{ $package->remaining_rebate }}</td>
                                </tr>

                                @endif
                            </tbody>
                        </table>
                        <br>
                        @if( $package->rebate_type == 'cash' )
                        <h3 class="box-title">Package Open Files</h3>
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr. No.</th>
                                    <th>Unit Type</th>
                                    <th>Size</th>
                                    <th>No. of Files</th>
                                    <th>Per File Dealer Down Payment</th>
                                    <th>Per File Rebate</th>
                                </tr>
                            </thead>
                            <br><br>    
                            <tbody>
                                <?php $count = 1; ?>

                                @foreach ($package->packageDetail as $p)
                                @if ($p->rebate_file == 0)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $p->unittype->name }}</td>
                                        <td>{{ $p->unitSize->name }} {{$size}}</td>
                                        <td>{{ $p->unit_quantity }}</td>
                                        <td>PKR {{ $p->dealer_downpayment }}</td>
                                        <td>PKR {{ $p->dealer_rebate }}</td>
                                    </tr>
                                @endif
                                @endforeach
                            </tbody>
                        </table>
                        

                    @else 
                        <h3 class="box-title">Package Open Files</h3>
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr. No.</th>
                                    <th>Unit Type</th>
                                    <th>Size</th>
                                    <th>No. of Files</th>
                                    <th>Per File Dealer Down Payment</th>
                                    <th>Per File Rebate</th>
                                </tr>
                            </thead>
                            <br><br>
                            <tbody>
                                <?php $count = 1; ?>

                                @foreach($package->packageDetail as $p)
                                @if($p->rebate_file == 0)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $p->unittype->name }}</td>
                                        <td>{{ $p->unitSize->name }} {{$size}}</td>
                                        <td>{{ $p->unit_quantity }}</td>
                                        <td>PKR {{ $p->dealer_downpayment }}</td>
                                        <td>PKR {{ $p->dealer_rebate }}</td>
                                    </tr>
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                        <br><br>
                        <h3 class="box-title">Dealer Rebate Open Files</h3>

                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr. No.</th>
                                    <th>Unit Type</th>
                                    <th>Size</th>
                                    <th>No. of Files</th>
                                    <th>Per File Dealer Down Payment</th>
                                    <th>Per File Rebate</th>
                                </tr>
                            </thead>
                            <br><br>
                            <tbody>
                                <?php $count = 1; ?>

                                @foreach($package->packageDetail as $p)
                                @if($p->rebate_file == 1)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $p->unittype->name }}</td>
                                        <td>{{ $p->unitSize->name }} {{$size}}</td>
                                        <td>{{ $p->unit_quantity }}</td>
                                        <td>PKR {{ $p->dealer_downpayment }}</td>
                                        <td>PKR {{ $p->dealer_rebate }}</td>
                                    </tr>
                                @endif
                                @endforeach
                            </tbody>
                        </table>
                    @endif
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    @stop

    @section('js')

        <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
        </script>

    <script></script>
    @stop