@extends('layouts.app')


@section('title')
Packages List
@stop

    @section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-inventory')
            <li class="active"> All Package List</li>
        @endpermission
    </ol>
    @stop

        @section('content')
        <!-- .container-fluid -->
        <div class="container-fluid">
            <!-- /row -->
            <div class="row">
                <div class="col-sm-12">
                    <div class="white-box">
                        <div class="pull-right">
                            <a href="{{ route('packge.create') }}" class="btn  btn-primary">
                                <i class="fa fa-plus-square"></i>&nbsp; Add New Package
                            </a>                         
                        </div>
                        <h3 class="box-title">All Packages List</h3>

                        <div class="table-responsive">
                            <table id="myTable" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Package Name</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1; ?>
                                    


                                    @foreach ($allpackagelist as $pkg)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $pkg->name }}</td>
                                    

                                        <td class="text-nowrap">

                                           
                                                <a href="{{route('packge.detail',['id'=>$pkg->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            
                                            
                                            
                                                <!-- <a href="{{ route('packge.index', [$pkg->id]) }}" data-toggle="tooltip"
                                                    datza-original-title="Edit"> <i
                                                        class="fa fa-pencil text-inverse m-r-10"></i></a> -->
                                            

                                            
                                                <form action="{{ route('packge.delete', [$pkg->id]) }}" method="post"
                                                    style='display: inline;'>
                                                    {!! method_field('delete') !!}
                                                    {!! csrf_field() !!}


                                                    <button class="btn btn-link btn-s" style="color:red;" type="submit"
                                                        name="action" value="delete" data-toggle="confirmation"
                                                        data-title="Are you sure to delete?">
                                                        <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                    </button>
                                                </form>
                                        </td> 
                                    </tr>
                                @endforeach
                                    
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
                        </div>
                        <!-- ./container-fluid -->
                        @stop

                            @section('js')

                            <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
                            </script>

                            <script></script>
                            @stop