@extends('layouts.app')

@section('title')
    Generate Voucher
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Create</li>
    </ol>
@stop

@section('css')

    <link href="{{ asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet">

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <style type="text/css">
        .h30 {
            /* height: 30px;*/
        }

        .table>tbody>tr>td,
        .table>tbody>tr>th {
            font-size: 14px;
            text-align: left;
        }
    </style>

@endsection

@section('content')
    <div class="container-fluid">
        <!--.row-->
        <div class="row">
            <div class="col-md-12">
                @if ($errors->any())
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                        </ul>

                        
                    </div>
                @endif
                <div class="white-box">
                    <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Create New Package</h3>
                    <hr>
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        <div class="panel-body" style="    margin-bottom: 36px;">
                            <h3>Add Detail</h3>
                         <hr>
                            <form id="form-div">
                                {{ csrf_field() }}
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Package Name:</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" id="focusedInput" type="text" name='package_name'
                                                style='width:30%'>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Date:</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" id="focusedInput" type="date" name='date'
                                                style='width:30%'>
                                        </div>
                                    </div>







                                </div>
                                <hr>
                                <div class=col-md-12 style="overflow-y:auto;height:381px;">
                                    <table class="table table-bordered table-responsive-md table-striped text-center">
                                        <thead>
                                            <tr>

                                                <th class="text-center">Unit Type</th>
                                                <th class="text-center">Size</th>
                                                <th class="text-center">Quantity</th>




                                            </tr>

                                        </thead>
                                        <tbody id="tbody_data">
                                            <?php for($i =0 ; $i<1; $i++) {?>
                                            <tr height="2px" id="account_tr_{{ $i }}"
                                                data-id="{{ $i }}">

                                                <td class="pt-3-half account" style="width: 40%" contenteditable="true">


                                                    <select class="form-control chosen-select us_acnt"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                        name="unit_type[]">
                                                        <option value="0">None</option>
                                                        @foreach ($types as $t)
                                                            <option value="{{ $t->id }}">
                                                                {{ $t->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <select class="form-control chosen-select"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                        name="unit_size[]">
                                                        <option value="0">None</option>
                                                        @foreach ($sizes as $s)
                                                            <option style="font-size: 11px;" value="{{ $s->id }}">
                                                                {{ $s->name }}{{ env('SIZE') }}
                                                            </option>
                                                        @endforeach

                                                    </select>
                                                </td>

                                                <td class="pt-3-half credit" onfocusout="return setZeroBydefault(this)"
                                                    onkeyup="addQuantity(this)" contenteditable="true">0</td>



                                                <td class="pt-3-half name">
                                                    <button type="button" class="btn btn-sm btn-success btn-sm addRowBtn"
                                                        data-id="{{ $i }}" onclick="addNewRow(this)"><i
                                                            class="fa fa-plus"></i></button>

                                                </td>

                                            </tr>

                                            <tr id="narration_tr_{{ $i }}" class="tr_{{ $i }}">

                                            </tr>

                                            <?php } ?>



                                            <tr height="2px" id="account_tr_{{ $i + 1 }}"
                                                data-id="{{ $i + 1 }}" style="display:none;">

                                                <td class="pt-3-half account" style="width: 40%" contenteditable="true">


                                                    <select class="form-control chosen-select"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                        name="unit_size[]">
                                                        <option value="0">None</option>
                                                        @foreach ($types as $t)
                                                            <option value="{{ $t->id }}">
                                                                {{ $t->name }}
                                                            </option>
                                                        @endforeach

                                                    </select>
                                                </td>
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <select class="form-control chosen-select name1"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;">
                                                        <option value="0">None</option>
                                                        @foreach ($sizes as $s)
                                                            <option style="font-size: 11px;" value="{{ $s->id }}">
                                                                {{ $s->name }}{{ env('SIZE') }}
                                                            </option>
                                                        @endforeach

                                                    </select>
                                                </td>
                                                <td class="pt-3-half credit" onfocusout="return setZeroBydefault(this)"
                                                    onkeyup="addQuantity(this)" contenteditable="true"></td>




                                                <td class="pt-3-half name">

                                                    <button type="button" class="btn btn-sm btn-danger btn-sm"
                                                        onclick="removeParentDiv(this)"><i
                                                            class="fa fa-times"></i></button>
                                                </td>

                                            </tr>

                                            

                                        </tbody>
                                    </table>
                                </div>






                                <div class="form-actions">

                                    <button style="float: right;margin-right: 20px;" type="button"
                                        class="btn btn-success search-customer" id="search" disabled=""> <i
                                            class="fa fa-check"></i> Save </button>

                                    <!--<button style="float: right;margin-right: 20px;" type="button" class="btn btn-info" onclick="return addNewRow(this)"> <i class="fa fa-plus" ></i> Add </button>-->


                                </div>
                            </form>


                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12" style="padding:1%;">
                <div class="panel panel-info">
                    {{-- <div class="panel-heading">Create Package</div> --}}
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        <div class="panel-body" style="    margin-bottom: 36px;">
                            <h3>Add Detail</h3>
                         <hr>
                            <form id="form-div">
                                {{ csrf_field() }}
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Package Name:</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" id="focusedInput" type="text" name='package_name'
                                                style='width:30%'>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Date:</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" id="focusedInput" type="date" name='date'
                                                style='width:30%'>
                                        </div>
                                    </div>







                                </div>
                                <hr>
                                <div class=col-md-12 style="overflow-y:auto;height:381px;">
                                    <table class="table table-bordered table-responsive-md table-striped text-center">
                                        <thead>
                                            <tr>

                                                <th class="text-center">Unit Type</th>
                                                <th class="text-center">Size</th>
                                                <th class="text-center">Quantity</th>




                                            </tr>

                                        </thead>
                                        <tbody id="tbody_data">
                                            <?php for($i =0 ; $i<1; $i++) {?>
                                            <tr height="2px" id="account_tr_{{ $i }}"
                                                data-id="{{ $i }}">

                                                <td class="pt-3-half account" style="width: 40%" contenteditable="true">


                                                    <select class="form-control chosen-select us_acnt"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                        name="unit_type[]">
                                                        <option value="0">None</option>
                                                        @foreach ($types as $t)
                                                            <option value="{{ $t->id }}">
                                                                {{ $t->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <select class="form-control chosen-select"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                        name="unit_size[]">
                                                        <option value="0">None</option>
                                                        @foreach ($sizes as $s)
                                                            <option style="font-size: 11px;" value="{{ $s->id }}">
                                                                {{ $s->name }}{{ env('SIZE') }}
                                                            </option>
                                                        @endforeach

                                                    </select>
                                                </td>

                                                <td class="pt-3-half credit" onfocusout="return setZeroBydefault(this)"
                                                    onkeyup="addQuantity(this)" contenteditable="true">0</td>



                                                <td class="pt-3-half name">
                                                    <button type="button" class="btn btn-sm btn-success btn-sm addRowBtn"
                                                        data-id="{{ $i }}" onclick="addNewRow(this)"><i
                                                            class="fa fa-plus"></i></button>

                                                </td>

                                            </tr>

                                            <tr id="narration_tr_{{ $i }}" class="tr_{{ $i }}">

                                            </tr>

                                            <?php } ?>



                                            <tr height="2px" id="account_tr_{{ $i + 1 }}"
                                                data-id="{{ $i + 1 }}" style="display:none;">

                                                <td class="pt-3-half account" style="width: 40%" contenteditable="true">


                                                    <select class="form-control chosen-select"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                        name="unit_size[]">
                                                        <option value="0">None</option>
                                                        @foreach ($types as $t)
                                                            <option value="{{ $t->id }}">
                                                                {{ $t->name }}
                                                            </option>
                                                        @endforeach

                                                    </select>
                                                </td>
                                                <td class="pt-3-half name" contenteditable="true">
                                                    <select class="form-control chosen-select name1"
                                                        style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;">
                                                        <option value="0">None</option>
                                                        @foreach ($sizes as $s)
                                                            <option style="font-size: 11px;" value="{{ $s->id }}">
                                                                {{ $s->name }}{{ env('SIZE') }}
                                                            </option>
                                                        @endforeach

                                                    </select>
                                                </td>
                                                <td class="pt-3-half credit" onfocusout="return setZeroBydefault(this)"
                                                    onkeyup="addQuantity(this)" contenteditable="true"></td>




                                                <td class="pt-3-half name">

                                                    <button type="button" class="btn btn-sm btn-danger btn-sm"
                                                        onclick="removeParentDiv(this)"><i
                                                            class="fa fa-times"></i></button>
                                                </td>

                                            </tr>

                                            

                                        </tbody>
                                    </table>
                                </div>






                                <div class="form-actions">

                                    <button style="float: right;margin-right: 20px;" type="button"
                                        class="btn btn-success search-customer" id="search" disabled=""> <i
                                            class="fa fa-check"></i> Save </button>

                                    <!--<button style="float: right;margin-right: 20px;" type="button" class="btn btn-info" onclick="return addNewRow(this)"> <i class="fa fa-plus" ></i> Add </button>-->


                                </div>
                            </form>


                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script>
        function removeParentDiv(self) {
            var id = $(self).closest('tr').data("id");

            $('#account_tr_' + id).remove()
            $('#narration_tr_' + id).remove()
        }

        $('.us_acnt').on('change', function() {

            if (($(this).closest('tr').find('.debit').html() > 0 || $(this).closest('tr').find('.credit').html() >
                    0) && $(this).val() == 0) {
                $("#search").prop("disabled", true);
            } else if (($(this).closest('tr').find('.debit').html() > 0 || $(this).closest('tr').find('.credit')
                    .html() > 0) && $(this).val() > 0) {
                $("#search").prop("disabled", false);
            }


            if (($('#debit-total').html() > 0 && $('#credit-total').html() > 0) && ($('#credit-total').html() != $(
                    '#debit-total').html())) {
                $("#search").prop("disabled", true);
            }


        });




        function addNewRow(self) {
            $(".chosen-select").chosen("destroy");

            // var narration_row = $('#narration_tr_{{ $i + 1 }}').html();
            var account_row = $('#account_tr_{{ $i + 1 }}').html();
            var rand_id = Math.floor(Math.random() * 100);
            var tr_id = $(self).data("id");

            $('.tr_' + tr_id).after('<tr  id="account_tr_' + rand_id + '"  data-id="' + rand_id + '" >' + account_row +
                '</tr>');

            $("#account_tr_" + rand_id).find('.debit').text(0)
            $("#account_tr_" + rand_id).find('.credit').text(0)
            $("#account_tr_" + rand_id).find('.name1').attr('name', 'name1[]');
            $("#account_tr_" + rand_id).find('.addRowBtn').data('id', rand_id);
            // $("#narration_tr_" + rand_id).find('.line_narration').attr('name', 'line_narration[]');

            $("#narration_tr_" + rand_id).show();
            $("#account_tr_" + rand_id).show();

            $(".chosen-select").chosen();

            return false;
        }

        $(function() {
            $('#myTable').DataTable({
                'pageLength': 50,
                'ordering': false,
            });
        });

        function setZeroBydefault(self) {
            if ($(self).text().length == 0) {
                $(self).text('0');
            }
        }

        const year = new Date().getFullYear();

        const this_fiscal_year_start_date = new Date(year + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_START }} + '-01');

        const this_fiscal_year_end_date = new Date((year + 1) + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_END }} + '-30');

        const last_fiscal_year_start_date = new Date((year - 1) + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_START }} +
            '-01');

        const last_fiscal_year_end_date = new Date(year + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_END }} + '-30');




        $('#daterange-btn').daterangepicker({
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf(
                        'month')],
                    'This Fiscal Year': [this_fiscal_year_start_date, this_fiscal_year_end_date],
                    'Last Fiscal Year': [last_fiscal_year_start_date, last_fiscal_year_end_date]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
            },
            function(start, end) {
                $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }
        );

        $('.update-record').on('click', function() {

            $('.preloader').fadeIn();

            date_range = $('#daterange-btn').val();
            account = $('#c_account').val();
            name = $('#c_name').val();


            var data = {
                'date_range': date_range,
                'account': account,
                'name': name
            };
            $.get('/general-journal-entries/update-entries', data, function(data) {
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'paging': false,
                    'searching': false,
                    'info': true
                });
                toastr.success("Report updated.");
            });

            $('.preloader').fadeOut();
        });


        window.setInterval(function() {

            $('.debit').each(function() {
                if (this.innerHTML === "") {
                    this.innerHTML = 0;
                }
            });


            $('.credit').each(function() {
                if (this.innerHTML === "") {
                    this.innerHTML = 0;
                }
            });


            $('.line_narration').each(function() {
                if (!$(this).attr("name")) {
                    $(this).attr('name', 'line_narration[]')
                }
            });


            $('.name1').each(function() {
                if (!$(this).attr("name")) {
                    $(this).attr('name', 'name1[]')
                }
            });


            $('#account_tr_{{ $i + 1 }}').find('.name1').removeAttr('name', 'name1[]');
            $('#narration_tr_{{ $i + 1 }}').find('.line_narration').removeAttr('name', 'line_narration[]');


        }, 1000);

        function addDebit() {
            sum = 0;
            $response = 1;
            $('.debit').each(function() {
                if (this.innerHTML) {
                    sum += parseInt(this.innerHTML);
                }
            });
            document.getElementById('debit-total').innerHTML = sum;
            if ($(self).closest('tr').find('.us_acnt').val() == 0) {
                $response = 0;
            }


            if ($response == 1) {
                checkTotal();
            } else {
                $("#search").prop("disabled", true);
            }
        }

        function addQuantity() {
            sum = 0;
            $response = 1;
            $('.credit').each(function() {
                if (this.innerHTML) {
                    sum += parseInt(this.innerHTML);
                }
            });
            document.getElementById('credit-total').innerHTML = sum;

            if ($(self).closest('tr').find('.us_acnt').val() == 0) {
                $response = 0;
            }


            if ($response == 1) {
                checkTotal();
            } else {
                $("#search").prop("disabled", true);
            }
        }

        function checkTotal() {

            debit = parseInt(document.getElementById('debit-total').innerHTML);
            credit = parseInt(document.getElementById('credit-total').innerHTML);
            if (debit == credit) {
                $("#search").prop("disabled", false);

                document.getElementById('debit-total').style.color = 'black';
                document.getElementById('credit-total').style.color = 'black';
                $("#update").prop("disabled", false);
            } else {
                $("#search").prop("disabled", true);

                document.getElementById('debit-total').style.color = 'red';
                document.getElementById('credit-total').style.color = 'red';
                $("#update").prop("disabled", false);
            }

        }

        $('#search').click(function() {

            document.getElementById("search").disabled = true;

            date = $('#date').val();

            adjusting_entry = 0;
            if ($('#adjusting_entry').prop("checked") == true) {
                adjusting_entry = 1;
            }
            account = [];
            $('select[name="account[]"]').each(function() {
                if ($(this).val() != 0)
                    account.push($(this).val());

            });

            name1 = [];
            $('select[name="name1[]"]').each(function() {
                name1.push($(this).val());

            });

            class_id = [];
            $('select[name="class_id[]"]').each(function() {
                class_id.push($(this).val());

            });

            debit = [];
            $('.debit').each(function() {
                if (this.innerHTML) {
                    debit.push(parseInt(this.innerHTML));
                }
            });

            credit = [];
            $('.credit').each(function() {
                if (this.innerHTML) {
                    credit.push(parseInt(this.innerHTML));
                }
            });

            memo = $('#memo').val();

            var line_narration = $("input[name='line_narration[]']")
                .map(function() {
                    return $(this).val();
                }).get();

            voucher_type = $("input[type='radio'][name='voucher_type']:checked").val();

            if (!voucher_type) {
                alert('voucher type required.');

                return false;

            }

            transaction_id = $('#transaction_id').val();
            transaction_type = $('#transaction_type').val();

            bank_name = $('#bank_name').val();
            cheaque_no = $('#cheaque_no').val();


            data = {
                "_token": "{{ csrf_token() }}",
                'date': date,
                'adjusting_entry': adjusting_entry,
                'account': account,
                'debit': debit,
                'credit': credit,
                'memo': memo,
                'name': name1,
                'class_id': class_id,
                'voucher_type': voucher_type,
                'transaction_id': transaction_id,
                'transaction_type': transaction_type,
                'bank_name': bank_name,
                'cheaque_no': cheaque_no,
                'line_narration': line_narration
            };

            $.post('/general-journal-entries/create-vouchers', data, function(data) {



                if (data == 'date_error') {
                    toastr.error("Invalid date!");
                    document.getElementById("search").disabled = false;
                } else {

                    toastr.success("Entry added successfully.");

                    window.location.href = '/general-journal-entries/voucher-detail/' + data.entry_no;
                }

            });
        });
    </script>

@stop
