@extends( 'layouts.app' )

@section('title')
Payment Detail 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li ><a href="{{route('customer-payment.all')}}">Payments</a></li>
        <li class="active">Payment Detail</li>
      </ol>
@stop
@section('content')
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Payment Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Membership No</td>
                                                    <td>{{$payment->property->membership_number}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Unit No.</td>
                                                    <td> {{$payment->property->inventory ? $payment->property->inventory->unit_number : ''}} </td>
                                                </tr>

                                               <tr>
                                                    <td>Payment Mode</td>
                                                    @if($payment->payment_mode == \App\Receipt::cash)
                                                    <td>Cash</td>
                                                    @elseif($payment->payment_mode == \App\Receipt::bank)
                                                    <td>Bank transfer</td>
                                                    @elseif($payment->payment_mode == \App\Receipt::cheque)
                                                    <td>Cheque</td>
                                                    @elseif($payment->payment_mode == \App\Receipt::adjustment)
                                                    <td>Adjustment</td>
                                                    @endif
                                                </tr>

                                                <tr>
                                                    <td>Depositor Bank Name</td>
                                                    <td> {{$payment->depositorbank ? $payment->depositorbank->name : ''}}</td>
                                                </tr>

                                                <tr>
                                                    <td>Cheque Number</td>
                                                    <td> {{$payment->cheque_number}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Amount</td>
                                                    <td> {{$payment->amount}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>

                  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Receipt Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Receipt No</td>
                                                    <td> {{$payment->receipt_no}} </td>
                                                </tr>

                                                <tr>
                                                    <td>Reference No</td>
                                                    <td> PC {{$payment->id}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Receipt Date</td>
                                                    <td> {{date('d-m-Y', strtotime($payment->receipt_date)) }} </td>
                                                </tr>

                                                <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$payment->updated_at}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Created at</td>
                                                    <td> {{$payment->created_at}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop