@extends( 'layouts.app' )

@section('title')
Edit Payment 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
       <li ><a href="{{route('customer-payment.all')}}">Payments</a></li>
        <li class="active">Edit Payment</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
    <form method="post" action="{{route('customer-payment.update')}}" class="form-horizontal">
        {{csrf_field()}}
               <input type='hidden' name='id' value="{{$payment->id}}">
               <input type='hidden' name='statement_id' value="{{$payment->statement ? $payment->statement->id : null}}">
	<div class="row">
		<div class="col-lg-12 col-sm-12 col-xs-12">
            <div class="white-box">
                <h3 class="box-title">Payment Information</h3>
                            <hr>
                 <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Select Customer <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select name="customer_id" id='customer_id' class="form-control chosen-select" >
                                                                <option value="" selected="">None</option>
                                                              @foreach($customers as $customer)
                                                              @if($payment->customer_id == $customer->id)
                                                              <option selected="" value="{{$customer->id}}">{{$customer->name}}</option>
                                                              @else
<!--                                                              <option disabled="" value="{{$customer->id}}">{{$customer->name}}</option>-->
                                                              @endif
                                                              @endforeach
                                                            </select>
                                                            @if ($errors->has('customer_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('customer_id') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-12" id='property'>
                                <b>Pick one unit</b>
<div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>Unit No.</th>
                                             <th>Net Amount of unit</th>
                                            <th>Received Amount</th>
                                            <th>Remaining Amount</th>
                                            <th>Last Payment Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @foreach($properties as $property)
                                        <tr>
                                            @if($payment->customer_property_id == $property->id)
                                            <td><input type="radio" checked="" required name='customer_property_id' value='{{$property->id}}' ></td>
                                            <td>{{$property->block . ' ' . $property->plot_no}}</td>
                                            <td>{{number_format($property->net_pay)}} PKR</td>
                                            <td>{{number_format($receivedAmount[$property->id])}} PKR</td>
                                            <td>{{number_format($remainingAmount[$property->id])}} PKR</td>
                                             <td> {{$lastDate[$property->id] ? date('d-m-Y', strtotime($lastDate[$property->id]->receipt_date)) : ''}}</td>

                                            @else
<!--                                            <td><input type="radio" disabled="" required name='customer_property_id' value='{{$property->id}}' ></td>

                                           <td>{{$property->block . ' ' . $property->plot_no}}</td>
                                            <td>{{number_format($property->net_pay)}} PKR</td>
                                            <td>{{number_format($receivedAmount[$property->id])}} PKR</td>
                                            <td>{{number_format($remainingAmount[$property->id])}} PKR</td>
                                             <td> {{$lastDate[$property->id] ? date('d-m-Y', strtotime($lastDate[$property->id]->receipt_date)) : ''}}</td>
                                          -->
                                          @endif
                                        </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                            </div>

                            </div>

                            <div class="clearfix"></div>
                            <br>
                            <br>

                            <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Payment Mode <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name='payment_mode' onchange="changeFunc(this.value)">
                                                                @if($payment->payment_mode == \App\Receipt::cash)
                                                                <option value="{{\App\Receipt::cash}}" selected="">Cash</option>
                                                                <option value="{{\App\Receipt::bank}}">Bank Transfer</option>
                                                                <option value="{{\App\Receipt::cheque}}">Cheque</option>
                                                                <option value="{{\App\Receipt::adjustment}}" >Adjustment</option>
                                                                @elseif($payment->payment_mode == \App\Receipt::bank)
                                                                <option value="{{\App\Receipt::cash}}" >Cash</option>
                                                                <option value="{{\App\Receipt::bank}}" selected="">Bank Transfer</option>
                                                                <option value="{{\App\Receipt::cheque}}">Cheque</option>
                                                                <option value="{{\App\Receipt::adjustment}}" >Adjustment</option>
                                                                @elseif($payment->payment_mode == \App\Receipt::cheque)
                                                                <option value="{{\App\Receipt::cash}}" >Cash</option>
                                                                <option value="{{\App\Receipt::bank}}">Bank Transfer</option>
                                                                <option value="{{\App\Receipt::cheque}}" selected="">Cheque</option>
                                                                <option value="{{\App\Receipt::adjustment}}" >Adjustment</option>
                                                                @elseif($payment->payment_mode == \App\Receipt::adjustment)
                                                                <option value="{{\App\Receipt::cash}}" >Cash</option>
                                                                <option value="{{\App\Receipt::bank}}">Bank Transfer</option>
                                                                <option value="{{\App\Receipt::cheque}}" >Cheque</option>
                                                                <option value="{{\App\Receipt::adjustment}}" selected="">Adjustment</option>
                                                                @else
                                                                <option selected='' value="{{\App\Receipt::cash}}" selected="">Cash</option>
                                                                <option value="{{\App\Receipt::bank}}">Bank Transfer</option>
                                                                <option value="{{\App\Receipt::cheque}}">Cheque</option>
                                                                <option value="{{\App\Receipt::adjustment}}" >Adjustment</option>
                                                                @endif
                                                            </select>
                                                            @if ($errors->has('payment_mode'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_mode') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>


                            @if($receipt->payment_mode !== \App\Receipt::cash )
                            <div class="col-md-6" id='bank' >
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Bank Name</label>
                                                        <div class="col-md-8">
                                                        <select name="bank_name"  class="form-control chosen-select" >
                                                                <option value="" selected="">None</option>
                                                              @foreach($banks as $bank)
                                                              @if($payment->bank_name == $bank->id)
                                                              <option selected="" value="{{$bank->id}}">{{$bank->name}}</option>
                                                              @else
                                                               <option value="{{$bank->id}}">{{$bank->name}}</option>
                                                              @endif
                                                              @endforeach
                                                            </select>
                                                        @if ($errors->has('bank_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('bank_name') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            @else
                             <div class="col-md-6" id='bank'  style="display: none;">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Bank Name</label>
                                                        <div class="col-md-8">
                                                        <select name="bank_name"  class="form-control chosen-select" >
                                                                <option value="" selected="">None</option>
                                                              @foreach($banks as $bank)
                                                              @if($payment->bank_name == $bank->id)
                                                              <option selected="" value="{{$bank->id}}">{{$bank->name}}</option>
                                                              @else
                                                               <option value="{{$bank->id}}">{{$bank->name}}</option>
                                                              @endif
                                                              @endforeach
                                                            </select>
                                                        @if ($errors->has('bank_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('bank_name') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            @endif



                             @if($payment->payment_mode == \App\Receipt::cheque)
                            <div class="col-md-6" id='cheque' >
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Cheque Number</label>
                                                        <div class="col-md-8">
                                                            <input type="text" name='cheque_number' value="{{$payment->cheque_number}}" class="form-control" id="exampleInputEmail1" placeholder="Enter Check Number">
                                                        @if ($errors->has('cheque_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('cheque_number') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            @else
                            <div class="col-md-6" id='cheque' style="display: none;">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Cheque Number</label>
                                                        <div class="col-md-8">
                                                            <input type="text" name='cheque_number' value="{{$payment->cheque_number}}" class="form-control" id="exampleInputEmail1" placeholder="Enter Check Number">
                                                        @if ($errors->has('cheque_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('cheque_number') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            @endif

                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <input type="text" name="amount" value="{{$payment->amount}}" class="form-control" id="exampleInputEmail1" placeholder="Enter Amount">
                                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div><br><div class="clearfix"></div>
                            <h3 class="box-title">Receipt Information</h3><hr>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Receipt Number <span style="color: red">*</span></label>
                    <div class="col-md-8">
                        <input type="text" class="form-control" name='receipt_no' value="{{$payment->receipt_no}}" id="exampleInputEmail1" placeholder="Enter Receipt Number">
                    @if ($errors->has('receipt_no'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('receipt_no') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>
<!--              <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Reference Number </label>
                    <div class="col-md-8">
                        <input type="text" class="form-control" name="reference_no" value="{{$receipt->reference_no}}" id="exampleInputEmail1" placeholder="Enter Reference Number">
                    @if ($errors->has('reference_no'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('reference_no') }}</strong>
                                    </span>
                                @endif
                    </div>

                    </div>
              </div>  -->

              <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Receipt Date <span style="color: red">*</span></label>
                    <div class="col-md-8">
                        <input type="date" class="form-control" name='receipt_date' value="{{$payment->receipt_date}}" id="exampleInputEmail1" placeholder="Enter Receipt Date">
                    @if ($errors->has('receipt_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('receipt_date') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>

              <div class="form-group m-b-0 pull-right">
                    <div class="col-sm-offset-3 col-sm-9">
                        <button type="submit" class="btn btn-info  waves-effect waves-light ">Save</button>
                    </div>
              </div>
            </div>
        </div>
    </div>
    </form>
</div>


@stop

@section('js')
<script>
	function changeFunc(a){
    if(a == {{\App\Receipt::cash}})
    {
      $('#bank').css('display', 'none');
      $('#company-bank').css('display', 'none');
      $('#cheque').css('display', 'none');
      $('#adjustment').css('display', 'none');
    }
    else if(a == {{\App\Receipt::bank}})
    {
      $('#bank').css('display', 'block');
      $('#company-bank').css('display', 'block');
      $('#cheque').css('display', 'none');
      $('#adjustment').css('display', 'none');
    }
    else if(a == {{\App\Receipt::cheque}})
    {
      $('#bank').css('display', 'block');
      $('#company-bank').css('display', 'block');
      $('#cheque').css('display', 'block');
      $('#adjustment').css('display', 'none');
    }
    else if(a == {{\App\Receipt::adjustment}})
    {
      $('#bank').css('display', 'none');
      $('#company-bank').css('display', 'none');
      $('#cheque').css('display', 'none');
      $('#ament').css('display', 'block');
    }
  }

function updateProperty(){
    $('.preloader').fadeIn();

    var customer_id = $('#customer_id').val();


    var data = {'customer_id':customer_id};

    $.get('/add/customer-discount-payment/update-properties', data, function (data) {

        document.getElementById('property').innerHTML = data;
        $('#myTable').DataTable({
            "paging":   false,
        "ordering": false,
        "info":     false
        });
    });

  //  $('#wait').hide();
   $('.preloader').fadeOut();
}
</script>
@stop