@extends( 'layouts.app')

@section('title')
All Payments 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Payments</li>
      </ol>
@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
								<a href="{{route('customer-payment.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add new Payment
								</a>
							</div>
                            <h3 class="box-title">All Payments ({{number_format($totalAmount)}})</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Unit No.</th>
                                            <th>Customer</th>
                                            <th>Payment Mode</th>

                                            <th>Paid Amount </th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @foreach($payments->reverse() as $payment)
                                        <tr>
                                           <td>{{$payment->receipt_no}}</td>
                                             <td>{{$payment->property->inventory->unit_number}}</td>
                                             <td>{{$payment->property->customer ? $payment->property->customer->name : ''}}</td>

                                             @if($payment->payment_mode == \App\Receipt::cash)
                                            <td>Cash</td>
                                            @elseif($payment->payment_mode == \App\Receipt::bank)
                                            <td>Bank transfer</td>
                                            @elseif($payment->payment_mode == \App\Receipt::cheque)
                                            <td>Cheque</td>
                                            @else
                                            <td></td>

                                            @endif

                                            <td>{{number_format($payment->amount)}} PKR</td>
                                             <td> {{date('d-m-Y', strtotime($payment->receipt_date)) }}</td>
                                            <td class="text-nowrap">
                                                <a href="{{route('customer-payment.detail',['id'=>$payment->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                               <!--  <a href="{{route('payment.editView',['id'=>$payment->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a> -->
                                                <a href="{{route('customer-payment.delete',['id'=>$payment->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                            </td>
                                        </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop