@extends('layouts.app' )

@section('title')
Employee Detail
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-employee')
        <li ><a href="{{route('employee.all')}}">Employees</a></li>
        @endpermission
        <li class="active">Employee Detail</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-lg-12 col-sm-6 col-xs-12">
                        <div class="white-box">
                            <h3 class="box-title">{{$employee->name}}</h3><hr>
                            <!-- Nav tabs -->
                            <ul class="nav customtab nav-tabs" role="tablist">
                                <li role="presentation" class="active"><a href="#home1" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs"> Employment</span></a></li>
                                <li role="presentation" class=""><a href="#profile1" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Profile</span></a></li>
                                <li role="presentation" class=""><a href="#messages1" aria-controls="messages" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-email"></i></span> <span class="hidden-xs">Benefits</span></a></li>
                                 <li role="presentation" class=""><a href="#payroll" aria-controls="payroll" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-email"></i></span> <span class="hidden-xs">Payroll</span></a></li>
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane fade active in" id="home1">
                                	<h3 class="py-3">Employment Details</h3><br>
                                	<div class="form-body">
                                    <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">Basic Salary </label>
                                                        <div class="col-md-9">
                                                          <b>{{number_format($employee->basic_salary)}} PKR</b>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">Employee ID</label>
                                                        <div class="col-md-9">
                                                             <b>{{$employee->employee_id}}</b>
                                                    </div>
                                                </div>
                                            </div><div class="clearfix"></div>

                                    			<div class="col-md-6">
                                       				<div class="form-group">
                                                        <label class="control-label col-md-3">Designation</label>
                                                        <div class="col-md-9">
                                                            @if($employee->designation)

                                                           <b> {{$employee->designation->name}}</b>
                                                           @endif
                                                        </div>
                                                    </div>
                                    			</div>
                                    			<div class="col-md-6">
                                       				<div class="form-group">
                                                        <label class="control-label col-md-3">Department</label>
                                                        <div class="col-md-9">
                                                       @if($employee->department)

                                                           <b> {{$employee->department->name}}</b>
                                                           @endif
                                                        </div>
                                                    </div>
                                    			</div>
                                    			<div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">Start Date</label>
                                                        <div class="col-md-9">
                                                            <b>{{date('d-m-Y', strtotime($employee->start_date)) }}</b>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">Reference</label>
                                                        <div class="col-md-9">
                                                            <b>{{$employee->reference}}</b>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="clearfix"></div><br>
                                                <h3 class="py-3">Employment Status</h3><br>
                                                <div class="col-md-6">
                                       				<div class="form-group">
                                                        <label class="control-label col-md-3">Status</label>
                                                        <div class="col-md-9">
                                                            @if($employee->status == \App\Employee::active)
                                                            <b>Active</b>
                                                            @elseif($employee->status == \App\Employee::pending)
                                                            <b>Pending</b>
                                                            @elseif($employee->status == \App\Employee::terminated)
                                                            <b>Terminated</b>
                                                            @endif
                                                        </div>
                                                    </div>
                                    			</div>
                                    			<div class="col-md-6">
                                       				<div class="form-group">
                                                        <label class="control-label col-md-3">Employment Type</label>
                                                        <div class="col-md-9">
                                                           @if($employee->employee_type == \App\Employee::full)
                                                            <b>Full Time</b>
                                                            @elseif($employee->employee_type == \App\Employee::part)
                                                            <b>Part Time</b>
                                                            @elseif($employee->employee_type == \App\Employee::intern)
                                                            <b>Intern</b>
                                                            @endif
                                                        </div>
                                                    </div>
                                    			</div>
                                    			<div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">Working Hours/ Day</label>
                                                        <div class="col-md-9">
                                                            <b>{{$employee->working_hours}} hours</b>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">Working Days/ Week</label>
                                                        <div class="col-md-9">
                                                            <b>{{$employee->working_days}} Days</b>
                                                            </div>
                                                    </div>
                                                </div><div class="clearfix"></div><br>

                                                 <h3 class="py-3">Payment Information</h3><br>
                                                 <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">Name of the Bank</label>
                                                        <div class="col-md-9">
                                                             <b>{{$employee->bank_name}}</b>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-3">Account Title</label>
                                                        <div class="col-md-9">
                                                             <b>{{$employee->account_name}}</b>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-3">Account Number</label>
                                                        <div class="col-md-9">
                                                             <b>{{$employee->account_number}}</b>
                                                            </div>
                                                    </div>
                                                </div>

                                            </div>
                                           </div>
                                    <div class="clearfix"></div>
                                </div>
                                <div role="tabpanel" class="tab-pane fade" id="profile1">
                                    <h3 class="py-3">Basic Information</h3><br>
                                    			<div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-3">Phone Number</label>
                                                        <div class="col-md-9">
                                                             <b>{{$employee->phone_number}}</b>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-3">Email ID</label>
                                                        <div class="col-md-9">
                                                             <b>{{$employee->email}}</b>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-3">Address</label>
                                                        <div class="col-md-9">
                                                            <b>{{$employee->address}}</b>
                                                            </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                       				<div class="form-group">
                                                        <label class="control-label col-md-3">Gender</label>
                                                        <div class="col-md-9">
                                                            @if($employee->gender == \App\Employee::male)
                                                            <b>Male</b>
                                                            @elseif($employee->gender == \App\Employee::female)
                                                            <b>Female</b>
                                                            @endif
                                                        </div>
                                                    </div>
                                    			</div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-3">Date of Birth</label>
                                                        <div class="col-md-9">
                                                             <b>{{date('d-m-Y', strtotime($employee->dob)) }}</b>
                                                            </div>
                                                    </div>
                                                </div><div class="clearfix"></div><br>
                                                <h3 class="py-3">Emergency Contact</h3><br>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-3">Contact Person</label>
                                                        <div class="col-md-9">
                                                           <b>{{$employee->emer_person}}</b>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-3">Relation</label>
                                                        <div class="col-md-9">
                                                             <b>{{$employee->emer_relation}}</b>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-3">Phone Number</label>
                                                        <div class="col-md-9">
                                                            <b>{{$employee->phone_number}}</b>
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-3">E-mail</label>
                                                        <div class="col-md-9">
                                                            <b>{{$employee->emer_email}}</b>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Documents</h3><hr>
                                    <div class="table-responsive col-md-6">
                                        <table class="table">
                                            <tbody>
                                                <?php $c =1;?>
                                                @foreach($employee->documents as $d)
                                                <tr>
                                                    <td>{{$c++}}</td>
                                                    <td> <a target="_blank" href="{{asset('uploads/'.$d->url)}}">{{$d->url}}</a></td>
                                                </tr>
                                                @endforeach

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                                    <div class="clearfix"></div>
                                </div>


                                <div role="tabpanel" class="tab-pane fade" id="messages1">
                                	<h3 class="py-3">Benefits & Deductions</h3><br>
                                        @foreach($employee->policies as $policy)
                                	<div class="form-group">
                                		<input type="checkbox" class="pull-left" disabled="" checked>
                                		<label for="name" class="col-md-3 text-muted form-check-label">{{$policy->policy->name}}
                                                    @if($policy->policy->type == \App\Policy::allowance)
                                                    <span class="small font-italic">(Allowance)</span>
                                                    @else
                                                    <span class="small font-italic">(Deduction)</span>
                                                    @endif
                                        </label> <div class="col-md-6">{{number_format($policy->policy->amount)}} PKR</div>
                                    </div><div class="clearfix"></div>
                                    @endforeach

                                </div>

                                <div role="tabpanel" class="tab-pane fade" id="payroll">

                                     <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Basic</th>
                                            <th>Benefits</th>
                                            <th>Deductions</th>
                                            <th>Net Pay</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                          <?php $basic_salary = 0;$benefits = 0; $deduction =0;$net_pay=0;?>
                                        @foreach($employee->payroll as $payroll)
                                        <tr>
                                          <td>{{date('d-m-Y', strtotime($payroll->date)) }}</td>

                                            <td><?php $basic_salary +=$payroll->employee->basic_salary;?> {{number_format($payroll->employee->basic_salary)}} PKR</td>
                                            <td><?php $benefits +=$payroll->employee->benefits;?>{{number_format($payroll->benefits)}} PKR</td>
                                            <td><?php $deduction +=$payroll->deductions;?>{{number_format($payroll->deductions)}} PKR</td>
                                            <td><?php $net_pay +=$payroll->net_pay;?>{{number_format($payroll->net_pay)}} PKR</td>
                                        </tr>
                                        @endforeach
                                        <tfoot>
                                        <tr>
                                            <td></td>

                                            <td><b><hr>{{number_format($basic_salary)}} PKR </b></td>
                                            <td><b><hr>{{number_format($benefits)}} PKR </b></td>
                                            <td><b><hr>({{number_format($deduction)}}) PKR </b></td>
                                            <td><b><hr>{{number_format($net_pay)}} PKR </b></td>
                                        </tr>
                                    </tfoot>

                                    </tbody>
                                </table>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>


@stop


@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop