@extends('layouts.app')

@section('title')
Edit Employee
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-employee')
        <li ><a href="{{route('employee.all')}}">Employees</a></li>
        @endpermission
        <li class="active">Edit Employee</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-lg-12 col-sm-6 col-xs-12">
                        <div class="white-box">
                            <h3 class="box-title">Edit Employee</h3><hr>
                            <form method="post" action="{{route('employee.update')}}" enctype="multipart/form-data">
                                {{csrf_field()}}
                                <input type="hidden" name="id" value="{{$employee->id}}">
                            <!-- Nav tabs -->
                            <ul class="nav customtab nav-tabs" role="tablist">
                                <li role="presentation" class="active"><a href="#home1" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs"> Employment</span></a></li>
                                <li role="presentation" class=""><a href="#profile1" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Profile</span></a></li>
                                <li role="presentation" class=""><a href="#messages1" aria-controls="messages" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-email"></i></span> <span class="hidden-xs">Benefits</span></a></li>
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane fade active in" id="home1">
                                	<h3 class="py-3">Employment Details</h3><br>
                                	<div class="form-body">
                                    <div class="row">

                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Employee ID <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                             <input  type="text" class="form-control" name="employee_id" value="{{$employee->employee_id}}" id="employee_id" placeholder="Enter Employee ID">
                                                        @if ($errors->has('employee_id'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('employee_id') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>
                                        <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Employee Name <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                             <input  type="text" class="form-control" name="name" value="{{$employee->name}}" id="employee_id" placeholder="Enter Employee Name">
                                                        @if ($errors->has('name'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('name') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>
                                        <div class="clearfix"></div>
                                               <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Basic Salary <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                           <input type="text" class="form-control" name="basic_salary" value="{{$employee->basic_salary}}" id="basic_salery" placeholder="Enter Basic Salary">
                                                           @if ($errors->has('basic_salary'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('basic_salary') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>
                                    			<div class="col-md-6">
                                       				<div class="form-group">
                                                        <label class="control-label col-md-4">Designation <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name="designation_id" >
                                                             <option value="" selected="" disabled="">None</option>
                                                             @foreach($designations as $designation)
                                                             @if($employee->designation_id == $designation->id)
                                                             <option value="{{$designation->id}}" selected="">{{$designation->name}}</option>
                                                            @else
                                                              <option value="{{$designation->id}}">{{$designation->name}}</option>
                                                            @endif
                                                            @endforeach
                                                            </select>

                                                         @if ($errors->has('designation_id'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('designation_id') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                    			</div>

                                    			<div class="col-md-6">
                                       				<div class="form-group">
                                                        <label class="control-label col-md-4">Department <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name="department_id" >
                                                             <option value="" selected="" disabled="">None</option>
                                                             @foreach($departments as $department)
                                                             @if($employee->department_id == $department->id)
                                                             <option value="{{$department->id}}" selected="">{{$department->name}}</option>
                                                            @else
                                                              <option value="{{$department->id}}">{{$department->name}}</option>
                                                            @endif
                                                            @endforeach
                                                            </select>

                                                         @if ($errors->has('department_id'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('department_id') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                    			</div>
                                    			<div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Start Date</label>
                                                        <div class="col-md-8">
                                                             <input  type="date" class="form-control"  name="start_date" value="{{$employee->start_date}}" id="start_date" placeholder="Enter Start Date">
                                                        @if ($errors->has('start_date'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('start_date') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Reference <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                             <input  type="text" class="form-control" name="reference" value="{{$employee->reference}}" id="employee_id" placeholder="Enter Reference">
                                                        @if ($errors->has('reference'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('reference') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="clearfix"></div><br>
                                                <h3 class="py-3">Employment Status</h3><br>
                                                <div class="col-md-6">
                                       				<div class="form-group">
                                                        <label class="control-label col-md-4">Status <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name="status">
                                                             <option value="" selected="" disabled="">None</option>
                                                             @if($employee->status == \App\Employee::active)
                                                             <option value='{{\App\Employee::active}}' selected="">Active</option>
                                                             <option value='{{\App\Employee::pending}}'>Pending</option>
                                                             <option value='{{\App\Employee::terminated}}'>Terminated</option>
                                                             @elseif($employee->status == \App\Employee::pending)
                                                             <option value='{{\App\Employee::active}}' >Active</option>
                                                             <option value='{{\App\Employee::pending}}'selected="">Pending</option>
                                                             <option value='{{\App\Employee::terminated}}'>Terminated</option>
                                                             @elseif($employee->status == \App\Employee::terminated)
                                                             <option value='{{\App\Employee::active}}'>Active</option>
                                                             <option value='{{\App\Employee::pending}}'>Pending</option>
                                                             <option value='{{\App\Employee::terminated}}'  selected="">Terminated</option>
                                                             @else
                                                             <option value='{{\App\Employee::active}}'>Active</option>
                                                             <option value='{{\App\Employee::pending}}'>Pending</option>
                                                             <option value='{{\App\Employee::terminated}}'>Terminated</option>
                                                             @endif

                                                            </select>
                                                            @if ($errors->has('status'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('status') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                    			</div>
                                    			<div class="col-md-6">
                                       				<div class="form-group">
                                                        <label class="control-label col-md-4">Employment Type <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name="employee_type">
                                                             <option value="" selected="" disabled="">None</option>
                                                             @if($employee->employee_type == \App\Employee::full)
                                                             <option value='{{\App\Employee::full}}' selected="">Full time</option>
                                                             <option value='{{\App\Employee::part}}'>Part time</option>
                                                             <option value='{{\App\Employee::intern}}'>Inern</option>
                                                             @elseif($employee->employee_type == \App\Employee::part)
                                                             <option value='{{\App\Employee::full}}' >Full time</option>
                                                             <option value='{{\App\Employee::part}}'selected="">Part time</option>
                                                             <option value='{{\App\Employee::intern}}'>Intern</option>
                                                             @elseif($employee->employee_type == \App\Employee::intern)
                                                             <option value='{{\App\Employee::full}}'>Full time</option>
                                                             <option value='{{\App\Employee::part}}'>Part time</option>
                                                             <option value='{{\App\Employee::intern}}'  selected="">Intern</option>
                                                             @else
                                                             <option value='{{\App\Employee::full}}'>Full time</option>
                                                             <option value='{{\App\Employee::part}}'>Part time</option>
                                                             <option value='{{\App\Employee::intern}}'>Intern</option>
                                                             @endif

                                                            </select>
                                                            @if ($errors->has('employee_type'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('employee_type') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                    			</div>
                                    			<div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Working Hours/ Day</label>
                                                        <div class="col-md-8">
                                                            <input  type="number" class="form-control"  id="working_hours" name='working_hours' value="{{$employee->working_hours}}" placeholder="Enter Working Hours">
                                                        @if ($errors->has('working_hours'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('working_hours') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Working Days/ Week</label>
                                                        <div class="col-md-8">
                                                            <input  type="number" class="form-control"  id="working_days" name='working_days' value="{{$employee->working_days}}" placeholder="Enter Working Days">
                                                        @if ($errors->has('working_days'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('working_days') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div><div class="clearfix"></div><br>

                                                 <h3 class="py-3">Payment Information</h3><br>
                                                 <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Name of the Bank</label>
                                                        <div class="col-md-8">
                                                            <input  type="text" class="form-control"  id="bank_name" name='bank_name' value="{{$employee->bank_name}}" placeholder="Enter Bank Name">
                                                        @if ($errors->has('bank_name'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('bank_name') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-4">Account Title</label>
                                                        <div class="col-md-8">
                                                            <input  type="text" class="form-control"  id="account_name" name="account_name" value="{{$employee->account_name}}" placeholder="Enter Account Title">
                                                        @if ($errors->has('account_name'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('account_name') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-4">Account Number</label>
                                                        <div class="col-md-8">
                                                            <input  type="text" class="form-control"  id="account_number" name='account_number' value="{{$employee->account_number}}" placeholder="Enter Account Number">
                                                        @if ($errors->has('account_number'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('account_number') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                           </div>
                                    <div class="clearfix"></div>
                                </div>
                                <div role="tabpanel" class="tab-pane fade" id="profile1">
                                    <h3 class="py-3">Basic Information</h3><br>
                                    <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-4">Email</label>
                                                        <div class="col-md-8">
                                                            <input  type="text" class="form-control"  id="email" name="email" value="{{$employee->email}}" placeholder="Enter Email">
                                                        @if ($errors->has('email'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('email') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>
                                    			<div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-4">Phone Number</label>
                                                        <div class="col-md-8">
                                                            <input type="text" class="form-control" maxlength="12" data-inputmask="'mask': '0399-99999999'" type='number' name="phone_number" value="{{$employee->phone_number}}"  placeholder="Enter Phone Number">
                                                        @if ($errors->has('phone_number'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('phone_number') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-4">Address</label>
                                                        <div class="col-md-8">
                                                            <input  type="text" class="form-control"  id="address" name='address' value="{{$employee->address}}" placeholder="Enter Address">
                                                        @if ($errors->has('address'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('address') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                       				<div class="form-group">
                                                        <label class="control-label col-md-4">Gender</label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name='gender'>
                                                             <option value="" selected="" disabled="">None</option>
                                                             @if($employee->gender == \App\Employee::male)
                                                             <option value="{{\App\Employee::male}}" selected="">Male</option>
                                                             <option value="{{\App\Employee::female}}">Female</option>
                                                             @elseif($employee->gender == \App\Employee::female)
                                                             <option value="{{\App\Employee::male}}" >Male</option>
                                                             <option value="{{\App\Employee::female}}" selected=""> Female</option>
                                                             @else
                                                             <option value="{{\App\Employee::male}}" >Male</option>
                                                             <option value="{{\App\Employee::female}}" > Female</option>
                                                             @endif
                                                            </select>
                                                            @if ($errors->has('gender'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('gender') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                    			</div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-4">Date of Birth</label>
                                                        <div class="col-md-8">
                                                            <input  type="date" class="form-control"  id="dob" name='dob' value="{{$employee->dob}}" placeholder="Enter Skype ID">
                                                        @if ($errors->has('dob'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('dob') }}</strong>
                                                            </span>
                                                           @endif

                                                        </div>
                                                    </div>
                                                </div><div class="clearfix"></div><br>
                                                <h3 class="py-3">Emergency Contact</h3><br>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-4">Contact Person</label>
                                                        <div class="col-md-8">
                                                            <input  type="text" class="form-control"  id="emer_person" name="emer_person" value="{{$employee->emer_person}}" placeholder="Enter Contact PersonH">
                                                        @if ($errors->has('emer_person'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('emer_person') }}</strong>
                                                            </span>
                                                           @endif

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-4">Relation</label>
                                                        <div class="col-md-8">
                                                            <input  type="text" class="form-control"  id="emer_relation" name="emer_relation" value="{{$employee->emer_relation}}" placeholder="Enter Relation">
                                                        @if ($errors->has('emer_relation'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('emer_relation') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-4">Phone Number</label>
                                                        <div class="col-md-8">
                                                           <input type="text" class="form-control" maxlength="12" data-inputmask="'mask': '0399-99999999'" type='number' name="emer_phone_number" value="{{$employee->emer_phone_number}}"  placeholder="Enter Phone Number">
                                                        @if ($errors->has('emer_phone_number'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('emer_phone_number') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                       <label class="control-label col-md-4">E-mail</label>
                                                        <div class="col-md-8">
                                                            <input  type="email" class="form-control"  id="emer_email" name="emer_email" value="{{$employee->emer_email}}" placeholder="Enter Email Address">
                                                        @if ($errors->has('emer_email'))
                                                            <span class="help-block">
                                                            <strong>{{ $errors->first('emer_email') }}</strong>
                                                            </span>
                                                           @endif
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Documents (CNIC, Passport etc) <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-picture"></i></div>
                                            <input multiple="" type="file" class="form-control" name="photos[]" >
                                        @if ($errors->has('document'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('document') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>
                            </div>


                                    <div class="clearfix"></div>
                                </div>
                                <div role="tabpanel" class="tab-pane fade" id="messages1">
                                	<h3 class="py-3">Benefits & Deductions</h3><br>
                                	@foreach($policies as $policy)
                                	<div class="form-group">
                                            @if($employee->policies->contains('policy_id', $policy->id))
                                            <input type="checkbox" name="policies[]" checked="" value="{{$policy->id}}" class="pull-left">
                                              @else
                                              <input type="checkbox" name="policies[]" value="{{$policy->id}}" class="pull-left">
                                              @endif
                                		<label for="name" class="col-md-4 text-muted form-check-label">{{$policy->name}}
                                                    @if($policy->type == \App\Policy::allowance)
                                        	<span class="small font-italic">(Allowance)</span>
                                                @else
                                                <span class="small font-italic">(Deduction)</span>
                                                @endif
                                        </label> <div class="col-md-6">{{number_format($policy->amount)}} PKR</div>
                                    </div><div class="clearfix"></div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="form-group row mt-5 ml-5"><div class="col-md-6 pull-right"><button type="submit" class="btn btn-primary">
                            Save
                        </button></div></div>
                        </form>
                        </div>
                    </div>
                </div>
            </div>


@stop
