@extends('layouts.app' )

@section('title')
All Employees 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Employees</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            @permission('create-employee')
                        	<div class="pull-right">
								<a href="{{route('employee.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add new Employee
								</a>
							</div>
                            @endpermission
                            <h3 class="box-title">All Employee</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Emp #</th>
                                            <th>Name</th>
                                            <th>Designation</th>
                                            <th>Department</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($allEmployees as $employee)
                                        <tr>
                                            <td>{{$employee->employee_id}}</td>
                                             <td>{{$employee->name}}</td>
                                             @if($employee->designation)
                                            <td>{{$employee->designation->name}}</td>
                                            @else
                                            <td></td>
                                            @endif
                                             @if($employee->department)
                                            <td>{{$employee->department->name}}</td>
                                            @else
                                            <td></td>
                                            @endif
                                            @if($employee->status == \App\Employee::active)
                                            <td><span class="label label-success">Active</span></td>
                                            @elseif($employee->status == \App\Employee::pending)
                                            <td><span class="label label-primary">Pending</span></td>
                                            @elseif($employee->status == \App\Employee::terminated)
                                            <td><span class="label label-danger">Terminated</span></td>
                                           @else
                                            <td><span class="label label-success"></span></td>
                                            @endif

                                            <td class="text-nowrap">
                                                @permission('view-employee')
                                                <a href="{{route('employee.detail',['id' => $employee->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i>
                                                
                                                 </a>
                                                 @endpermission

                                                 @permission('edit-employee')
                                                <a href="{{route('employee.editView',['id' => $employee->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endpermission
                                                @permission('delete-employee')
                                               <a href="{{route('employee.delete',['id' => $employee->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                               @endpermission
                                            </td>
                                        </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop