@extends('layouts.app')

@section('title')
Payroll History 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Payroll History</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">

                            <h3 class="box-title">Payroll History <b>({{number_format($totalPay)}} PKR)</b></h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Employee</th>
                                            <th>Basic</th>
                                            <th>Benefits</th>
                                            <th>Deductions</th>
                                            <th>Net Pay</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $basic_salary = 0;$benefits = 0; $deduction =0;$net_pay=0;?>
                                        @foreach($payrolls as $payroll)
                                        <tr>
                                          <td>{{date('d-m-Y', strtotime($payroll->date)) }}</td>
                                          <td>{{$payroll->employee ? $payroll->employee->name : ''}} </td>
                                            <td><?php $basic_salary +=$payroll->employee ? $payroll->employee->basic_salary : 0;?> {{number_format($payroll->employee ? $payroll->employee->basic_salary : 0)}} PKR</td>
                                            <td><?php $benefits +=$payroll->benefits;?>{{number_format($payroll->benefits)}} PKR</td>
                                            <td><?php $deduction +=$payroll->deductions;?>{{number_format($payroll->deductions)}} PKR</td>
                                            <td><?php $net_pay +=$payroll->net_pay;?>{{number_format($payroll->net_pay)}} PKR</td>
                                        </tr>
                                        @endforeach
                                    <tfoot>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td><b><hr>{{number_format($basic_salary)}} PKR </b></td>
                                            <td><b><hr>{{number_format($benefits)}} PKR </b></td>
                                            <td><b><hr>({{number_format($deduction)}}) PKR </b></td>
                                            <td><b><hr>{{number_format($net_pay)}} PKR </b></td>
                                        </tr>
                                    </tfoot>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop