@extends('layouts.app')

@section('title')
Payroll 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Payrolls</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">

                            <h1 class="box-title"><b>Payroll For {{ Carbon\Carbon::now()->format('F, Y')}}</b></h1>

                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead class="text-primary">
                                        <tr>
                                            <th>Employees</th>
                                            <th style="text-align: center">Benefits</th>
                                            <th style="text-align: center">Deductions</th>
                                            <th>Net Pay</th>
                                            <th> Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($employees as $employee)
                                        <?php $allowance=0;$deduction=0;?>
                                        <tr>
                                            <td>
                                                <div class="font-weight-bold mb-2">
                                                    <a href="{{route('employee.detail',['id'=>$employee->id])}}" class="text-dark"><b>{{$employee->name}}</b></a>
                                                </div> <br>
                                                <div class="row">
                                                    <div class="col-md-2 text-muted">Basic</div>
                                                    <div class="col-md-6">{{number_format($employee->basic_salary)}} PKR</div>
                                                </div><br>
                                            </td>
                                            @foreach($employee->policies as $policy)

                                            @if($policy->policy->type == \App\Policy::allowance)
                                            <?php $allowance += $policy->policy->amount;?>
                                            @elseif($policy->policy->type == \App\Policy::deduction)
                                             <?php $deduction += $policy->policy->amount;?>
                                            @endif
                                            @endforeach

                                            <td>
                                              @foreach($employee->policies as $policy)

                                            @if($policy->policy->type == \App\Policy::allowance)
                                           <div class="row">
                                                <div class="col-md-5 text-muted">{{$policy->policy->name}}</div>
                                                <div class="col-md-5">{{number_format($policy->policy->amount)}} PKR</div>
                                            </div>

                                            @endif
                                            @endforeach
                                             <div class="row">
                                                  <div class="col-md-5 text-muted"></div>

                                                  <div class="col-md-5"><hr><b>{{number_format($allowance)}} PKR</b></div>
                                            </div>

                                            </td>
                                            <td>
                                                @foreach($employee->policies as $policy)

                                            @if($policy->policy->type == \App\Policy::deduction)
                                           <div class="row">
                                                <div class="col-md-5 text-muted">{{$policy->policy->name}}</div>
                                                <div class="col-md-5">({{number_format($policy->policy->amount)}}) PKR</div>
                                            </div>

                                            @endif
                                            @endforeach
                                            <div class="row">
                                                 <div class="col-md-5 text-muted"></div>

                                                 <div class="col-md-5"><hr><b>({{number_format($deduction)}}) PKR</b></div>
                                            </div>



                                                </td>
                                                <td><b>{{number_format($employee->basic_salary + $allowance - $deduction)}} PKR</b></td>
                                                <th>
                                                    @if($salaryPaid[$employee->id] == true)
                                                    <a title="Salary already paid." class="btn  btn-primary" style = "color: currentColor;cursor: not-allowed;opacity: 0.5;text-decoration: none;">
									<i class="fa fa-check"></i>&nbsp;Run</a>
                                                    @else
                                                    <a href="{{route('employee.payroll.run',['id'=>$employee->id])}}"  class="btn  btn-primary">
									<i class="fa fa-check"></i>&nbsp;Run</a>
                                                    @endif
                                                </th>

                                        </tr>

                                            @endforeach

                                            </tbody>
                                        </table>
                                </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop