@extends('layouts.app' )

@section('title')
Add New Policy 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('manage-policy')
        <li ><a href="{{route('policy.all')}}">Policies</a></li>
        @endpermission
        <li class="active">Add Policy</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Add New Policy</h3><hr>
                            <form class="form-horizontal" action="{{route('policy.insert')}}" method="post">
                               {{csrf_field()}}
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="name" value="{{old('name')}}" id="exampleInputuname" placeholder="Enter Name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group" >
                                    <label for="inputPassword3" class="col-sm-2 control-label">Type<span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <select class="form-control chosen-select" style="width:300px" name="type">
                                                @if(old('type'))
                                                @if(old('type') == \App\Policy::allowance)
                                                <option value='{{\App\Policy::allowance}}' selected="">Allowance</option>
                                                <option value="{{\App\Policy::deduction}}">Deduction</option>
                                                @else
                                                <option value='{{\App\Policy::allowance}}' >Allowance</option>
                                                <option value="{{\App\Policy::deduction}}"selected="">Deduction</option>
                                                @endif
                                                @else
                                               <option value='{{\App\Policy::allowance}}' selected="">Allowance</option>
                                                <option value="{{\App\Policy::deduction}}">Deduction</option>
                                                @endif

                                            </select>

                                        @if ($errors->has('type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('type') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Amount <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="numeric" class="form-control" name="amount" value="{{old('amount')}}" id="exampleInputuname" placeholder="Enter Amount">
                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop