@extends('layouts.app')

@section('title')
All Policies 
@stop


@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Policies</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('manage-policy')
								<a href="{{route('policy.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add new Policy
								</a>
                                @endpermission
							</div>
                            <h3 class="box-title">All Policies</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Type</th>
                                            <th>Amount</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allPolicies as $policy)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$policy->name}}</td>
                                            @if($policy->type == \App\Policy::allowance)
                                            <td>Allowance</td>
                                            @elseif($policy->type == \App\Policy::deduction)
                                            <td>Deduction</td>
                                            @else
                                            <td></td>
                                            @endif
                                            <td>{{number_format($policy->amount)}} PKR</td>

                                            <td class="text-nowrap">
                                                @permission('manage-policy')
                                                <a href="{{route('policy.editView',['id'=>$policy->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endpermission
                                                @permission('manage-policy')
                                                <a href="{{route('policy.delete',['id'=>$policy->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                                @endpermission
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop