@extends('layouts.app')


@section('title')
    Add New Price List
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-inventory')
            <li><a href="{{ route('pricelist.index') }}">All Price List</a></li>
        @endpermission
        <li class="active">Add Price</li>
    </ol>
@stop

@section('content')
@php
 $size=  '';

if($projectType->id == \App\ProjectType::society){
                                               
      $size=        \App\ProjectType::society_size;
            }
                                               else
                                               { $size=   \App\ProjectType::high_rise_size;}
                                            
@endphp

@php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

        $map= \App\ProjectType::society_map;
    }

    else
    { 
        $map= \App\ProjectType::high_rise_map;
    }

@endphp

    <div class="container-fluid">
           <!--.row-->
              
                <!--./row-->
        <!--.row-->

        <div class="row">

            <div class="col-md-12">
                @if ($errors->any())
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                        </ul>
                    </div>
                @endif
                   @php
                      $society = false;
                   $highrise = false;

                if ($projecttype->id == App\ProjectType::society){
                    $society = true;
                }
                
                
              
                if ($projecttype->id == App\ProjectType::high_rise){
                    $highrise = true;
                }
                
                @endphp

              
         
                <div class="white-box">

                    <h3 class="box-title m-b-0"><i class="fa fa-info-circle"></i> Add New Price List</h3>
                    <p class="text-muted m-b-30 font-13">Add Information </p>
                    <hr>
                    <form class="form-horizontal" action="{{ route('pricelist.store') }}" method="post">
                        {{ csrf_field() }}

                        <div class="form-group">
                            @if ($society && $highrise)
                                <label for="address" class="col-sm-2 control-label">Society</label>
                                <div class="col-sm-4">
                                    <div class="input-group">

                                        <input type="radio"
                                            <?= old('project_type') == App\ProjectType::society ? 'checked' : '' ?>
                                            name="project_type" value="{{ App\ProjectType::society }}" style="zoom: 1.6;"
                                            onchange="check_post(this)" checked>
                                        @if ($errors->has('project_type'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('project_type') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                           
                           

                                <label for="address" class="col-sm-2 control-label">High Rise</label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <input type="radio" name="project_type" value="{{ App\ProjectType::high_rise }}"
                                            <?= old('project_type') == App\ProjectType::high_rise ? 'checked' : '' ?>
                                            style="zoom: 1.6;" onchange="check_post(this)">
                                        @if ($errors->has('project_type'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('project_type') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            @elseif($society)
                            <input type="hidden"
                             
                            name="project_type" value="{{ App\ProjectType::society }}"  >
                            @elseif($highrise)
                            <input type="hidden" name="project_type" value="{{ App\ProjectType::high_rise }}"
                            >
                                @endif
                        </div>

                        <div class="form-group">
                            <h2 style='padding-left:1%'>List No:</h2>
                            {{-- <label for="address" class="  control-label">List #</label> --}}
                            <div class="col-sm-12">
                                <div class="input-group" style='width: 38%; margin-left: 90px; margin-top: -45px;'>
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="text" class="form-control" name="list_number"
                                        value="LN-00{{ \App\PriceList::getUniqueList() }}" id="list_number"
                                        placeholder="Enter Plot / Serial Number">
                                    @if ($errors->has('list_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('list_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-info">
                                    <div class="panel-heading">Add Detail
                                    </div>
                        @if ($highrise)

                        <div class="form-group" id="highrise_price" >
                            <div class=col-md-12 style="overflow-y:auto;height:381px;">
                                <table class="table table-bordered table-responsive-md table-striped text-center">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Unit {{$map}}</th>
                                            <th class="text-center">Unit Type</th>
                                    
                                            <th class="text-center">Per/  {{$size}} Price (PKR)</th>
                                            


                                            

                                        </tr>
                                      


                                    </thead>
                                    <tbody id="tbody_data">
                                        <?php for($i =0 ; $i<1; $i++) {?>
                                        <tr height="2px" id="account_tr_{{ $i }}"
                                            data-id="{{ $i }}">

                                            <td class="pt-3-half account" style="width: 30%" contenteditable="true">


                                                <select class="form-control chosen-select us_acnt"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_floor[]">
                                                    <option  >None</option>
                                                    @foreach ($h_r_floor as $t)
                                                        <option value="{{ $t->id }}">
                                                            {{ $t->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                           
                                            <td class="pt-3-half account" style="width: 30%" contenteditable="true">
                                                <select class="form-control chosen-select us_acnt"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_type[]">
                                                    <option  >None</option>
                                                    @foreach ($h_r_types as $t)
                                                        <option value="{{ $t->id }}">
                                                            {{ $t->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                           
                                            

                                            <td class="pt-3-half name" style='width: 30%;'>
                                                <input class="form-control size unit_quantity" data-id="0"  id='per_price_0' onkeyup="perPriceFunction(this)" onclick="perPriceFunction(this)" type="number" name='per_price[]'>
                                            </td>
                                         

                                            <td class="pt-3-half name">
                                                <button type="button" class="btn btn-sm btn-success btn-sm addRowBtn"
                                                    data-id="{{ $i }}" onclick="addNewRow(this)"><i
                                                        class="fa fa-plus"></i></button>

                                            </td>

                                        </tr>

                                        <tr id="narration_tr_{{ $i }}" class="tr_{{ $i }}">

                                        </tr>

                                        <?php } ?>



                                     


                                    </tbody>
                                </table>
                            </div>
                        </div>

                         @endif
                         @if ($society)

                        <div class='society' id='society_data' style="display:<?= old('type') == 1 ? 'none' : '' ?>">

                            <div class=col-md-12 style="overflow-y:auto;height:381px;">
                                <table class="table table-bordered table-responsive-md table-striped text-center">
                                    <thead>
                                        <tr>

                                            <th class="text-center">Unit Type</th>
                                            <th class="text-center">Size</th>
                                            <th class="text-center">Per/{{$size}} Price (PKR)</th>
                                            <th class="text-center">Total Price (PKR)</th>




                                        </tr>

                                    </thead>
                                    <tbody id="tbody_data">
                                        <?php for($i =0 ; $i<1; $i++) {?>
                                        <tr height="2px" id="account_tr_{{ $i }}"
                                            data-id="{{ $i }}">

                                            <td class="pt-3-half account" style="width: 40%" contenteditable="true">


                                                <select class="form-control chosen-select us_acnt"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_type[]">
                                                    <option  >None</option>
                                                    @foreach ($types as $t)
                                                        <option value="{{ $t->id }}">
                                                            {{ $t->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                             
                                            <td class="pt-3-half name" contenteditable="true">
                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_size[]" id='unit_size_0'  onchange="unitChangeFunction(this)" data-id='0'>
                                                    <option  >None</option>
                                                    @foreach ($sizes as $s)
                                                        <option style="font-size: 11px;" value="{{ $s->id }}" data-value={{$s->name}}>
                                                            {{ $s->name }} {{$size}}
                                                        </option>
                                                    @endforeach

                                                </select>
                                            </td>
                                           
                                            

                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" data-id="0"  id='per_price_0' onkeyup="perPriceFunction(this)" onclick="perPriceFunction(this)" type="number" name='per_price[]'>
                                            </td>
                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" data-id="0"  id='total_price_0'  onkeyup="totalPriceFunction(this)" onclick="totalPriceFunction(this)" type="number" name='total_price[]'>
                                            </td>

                                            <td class="pt-3-half name">
                                                <button type="button" class="btn btn-sm btn-success btn-sm addRowBtn"
                                                    data-id="{{ $i }}" onclick="addNewRow(this)"><i
                                                        class="fa fa-plus"></i></button>

                                            </td>

                                        </tr>

                                        <tr id="narration_tr_{{ $i }}" class="tr_{{ $i }}">

                                        </tr>

                                        <?php } ?>



                                     


                                    </tbody>
                                </table>
                            </div>
                           

                        </div>
                              
                        @endif












                        <div class="form-group">
                            <div class="col-sm-4">&nbsp;</div>
                            <div class=" col-sm-4">
                                <button type="submit" class="btn btn-info waves-effect waves-light "
                                    style="width: 100%">Save</button>
                            </div>
                        </div>
                                   
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

@stop


@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
        function check_post(self) {
            if ($(self).val() == {{ App\ProjectType::high_rise }}) {
                $('#highrise_price').show();
                $('#society_data').hide();
            } else {
                $('#society_data').show();
                $('#highrise_price').hide();
            }
        }

        function removeParentDiv(self) {
            var id = $(self).closest('tr').data("id");

            // console.log(id);
            $('#account_tr_' + id).remove()
            $('#narration_tr_' + id).remove()
        }

       
        
       
      
 var count =1;
        function addNewRow(self) {
            $(".chosen-select").chosen("destroy");
            count = count +1;
            @if ($highrise)
            var account_row= `<tr height="2px" id="account_tr_`+count+`"
                                            data-id="`+count+`" >
                                            <td class="pt-3-half account" style="width: 20%" contenteditable="true">


<select class="form-control chosen-select us_acnt"
    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
    name="unit_floor[]">
    <option  >None</option>
    @foreach ($h_r_floor as $t)
        <option value="{{ $t->id }}">
            {{ $t->name }}
        </option>
    @endforeach
</select>
</td>
                                            <td class="pt-3-half account" style="width: 20%" contenteditable="true">


                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_type[]">
                                                    <option  >None</option>
                                                    @foreach ($h_r_types as $t)
                                                        <option value="{{ $t->id }}">
                                                            {{ $t->name }}
                                                        </option>
                                                    @endforeach

                                                </select>
                                            </td>
                                           
                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" id='per_price_`+count+`' data-id="`+ count+`" type="number" name='per_price[]'  >
                                            </td>
                                           
                                             
                                          

                                            <td class="pt-3-half name">

                                                <button type="button" class="btn btn-sm btn-danger btn-sm"
                                                    onclick="removeParentDiv(this)"><i
                                                        class="fa fa-times"></i></button>
                                            </td>
                                           
                                        </tr>
                                             `;
            @endif
            @if ($society)
            var account_row= `<tr height="2px" id="account_tr_`+count+`"
                                            data-id="`+count+`" >

                                            <td class="pt-3-half account" style="width: 40%" contenteditable="true">


                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_type[]">
                                                    <option  >None</option>
                                                    @foreach ($types as $t)
                                                        <option value="{{ $t->id }}">
                                                            {{ $t->name }}
                                                        </option>
                                                    @endforeach

                                                </select>
                                            </td>
                                            <td class="pt-3-half name" contenteditable="true">
                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_size[]" id='unit_size_`+count+`' onchange="unitChangeFunction(this)" data-id='`+count+`'>
                                                    <option  >None</option>
                                                    @foreach ($sizes as $s)
                                                        <option style="font-size: 11px;" value="{{ $s->id }}" data-value={{$s->name}}>
                                                            {{ $s->name }} {{ $size }}
                                                        </option>
                                                    @endforeach

                                                </select>
                                            </td>
                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" id='per_price_`+count+`' data-id="`+ count+`" type="number" name='per_price[]' onkeyup="perPriceFunction(this)"  onclick="perPriceFunction(this)" >
                                            </td>
                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" id='total_price_`+count+`' data-id="` +count+`" type="number" name='total_price[]' onkeyup="totalPriceFunction(this)" onclick="totalPriceFunction(this)" >
                                            </td>

                                          

                                            <td class="pt-3-half name">

                                                <button type="button" class="btn btn-sm btn-danger btn-sm"
                                                    onclick="removeParentDiv(this)"><i
                                                        class="fa fa-times"></i></button>
                                            </td>

                                        </tr>
                                             `;
                                             @endif

var tr_id = $(self).data("id");
           $('.tr_' + tr_id).after(account_row);
           $('.chosen-select').chosen();
        }

        function perPriceFunction(e){

        count_val = e.getAttribute("data-id");
        unit_size = $('#unit_size_'+ count_val).find(':selected').attr('data-value');
        per_price =    $('#per_price_'+ count_val).val();
        if(unit_size != undefined){
         result =   parseFloat(per_price) * parseFloat(unit_size);
         $('#total_price_'+ count_val).val(  result);
        }
        }

        function totalPriceFunction(e){

count_val = e.getAttribute("data-id");
unit_size = $('#unit_size_'+ count_val).find(':selected').attr('data-value');
 total_price = $('#total_price_'+ count_val).val();
if(unit_size != undefined){
 result =    parseFloat(total_price)/parseFloat(unit_size) ;
 $('#per_price_'+ count_val).val(result.toFixed(2));
}

}

function unitChangeFunction(e){
    count_val = e.getAttribute("data-id");
unit_size = $('#unit_size_'+ count_val).find(':selected').attr('data-value');
 total_price = $('#total_price_'+ count_val).val();
 per_price =    $('#per_price_'+ count_val).val();
if(unit_size != undefined){
    if(per_price != 0){
      
        result =   parseFloat(per_price) * parseFloat(unit_size);
        $('#total_price_'+ count_val).val(result);
    }else if(total_price != 0){
        result =    parseFloat(total_price)/parseFloat(unit_size) ;
 $('#per_price_'+ count_val).val(result.toFixed(2));
    }
  
}
}
    </script>
@stop
