@extends( 'layouts.app')


@section('title')
Price List Detail 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{ route('pricelist.index') }}">All Price List</a></li>
        <li class="active">Price List Detail</li>
      </ol>
@stop

@section('content')
<div class="container-fluid">
    @php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
@endphp
    <!-- /row -->
    <div class="row">
        <div class="col-sm-12">
            <div class="white-box">
                <h3 class="box-title">Price List Details</h3>
                <hr>
                <div class="table-responsive">
                    <table class="table">
                        <tbody>
                            <tr style="background: #F6F6F6; height: 45px;">
                                <td>Price List No:</td>
                                <td>{{ $pricelist->l_no }}</td>
                            </tr>
                            <tr  style="background: #F6F6F6; height: 45px;">
                                <td>Project Type:</td>
                                <td>{{ $pricelist->projecttype ? $pricelist->projecttype->name  : 'NIL' }}</td>
                            </tr>
                         
                        </tbody>
                    </table>
                    @if($projectType->id == \App\ProjectType::society)
                    <table id="myTable" class="table table-striped">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>Unit Type</th>
                                <th>Unit Size</th>
                              
                                <th>Price per {{ $size }} (PKR)</th>
                                
                                <th>Total Price (PKR)</th>
                            </tr>
                        </thead>
                        <br><br>    
                        <tbody>
                            <?php $count = 1; ?>

                            @foreach ($pricelist->pricedetail as $p)
                                <tr>
                                    <td>{{ $count++ }}</td>
                                    <td>{{ $p->unittype->name }}</td>
                                    <td>{{ $p->unitSize?$p->unitSize->name:'' }} {{$size}}</td>
                                    <td>{{ $p->per_size_price }}</td>
                                    <td>{{ $p->total_price }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @endif
                    @if($projectType->id == \App\ProjectType::high_rise)
                    <table id="myTable" class="table table-striped">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>Unit Floor</th>
                                <th>Unit Type</th>
                                 
                              
                                <th>Price per {{ $size }} (PKR)</th>
                                
                                
                            </tr>
                        </thead>
                        <br><br>    
                        <tbody>
                            <?php $count = 1; ?>

                            @foreach ($pricelist->pricedetail as $p)
                                <tr>
                                    <td>{{ $count++ }}</td>
                                    <td>{{$p->unitfloor? $p->unitfloor->name:'' }}</td> 
                                    <td>{{ $p->unittype->name }}</td>
                                  
                                    <td>{{ $p->per_size_price }}</td>
                                    
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @endif

                </div>
            </div>
        </div>
    </div>
    <!-- /.row -->
</div>
<!-- /.container-fluid -->
@stop