@extends('layouts.app')


@section('title')
Price List
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-inventory')
        <li class="active"> All Price List</li>
        @endpermission
    </ol>
@stop

@section('content')
    <!-- .container-fluid -->
        <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">
                        @permission('edit-pricelist')
                            <a href="{{ route('pricelist.create') }}" class="btn  btn-primary">
                                <i class="fa fa-plus-square"></i>&nbsp; Add New Price List
                            </a>
                        @endpermission

                    </div>
                    <h3 class="box-title">All Price Lists</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Price List No.</th>
                                    <th>Project Type</th>
                                     
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                               

                                @foreach ($allpricelist as $p)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $p->l_no }}</td>
                                        <td>{{ $p->projecttype ? $p->projecttype->name  : 'NIL' }}</td>
                                        
                                    

                                        <td class="text-nowrap">
                                            
                                                <a href="{{ route('pricelist.view',['id'=>$p->id]) }}"
                                                    data-toggle="tooltip" data-original-title="View"> <i
                                                        class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>


                                            
                                                <a href="{{ route('pricelist.edit', [$p->id]) }}" data-toggle="tooltip"
                                                    datza-original-title="Edit"> <i
                                                        class="fa fa-pencil text-inverse m-r-10"></i></a>
                                            

                                            
                                                {{-- <form action="{{ route('pricelist.delete', [$p->id]) }}" method="post"
                                                    style='display: inline;'>
                                                    {!! method_field('delete') !!}
                                                    {!! csrf_field() !!}


                                                    <button class="btn btn-link btn-s" style="color:red;" type="submit"
                                                        name="action" value="delete" data-toggle="confirmation"
                                                        data-title="Are you sure to delete?">
                                                        <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                    </button>
                                                </form> --}}
                                            
                                        </td> 
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- ./container-fluid -->
@stop

@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script></script>
@stop