@extends('layouts.app')

@section('title')
Pending Pr Approvals
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Pr Approval Pending</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
    <div class="container-fluid">
    <div class="row">

    <div class="col-sm-12">
    <div class="white-box">


    <h3 style="text-align: right;" class="box-title m-b-5">
    <span style="float: left;">Purchase Request Approval Pending </span>
    </h3>

    <table id="myTable" style="margin-top:6rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
    <thead>
    <tr role="row">
    <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">Id#</th>

    <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px;">Department</th>

    <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Created By</th>

  <!--   <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 150px;">Current Status</th> -->

    <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 200px;">Action</th>

    </tr>
    </thead>
    <tbody id="pr-appro-tbl-body">

    @if( $purchase_requests->count() > 0 )
    @foreach( $purchase_requests as $list )

    <tr role="row" class="odd">

    <td>PR-{{$list->id }} </td>

    <td>{{ \App\Department::withTrashed()->find($list->department_id)->department_name }}  </td>

    <td>{{ $list->user->name}} </td>

<!--     <td>
    @if($list->status == 0)
    <span style="color:#eab800;">Pending</span>
    @elseif($list->status == 1)
    <span style="color:#ffbd02;">Approvals In Progress</span>
    @elseif($list->status == 2)
    <span style="color:red;">Rejected</span>
    @elseif($list->status == 3)
    <span style="color:#0d6efd;">RFQ</span>
    @elseif($list->status == 4)
    <span style="color:#0d6efd;"><a target="_blank" href="{{ route('request-for-quotations.view' , [$list->id]) }}">RFQ SEND</a></span>
    @elseif($list->status == 5)
    <span style="color:#0d6efd;"><a target="_blank" href="{{ route('comparative-statements.view' , [$list->id]) }}">CS Received</a></span>
    @elseif($list->status == 6)
    <span style="color:#0d6efd;"><a target="_blank" href="{{ route('purchase-orders.view' , [$list->id]) }}">PO Sent</a></span>
    @elseif($list->status == 7)
    @php
    $getPrStatus = \App\PurchaseRequest::getPrStatus($list->id);
    @endphp

    @if( $getPrStatus['pending_po'] > 0)
    <span style="color:#0d6efd;"><a style="font-size: 12px;" target="_blank" href="{{ route('purchase-orders.view' , [$list->id]) }}">PO PENDING</a> <span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{ $getPrStatus['pending_po'] }}</span></span>
    @elseif( $getPrStatus['pending_recipt'] > 0)
    <span style="color:#0d6efd;"><a  style="font-size: 12px;" target="_blank" href="{{ route('purchase-order-receipts.view' , [$list->id]) }}">RECEIPT PENDING</a><span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{$getPrStatus['pending_recipt']}}</span></span>

    @elseif($getPrStatus['total_rfq'] > $getPrStatus['total_cs'])
    <span style="color:#0d6efd;font-size: 12px;"><a target="_blank" href="{{ route('request-for-quotations.view' , [$list->id]) }}">CS PENDING</a><span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{$getPrStatus['total_rfq'] - $getPrStatus['total_cs']}}</span></span>
    @else
    <span style="color:#0ef30e;">Complete</span>
    @endif

    @endif
    </td> -->

    <td>
    <a href="{{ route('purchase-requests.view',[$list->id] ) }}" target="_blank" class="btn btn-warning btn-xs" >view</a>

    <form method="POST" style="display: inline;" action="{{ route('purchase-request-approvals.changeStatus') }}"  id="pr_approval_form_{{$list->id}}">
    {{csrf_field()}}
    <input type="hidden" name="role_id" id="role_id" value="{{$role_id}}">
    <input type="hidden" name="pr_id" id="pr_id" value="{{$list->id}}">
    <button type="submit" name="status" class="btn btn-success btn-xs" value="approve">Approve</button>
    <button type="submit" name="status" onclick="return validate()" class="btn btn-danger btn-xs" value="unapprove">Unapprove</button>
    </form>


    </td>
    </tr>
    @endforeach   
    @endif


    </tbody>
    </table>


    </div>
    </div>
    </div>


    </div>
@stop

@section('js')  

<script src="{{ asset('pusher/pusher.min.js')}}"></script>

<script type="text/javascript">
 // Enable pusher logging - don't include this in production
  Pusher.logToConsole = false;
  var pusher = new Pusher('{{env('PUSHER_APP_KEY')}}' , {
  cluster: '{{env('PUSHER_APP_CLUSTER')}}'
  });
  var channel = pusher.subscribe('approval-channel');
  channel.bind('{{ $role_id }}', function(data) 
    {   
     getPrData()
    
     playSound("{{ url('bell/bell.mp3') }}");
  });   



function getPrData() 
{
  var role_id = '{{ $role_id }}';
  $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('purchase-requests.get-latest-pr-for-approval') }}",
        method:'POST',
        dataType:'json',
        data: {role_id:role_id },
        success:function(data)
        {

            if (data.total > 0) 
            {
                var output = '';


                $.each(data.response, function(key, value) 
                {
                    output += '<tr>';
                    output += '<td>PR-'+value.id+'</td>';
                    output += '<td>'+value.department+'</td>';
                    output += '<td>'+value.created_by+'</td>';
                    output += '<td>'+value.action+'</td>';
                    output += '</tr> ';
                });


            }
            else
            {
               var output = '<tr><td><center>No data found</center></td></tr>';
             }

             $('#pr-appro-tbl-body').html(output)

          }
        })
            

 return false;
}

function playSound(soundFile)         
{               
  var audioElement = document.createElement('audio');   
  audioElement.setAttribute('src', soundFile);   
  audioElement.play(); 
}



    function validate()
    { 
        if(!confirm('Are you sure you want to reject this Pr?'))
        {
            return false;
        } 
    }
</script>

@stop