@extends('layouts.app')

@section('title')
Add Asset Maintainance
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Asset Maintainance</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">

                            @if(Session::has('date_error'))   
                            <div  class="alert alert-danger" role="alert">
                            {{ Session::get('date_error') }}
                            </div>
                            @endif

                        
                            <h3 class="box-title m-b-0">Add Asset Maintainance</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{ route('insert.asset.maintainance') }}">
                            	 {{csrf_field()}}
                                <div class="form-group">
                                
                                <div class="col-md-6">
                                  <label >Asset Maintainance <b style="color:red;">*</b></label>
                                        <select class="form-control chosen-select" name="fixed_assets"> 
                                        
                                        @if($fixed_assets->count() > 0 )

                                        @foreach($fixed_assets as $list)
                                         
                                         <option value="{{$list->id}}">{{$list->name}}</option>

                                        @endforeach

                                        @endif

                                        </select>

                                        @if ($errors->has('fixed_assets'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('fixed_assets') }}</strong>
                                        </span>
                                        @endif

                                </div>



                                <div class="col-md-6">
                                  <label >Type <b style="color:red;">*</b></label>
                                    
                                    <select class="form-control chosen-select" name="type"> 
                                        
                                        <option value="Maintenance">Maintenance</option>
                                        <option value="Repair">Repair</option>
                                        <option value="Upgrade">Upgrade</option>
                                        <option value="Testing">Testing</option>
                                        <option value="Calibration">Calibration</option>
                                        <option value="Software support">Software support</option>
                                        <option value="Hardware support">Hardware support</option>

                                    </select>

                                        @if ($errors->has('fixed_assets'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('fixed_assets') }}</strong>
                                        </span>
                                        @endif

                                </div>



                                <div class="col-md-6" style="margin-top: 1rem;">
                                    
                                    <label >Start <b style="color:red;">*</b></label>
                                        <input type="date" class="form-control"   value="{{date('Y-m-d')}}" name="start_date">

                                        @if ($errors->has('start_date'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('start_date') }}</strong>
                                        </span>
                                        @endif


                                </div>


                                 <div class="col-md-6" style="margin-top: 1rem;">
                                    
                                    <label >End<b style="color:red;">*</b></label>
                                        <input type="date" class="form-control"   value="{{date('Y-m-d')}}" name="end_date">

                                        @if ($errors->has('end_date'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('end_date') }}</strong>
                                        </span>
                                        @endif


                                </div>


                                 <div class="col-md-6" style="margin-top: 1rem;">
                                    
                                    <label >Cost<b style="color:red;">*</b></label>
                                        <input type="number" step="any" placeholder="Enter total cost..." class="form-control" name="cost">

                                        @if ($errors->has('cost'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('cost') }}</strong>
                                        </span>
                                        @endif


                                </div>



                                </div>
                               
                                <div class="form-group">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop 