@extends('layouts.app')

@section('title')
Update Asset Maintainance
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Asset Maintainance</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Update Asset Maintainance</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{ route('update.asset.maintainance') }}">
                            	 {{csrf_field()}}

                                 <input type="hidden" name="id" value="{{$asset_maintainance->id}}">
                                <div class="form-group">
                                
                                <div class="col-md-6">

                                        <label >Asset Maintainance <b style="color:red;">*</b></label>
                                        <select class="form-control chosen-select" name="fixed_assets"> 
                                        
                                        @if($fixed_assets->count() > 0 )

                                        @foreach($fixed_assets as $list)
                                         
                                         <option <?= ($asset_maintainance->asset_id == $list->id) ? 'selected' : '' ?> value="{{$list->id}}">{{$list->name}}</option>

                                        @endforeach

                                        @endif

                                        </select>

                                        @if ($errors->has('fixed_assets'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('fixed_assets') }}</strong>
                                        </span>
                                        @endif

                                </div>



                                <div class="col-md-6">
                                  <label >Type <b style="color:red;">*</b></label>
                                    
                                    <select class="form-control chosen-select" name="type"> 
                                        
                                        <option <?= ($asset_maintainance->type == 'Maintenance') ? 'selected' : '' ?> value="Maintenance">Maintenance</option>
                                        <option <?= ($asset_maintainance->type == 'Repair') ? 'selected' : '' ?> value="Repair">Repair</option>
                                        <option <?= ($asset_maintainance->type == 'Upgrade') ? 'selected' : '' ?> value="Upgrade">Upgrade</option>
                                        <option <?= ($asset_maintainance->type == 'Testing') ? 'selected' : '' ?> value="Testing">Testing</option>
                                        <option <?= ($asset_maintainance->type == 'Calibration') ? 'selected' : '' ?> value="Calibration">Calibration</option>
                                        <option <?= ($asset_maintainance->type == 'Software support') ? 'selected' : '' ?> value="Software support">Software support</option>
                                        <option <?= ($asset_maintainance->type == 'Hardware support') ? 'selected' : '' ?> value="Hardware support">Hardware support</option>

                                    </select>

                                        @if ($errors->has('fixed_assets'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('fixed_assets') }}</strong>
                                        </span>
                                        @endif

                                </div>



                                <div class="col-md-6" style="margin-top: 1rem;">
                                    
                                    <label >Start <b style="color:red;">*</b></label>
                                        <input type="date" class="form-control"   value="{{$asset_maintainance->start_date}}" name="start_date">

                                        @if ($errors->has('start_date'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('start_date') }}</strong>
                                        </span>
                                        @endif


                                </div>


                                 <div class="col-md-6" style="margin-top: 1rem;">
                                    
                                    <label >End<b style="color:red;">*</b></label>
                                        <input type="date" class="form-control"   value="{{$asset_maintainance->end_date}}" name="end_date">

                                        @if ($errors->has('end_date'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('end_date') }}</strong>
                                        </span>
                                        @endif


                                </div>


                                 <div class="col-md-6" style="margin-top: 1rem;">
                                    
                                    <label >Cost<b style="color:red;">*</b></label>
                                        <input type="number" step="any" placeholder="Enter total cost..."  value="{{$asset_maintainance->cost}}" class="form-control" name="cost">

                                        @if ($errors->has('cost'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('cost') }}</strong>
                                        </span>
                                        @endif


                                </div>



                                </div>
                               
                                <div class="form-group">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop 