@extends('layouts.app')

@section('title')
All Asset Maintainance
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
<li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

<li class="active">Asset Maintainance List</li>
</ol>
@stop

@section('content')
  <div class="container-fluid">
    <div class="row">
                    
<div class="col-sm-12">
                        <div class="white-box">

                            @permission('asset-location')
                           
                             <h3 style="text-align: right;" class="box-title m-b-0">
                                <span style="float: left;">Asset Maintainance List</span><a class="btn btn-info btn-sm" href="{{ route('create.asset.maintainance') }}">Add Asset Maintainance</a></h3>

                             @endpermission

                            <div class="table-responsive">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                                <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                    <thead>
                                        <tr role="row">

                                            <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Asset Tag</th>


                                        	<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Asset</th>

                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Maintainance Type</th>
                                          
                                        	<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Start Date</th>

                                            <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">End Date</th>

                                            <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Action</th>


                                        </tr>
                                    </thead>
                                    <tbody>
  
                                    @if( $asset_maintainances->count() > 0 )
                                    @foreach( $asset_maintainances as $list )

                                        <tr role="row" class="odd">

                                            <td>{{$list->asset->asset_tag}}</td>

                                            <td>{{$list->asset->name}}</td>

                                            <td>{{$list->type}}</td>
                                          
                                            <td>{{date('d-F-Y' , strtotime($list->start_date))}}</td>

                                            <td>{{date('d-F-Y' , strtotime($list->end_date))}}</td>

                                             <td>

                                                
                                                <a style="color:red;" onclick="return validate();" href="{{ route('delete.asset.maintainance',[$list->id] ) }}" data-toggle="confirmation" data-title="Are you sure to delete?" ><i class="fa fa-trash-o" aria-hidden="true"></i></a>
                                               

                                                 <a style="margin-left: 1rem;"  href="{{ route('edit.asset.maintainance',[$list->id] ) }}"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>

                                                

                                            </td>

                                        </tr>
                                     @endforeach   
                                     @endif

                                      
                                    </tbody>
                                </table>
                                
                            </div>
                            </div>
                        </div>
                    </div>


    </div>

      </div>
@stop
