@extends('layouts.app')

@section('title')
Add Category 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Categories</li>
      </ol>
@stop

@section('content')

  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Add New Category</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{ route('category.insert') }}">
                            	 {{csrf_field()}}
                                    <div class="form-group">

                                    <div class="col-md-6">
                                    <label >Name</label>
                                    <input type="text" class="form-control" placeholder ="Type Category Name here...." value="{{old('name')}}" name="name">
                                    @if ($errors->has('name'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                                    </span>
                                    @endif

                                    </div>



                                    <div class="col-md-6">
                                    <label >Parent Category</label>
                                    <select class="form-control chosen-select" name="category_type">
                                     <option value="0">None</option>     
                                    @if($categories->count() > 0  )
                                    @foreach($categories as $list)
                                    <option value="{{ $list->id }}">
                                        {{ $list->category_name }}
                                    </option> 
                                    @endforeach
                                    @endif
                                    </select>

                                    @if ($errors->has('category_type'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('category_type') }}</strong>
                                    </span>
                                    @endif
                                    </div>



                                    </div>


                                    <div class="form-group">
                                    <label class="col-md-12">Description</label>
                                    <div class="col-md-12">
                                        <textarea class="form-control" name="description" rows="5" style="width: 610px; height: 110px;"></textarea>
                                    </div>
                                </div>
                                
                               
                                <div class="form-group">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop

