@extends('layouts.app')

@section('title')
Purchase Order Approval Pending
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Purchase Order Approval Pending</li>
      </ol>
@stop

@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop

@section('css')
<style type="text/css">
	.sticky {
  position: fixed;
  top: 0;
}

.sticky + .content {
  padding-top: 102px;
}
</style>
@stop

@section('content')

  
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box" id="printableSection">


								<h3 style="text-align:right;" class="box-title  avoid-this"  style="margin-bottom: 3rem;"> 
								<span style="float: left;"><b style="font-size: 2.2rem;">Approval Pending   CS / </b>PR-{{$purchase_request->id}}</span>

								<a class="btn btn-warning avoid-this" id="print" href="#">Print</a>

								<form method="POST" style="display: inline;" action="{{ route('purchase-order-approvals.change-cs-status') }}"  id="pr_approval_form_{{$purchase_request->id}}">
								{{csrf_field()}}
								<input type="hidden" name="role_id" id="role_id" value="{{$role}}">
								<input type="hidden" name="purchase_request_id" id="purchase_request_id" value="{{$purchase_request->id}}">
								<input type="hidden" name="purchase_order_id" id="purchase_order_id" value="{{$purchase_request->cs_approval_status[0]->purchase_order_id}}">
								<button type="submit" name="status" class="btn btn-success avoid-this" value="approve">Approved</button>
								</form>

								<a class="btn btn-danger avoid-this" id="" href="{{route('purchase-orders.cancel' , [$purchase_request->cs_approval_status[0]->purchase_order_id])}}" onclick="return validate(this)">Cancel</a>

								</h3>
								
							

								<div class="alert alert-warning avoid-this" 
								style="border-radius: .25rem;background: #ffecb5;color: #664d03;" role="alert">
								<b><?= 'PO-'.$po; ?></b> is  Pending For Approval.
								</div>

                               
                                <div class="">  

                                	<center><div class="row hide-default" >
								<h3 class="box-title">{{env('APP_NAME')}}</h3>

								<div class="col-md-12" id="GRN-CNG" style="border: 1px solid;color: black; text-align: center;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;">
								APPROVAL PENDING COMPARATIVE STATEMENT
								</div>

								<div class="alert alert-warning" 
								style="border-radius: .25rem;background: #ffecb5;color: black; border :1px solid black;margin-bottom: 3rem;" role="alert">
								<b><?= 'PO-'.$po; ?></b> is  Pending For Approval.
								</div>


								
							<table style="width: 100%;margin-top: -0.1rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">
							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Project </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Phone </th>

							</tr>
							</thead>
							<tbody>
							<tr role="row" class="odd">
							<td>{{ env('APP_NAME')}}</td>
							<td>{{env('APP_CONTACT')}}</td>
							</tr>
							</tbody>
							</table>



								</div>
								</center>

                           
                                <div class="row avoid-this">
								<div class="col-md-12 col-xs-12">

								<h3 class="box-title"><b style="">Company Details</b></h3>

								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;"  class="font-weight-bold">Company</span>
								<span style="margin-left: 5px;font-weight: 400;" id="project_name" class="blk_clr">
								{{ env('APP_NAME')}}
								</span>
								</div>

								<div class="col-md-3 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;"  class="font-weight-bold">Contact</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{env('APP_CONTACT')}}
								</span>
								</div>


								<div class="col-md-6 col-xs-5 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;"  class="font-weight-bold">Address</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{env('APP_ADDRESS')}}
								</span>
								</div>
								
								</div>

								</div>



								<h3 class="box-title avoid-this" style="margin-top: 5rem;"><b style="">Items Comparison List</b></h3>
								<p class="avoid-this">
							
								</p>
	

                            
								<div id="header" style="width:100%;display: none;">
								<div class="alert alert-success" style="display: none;" role="alert" id="successMessage">
								Purchase Order Create Successfuly.
								</div>

								<div class="alert alert-danger" style="display: none;" role="alert" id="errorMessage"></div>

								<div id="delivery_date">

								<label style="color: white;margin-left: 2rem;margin-bottom: 1rem;margin-top: 2rem;">
								Delivery Date 
								<b style="color: red;">*</b> 
								<span id="delivery_date_error" style="display: none;background: red;padding: 4px 15px 4px 15px;margin-left: 1rem;border-radius: 15px;">Please Select Valid Delivery Date.
								</span>
								</label>

								<input type="date" id="order_delivery_date" style="width: 30%;margin-left: 2rem;" class="form-control" min="{{date('Y-m-d')}}" name="">

								<label style="color: white;margin-left: 2rem;margin-bottom: 1rem;margin-top: 1rem;">
								Select Role For Approval
								<b style="color: red;">*</b> 
								<span id="roles__error" style="display: none;background: red;padding: 4px 15px 4px 15px;margin-left: 1rem;border-radius: 15px;">
								</span>
								</label>
								<br>

								<select class="form-control select2 roles" style="width: 30%;margin-left: 2rem;" multiple="multiple"  name="department" >
								@if($roles->count() > 0  )
								@foreach($roles as $role_lists)
								<option value="{{ $role_lists->id }}">{{ $role_lists->name  }}</option> 
								@endforeach
								@endif
								</select>

								<textarea  placeholder="Write Special Instruction" class="form-control special_ins" rows=5 id="special_ins"></textarea>

								</div>

								@permission('create-purchase-order')
								<button type="button"   onclick="return createPo('{{$purchase_request->id}}' , this)" style="margin-bottom:2rem;margin-top: 2rem;margin-left: 2rem;" class="btn btn-success"  id="po_btn">Make PO</button>
								@endpermission

								<button type="button" style="margin-bottom:2rem;margin-top: 2rem;margin-left: 2rem;display:none;" class="btn btn-success"  id="register_vendor_btn" data-toggle="modal" data-target="#rfqModal">Add </button>

								</div>
							

                              @php $total_items = 0; $amount = 0;  $quantity = 0; @endphp
								@foreach( $purchase_request->item_purchase_requests as $list )

							<div class="cs-section" >

							<table id="myTable" class="table table-striped dataTable no-footer table-bordered" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">


							<th  class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Code</th>

							<th  class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Item - Brand</th>

							<th  class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Detail</th>

							<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Demand Qty</th>

							<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Order Qty</th>

							<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Remain Qty</th>

							<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> Price</th>

							<th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 80px;"> CS Recv</th>

							</tr>

							</thead>
							<tbody>
                             @php 
							$item = \App\Item::withTrashed()->find($list->item_id); 
							@endphp

							<tr role="row" class="odd"  >

							<td>{{$item->item_code}} </td>

							<td>{{$item->item_name}} - {{$item->brand}}  </td>

							<td class="description"> 
							<span class="default-text">{{$item->description}}</span>
							<span class="after-load-more" style="display:none;"></span>
							</td>

							<td>{{number_format($list->quantity , 2)}} </td>

							<td>{{number_format($list->quantity - $list->remaining_quantity , 2)}} </td>

							<td>{{number_format($list->remaining_quantity , 2)}} </td>

							<td>{{number_format($list->price , 2)}} </td>

							<td style="text-align:center;"> 
							@php
							$count = 0;
							$table_content = '';
							foreach($purchase_request->comparative_statements as $cs)

							if($list->item_id == $cs->item_id)
							{

							$po = \App\PurchaseOrder::getStatusOfVendorPo($purchase_request->id,$cs->vendor_id,$cs->item_id);

							$count++;
							if($po[0] > 0)
							{
							  $table_content .= '<tr style="background: #badbcc;">';
							}
							else
							{
							  $table_content .= '<tr>';
							}
							
							$table_content .= '<td>'.Ucfirst(\App\PurchaseRequestVendor::find($cs->vendor_id)->name).'</td> 
							<td>'.number_format($cs->price , 2).'</td>
							<td>'.$cs->message.'</td>
							<td>'.date("d-F-Y" , strtotime($cs->created_at)).'</td>
							<td>'.$po[1].'</td>
							<tr>';
							}

							if($count > 0)
							{
							  $string = '<b >[ '. $count .' ]</b> '  ;
							}
							else
							{
								 $string = 'No Cs Receive yet';
							}
                             
							echo $string;

							@endphp
							</td>

							</tr>

							@php

							$total_items ++;
							$amount += ( $list->price * $list->quantity ); 
							$quantity += $list->quantity;

							@endphp

							</tbody>
							</table>

							@if($count > 0)
							
							<center><h3>Vendor Statements</h3></center>

							<table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" id="editable-datatable" style="cursor: pointer;" role="grid" aria-describedby="editable-datatable_info">
							<thead>
							<tr role="row">

						

							<th  class="sorting" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1" aria-label="Platform(s): activate to sort column ascending" style="width: 157px;">Vendor</th>

							<th  class="sorting" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1" aria-label="Engine version: activate to sort column ascending" style="width: 86px;">Price</th>

							<th  class="sorting" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1" aria-label="CSS grade: activate to sort column ascending" style="width: 211px;">Message</th>


							<th class="sorting" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1" aria-label="CSS grade: activate to sort column ascending" style="width: 111px;"> Date</th>

							<th  class="sorting" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1" aria-label="CSS grade: activate to sort column ascending" style="width: 111px;"> Order Quantity</th>

							</tr>
							</thead>
							<tbody>
							<tr>
								@php echo  $table_content; @endphp
							</tr>
							
							</tbody>

							</table>

						   
							@endif
							</div >
						  @endforeach 

                        <center>
						<div class="row hide-default">

						<div class="col-md-12" style="border: 1px solid;color: black; text-align: center;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;margin-top: -1rem;">
							Authorized By
						</div>
								
						<table style="width: 100%;margin-top: -0.1rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
						<thead>
						<tr role="row">
						<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Position </th>

						<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Name </th>

						<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Date </th>

						<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Signature </th>

						</tr>
						</thead>
						<tbody>
						<tr role="row" class="odd">
							<th>Purchase Officer Name And Signature</th>
						<td>{{ Ucfirst( $purchase_request->cs_purchase_officer )}} </td>
						<td>@if($purchase_request->cs_purchase_officer_date){{ date('d-F-Y' , strtotime( $purchase_request->cs_purchase_officer_date) )}} @else {{'.'}} @endif</td>
						<td></td>
						</tr>

						<tr role="row" class="odd">
							<th>Purchase Manager Name And Signature</th>
						<td>{{ Ucfirst( $purchase_request->cs_purchase_manager )}}</td>
						<td>@if($purchase_request->cs_purchase_manager_date){{ date('d-F-Y' , strtotime( $purchase_request->cs_purchase_manager_date) )}} @else {{'.'}} @endif</td>
						<td></td>
						</tr>

						</tbody>
						</table>
						</div>
						</center>

						<div style="float-left:right;color:black !important; " class="hide-default">
							<b>Date : </b> {{date('d-F-Y')}}
							<br>
							<b >Print By : </b>{{ Ucfirst(Auth::user()->name) }}
							</div>


								<div class="row avoid-this">
                                <div class="col-md-6 col-xs-6">

								<form method="post" onsubmit="return add_cs_officers('{{$purchase_request->id}}' , this , 'officers')">

								<span style="letter-spacing: -0.5px;font-weight: bold;margin-right: 1rem;">Purchase Officer Name And Signature </span>

								<input readonly="readonly" type="text" id="officer_name" style="border: none;border-bottom: 1px solid black;" value="{{$purchase_request->cs_purchase_officer}}" name="" class="sign">

								<!-- <button type="submit" style="background: transparent;border: none;" type="button" class="avoid-this"><i class="fa fa-pencil-square"  style="color: #d4af37;" aria-hidden="true"></i></button> -->
								</form>

								<br>

								<form method="post" onsubmit="return add_cs_officers('{{$purchase_request->id}}' , this , 'manager')">
								<span style="letter-spacing: -0.5px;font-weight: bold;margin-right: 1rem;">Purchase Manager </span>

								<input readonly="readonly" type="text" id="manager_name" style="border: none;border-bottom: 1px solid black;" value="{{$purchase_request->cs_purchase_manager}}" class="sign">

								<!-- <button type="submit" class="avoid-this" style="background: transparent;border: none;" type="button"><i class="fa fa-pencil-square"  style="color: #d4af37;" aria-hidden="true"></i></button> -->

								</form>
                                	
                                </div>

								<div class="col-md-6 col-xs-6" style="text-align: right;">
								<div class="pricing-section">
								<p>
								<b style="color:black;" class="us-text">Total Item:</b> <span style="margin-left: 10rem;"> {{number_format($total_items, 2)}}</span>
								</p>

								<p>
								<b style="color:black;" class="us-text">Total Items Quantity:</b> <span style="margin-left: 9.5rem;"> {{number_format($quantity, 2)}}</span>
								</p>

                                <p>
								<b style="color:black;" class="us-text">Total Amount:</b> 
								<span style="margin-left: 3rem"> 
								PKR {{number_format($amount , 2) }}
								</span>
								</p>
							
								
								</div>
							</div>
						</div>




								</div>

								</div>
								</div>
								</div>
								</div>
								</div>
<!--------------------Register Vendor Modal-------------------------->

	<div class="modal fade" id="rfqModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
							<div class="modal-dialog modal-lg" role="document">
							<div class="modal-content">
							<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							<h4 class="modal-title" id="exampleModalLabel1">REGISTER VENDOR</h4></div>
							<div class="modal-body">
							<div class="alert alert-success" role="alert" style="display: none;" id="succeessMessage">
							Your request for quotation send successfully to vendors.
							</div>

							<div class="alert alert-danger" role="alert" style="display: none;" id="quantity_error">
							
							</div>


							<form method="post" onsubmit="return registerNewVendorAndSendRfq('{{$purchase_request->id}}' , this)">

                            <div class="row">
							<div class="col-md-6">
							<div class="form-group">
							<label for="recipient-name" class="control-label">Name 
							<b style="color:red;">*</b>
						    </label>
							<span id="name_error" style="color:red; display: none;"></span>
							<input type="text"  class="form-control" id="name">
						    </div>
							</div>



							<div class="col-md-6">
							<div class="form-group">
							<label for="recipient-name" class="control-label">Phone 
							<b style="color:red;">*</b></label>
							<span id="contact_error" style="color:red; display: none;"></span>
							<input type="text"  class="form-control" id="contact">
						    </div>
							</div>


							<div class="col-md-6">
							<div class="form-group">
							<label for="recipient-name" class="control-label">Email
							<b style="color:red;">*</b></label>
							<span id="email_error" style="color:red; display: none;"></span>
							<input type="text"  class="form-control" id="email">
						    </div>
							</div>


							<div class="col-md-6">
							<div class="form-group">
							<label for="recipient-name" class="control-label">Cnic
							<b style="color:red;">*</b></label>
							<span id="cnic_error" style="color:red; display: none;"></span>
							<input type="text"  class="form-control" id="cnic">
						    </div>
							</div>


							<div class="col-md-12">
							<div class="form-group">
							<label for="message-text" class="control-label">
							Address: (Optional)</label>
							<textarea class="form-control" rows="3" id="address"></textarea>
							</div>
							</div>


							<div class="col-md-12">

							<center>  <h3 style="background: rgb(2 131 204);padding: 1rem;color: white;">Quotation Information</h3></center>

							</div>


							<div class="col-md-12" style="margin-top:1rem;">
							<div class="form-group">
							<label for="recipient-name" class="control-label">Quatation Valid Date
							<b style="color:red;">*</b></label>
							<span id="quotation_date_error" style="color:red; display: none;"></span>
							<input type="date"  min="{{date('Y-m-d')}}" class="form-control" id="quotation_valid_date">
							</div>
							</div>



							<div class="col-md-12">
							<div class="form-group">
							<label for="message-text" class="control-label">
							Message</label>
							<textarea class="form-control" rows="3" id="message"></textarea>
							</div>
							</div>


					        </div>
							</div>


							<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button type="submit" class="btn btn-primary" id="thisBtn" >Save & Send Rfq</button>
							</form>
							</div>
							</div>
							</div>

@stop





@section('js')  

<script type="text/javascript">

	$(document).ready(function() {

$('.odd').each(function()
{
var description = $(this).find('.description .default-text').text();
// var word = description.split(" ");
if(description.length > 2 )
{
$(this).find('.after-load-more').html(description);
var content =   description.slice(0 , 2)+'... <a href="javascript:void(0)" onclick="return showContent(this)">load more</a>'
$(this).find('.description .default-text').html(content);
}

});

});
function showContent(self) {
$(self).closest('.description').find('.after-load-more').show();
$(self).closest('.description').find('.default-text').hide();
}

function validate(self) {
$(self).prop('disabled' ,true);
if (confirm('Are you sure about cancel this PO?')) 
{
    return true;
}
        return false;
        
    }

function add_cs_officers(purchase_request_id , self , status) {

var manager_name = $('#manager_name').val();
var officer_name = $('#officer_name').val();

$.ajaxSetup({
headers: {
'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}
});

$.ajax({
url:"{{ route('purchase-orders.add_cs_officers') }}",
method:'POST',
dataType:'json',
data: {purchase_request_id:purchase_request_id,status:status,manager_name:manager_name , officer_name:officer_name},
success:function(data)
{
 if(data.response == 'invalid')
 {
     alert(data.message)

 }
 else if(data.response == 'yes')
 {
	alert('Successfully Added.')
	location.reload(true)
 }
 else
 {
  	alert('Something went wrong.')
  	location.reload(true)
 }
}
})

return false;
}

$('document').ready(function(){
    $('[data-toggle=tooltip]').tooltip();
});
window.onscroll = function() {myFunction()};

var btn_stick = document.getElementById("header");
var sticky = btn_stick.offsetTop;

function myFunction() {
  if (window.pageYOffset > sticky) {
    btn_stick.classList.add("sticky");
    btn_stick.style.backgroundColor = '#0283cc';
  } else {
    btn_stick.classList.remove("sticky");
    btn_stick.style.backgroundColor = 'white';
  }
}

function createPo(purchase_request_id , self)
{
$(self).html('Processing...');
$(self).prop('disabled' , true);

var items = [];
var delivery_date = $('#order_delivery_date').val();
var special_ins = $('#special_ins').val();
var roles = [];

$('input[name="items[]"]:checked').each(function()
	{
	items.push({'item_id':$(this).val(),'item_quantity': $(this).closest('tr').find('#item_quantity').val() , 'item_vendor' : $(this).closest('tr').find('#vendor_id').val()});
	});

$('.roles option:selected').each(function()
	{
	roles.push($(this).val());
	});

$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders.create') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:purchase_request_id ,items:items , delivery_date:delivery_date ,special_ins:special_ins , roles:roles},
		success:function(data)
		{
         
     if(data.quantity)
     {
     	  $('#errorMessage').html(data.quantity);
     		$('#errorMessage').show();
     		$(self).html('Make PO');
        $(self).prop('disabled' , false);
     		setTimeout(function(){ 	$('#errorMessage').hide(); }, 3000);
     }
     if(data.delivery_date_error)
     {
     		$('#delivery_date_error').show();
     		$(self).html('Make PO');
        $(self).prop('disabled' , false);
     		setTimeout(function(){ 	$('#delivery_date_error').hide(); }, 3000);
     }

      if(data.roles_error)
     {
     	    $('#roles__error').html(data.roles_error);
     		$('#roles__error').show();
     		$(self).html('Make PO');
            $(self).prop('disabled' , false);
     		setTimeout(function(){ 	$('#roles__error').hide(); }, 3000);
     }


     if(data.response)
     {
     		$('#successMessage').show();
     		setTimeout(function(){ location.reload(true) }, 3000);
     }

		}
		})



	return false;
}

	function registerNewVendorAndSendRfq(purchase_request_id , self) {

	var item_ids = [];
	var item_qty = [];
	var name = $('#name').val();
	var email = $('#email').val();
	var contact = $('#contact').val();
	var cnic = $('#cnic').val();
	var address = $('#address').val();
	var project_name = $('#project_name').text();
	var quotation_valid_date  =  $('#quotation_valid_date').val();
	var message  =  $('#message').val();
     
     $('#thisBtn').html('Processing...')
     $('#thisBtn').prop('disabled' , true)

	$('input[name="item_for_new_vendor[]"]:checked').each(function()
	{
	  item_ids.push($(this).val());
	  item_qty.push($(this).closest('#parent').find('#qty').val());
	});



	$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders.register-vendor') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:purchase_request_id ,item_ids:item_ids , name:name , email:email , contact:contact , cnic:cnic , item_qty:item_qty ,address:address , project_name:project_name , quotation_valid_date:quotation_valid_date , message:message },
		success:function(data)
		{
           if(data.name)
           {
           	var message = data.name;
           	var div_id = '#name_error';
           	error_messages(message , div_id)
           }

           if(data.email)
           {
			var message = data.email;
           	var div_id = '#email_error';
           	error_messages(message , div_id)
           }

           if(data.contact)
           {
			var message = data.contact;
           	var div_id = '#contact_error';
           	error_messages(message , div_id)
           }

           if(data.cnic)
           {
			var message = data.cnic;
           	var div_id = '#cnic_error';
           	error_messages(message , div_id)
           }

           if(data.quotation_valid_date)
           {
			var message = data.quotation_valid_date;
           	var div_id = '#quotation_date_error';
           	error_messages(message , div_id)
           }

          if(data.quantity)
           {
			var message = data.quantity;
           	var div_id = '#quantity_error';

           	error_messages(message , div_id)
           	setTimeout(function(){ $('#rfqModal').modal('hide');}, 4000);
           }

           if(data.response)
           {
			    $('#succeessMessage').html(data.response);
		        $('#succeessMessage').show(); 
		        setTimeout(function(){ location.reload(true)}, 3000);       	
           }
   
		}
		})

	return false;
	}

	function error_messages(message , div_id) {
		$(div_id).html(message);
		$(div_id).show();
		setTimeout(function(){ $(div_id).hide(); }, 5000);
		$('#thisBtn').html('Save & Send Rfq')
		$('#thisBtn').prop('disabled' , false)
	}

	function addItems() 
	{
	  var checkedNum = $('input[name="items[]"]:checked').length;

		if (!checkedNum) 
		{
		  $('#header').hide();
		}
		else
		{
		  $('#header').show();

		}
	}



	function item_for_new_vendor(self) 
	{
	  var item_for_new_vendor = $('input[name="item_for_new_vendor[]"]:checked').length;

		if (!item_for_new_vendor) 
		{
		  $('#header').hide();
		  $('#po_btn').show();
		  $('#delivery_date').show();
		  $('#register_vendor_btn').hide();
		  $(self).closest('#parent').find('#qty').hide()
		}
		else
		{
			$('#header').show();
			$('#register_vendor_btn').show();
			$('#po_btn').hide();
			$(self).closest('#parent').find('#qty').show()
			$('#delivery_date').hide();
			
		}
	}



</script>
@stop