@extends('layouts.app')

@section('title')
Comparative Statements
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Comparative Statements</li>
      </ol>
@stop

@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">

 <style type="text/css">
	.sticky {
  position: fixed;
  top: 0;
}

.sticky + .content {
  padding-top: 102px;
}

.chosen-container.chosen-container-multi
{
	width: 30% !important;
	margin-left: 2rem !important;
}
</style>

@stop


@section('content')

  
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box" id="printableSection">


								<h3 style="text-align:right;" class="box-title avoid-this" style="margin-bottom: 3rem;"> 
								<span style="float: left;"><b style="font-size: 2.2rem;">Comparative Statement / </b>PR-{{$purchase_request->id}}</span>

								<a class="btn btn-warning avoid-this" id="print" href="#">Print</a>
								</h3>
								
								@if($pending_approvals->count() > 0 )
								<div class="alert alert-warning avoid-this" 
								style="border-radius: .25rem;background: #ffecb5;color: #664d03;" role="alert">
								@php
								$total_pending_po = '';
								$count = 1;
								foreach($pending_approvals as $po)
								{
								$total_pending_po .= 'Po-'.$po->id;
								if($count != sizeof($pending_approvals))
								{
								$total_pending_po .= ', ';
								}
								$count ++;
								}
								@endphp
								<b><?= $total_pending_po; ?></b> is  Pending For Approval.
								</div>
								@endif
                               
                                <div class="">  





<div class="row hide-default">
					<div class="col-md-12">
						<h3 class="box-title" style="margin-bottom: 1rem;">
							<span class="float-left" style="border: 1px solid black; padding: 5px 10px;">
								<b class="font-size">{{env('APP_NAME')}}</b>
							</span>
						</h3>
						<br>
						<h3 class="box-title text-center" style="margin-bottom: 1rem;">
							<span>
								<b class="font-size">COMPARATIVE STATEMENT</b>
							</span>
						</h3> 
					</div>
				</div>
				
				<div class="row hide-default">
					<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td>DEPARTMENT:</td>
									<td>{{$purchase_request->department->department_name}}</td>
								</tr>
								<tr>
									<td>PROJECT:</td>
									<td>{{env('APP_NAME')}}</td>
								</tr>
								<tr>
									<td>CONTRACTOR:</td>
									<td>&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="col-lg-offset-1 col-lg-3 col-md-offset-1 col-md-3 col-sm-offset-1 col-sm-3 col-xs-offset-1 col-xs-3">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td>DEMAND NO:</td>
									<td>PR-{{$purchase_request->id}}</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="col-lg-offset-1 col-lg-3 col-md-offset-1 col-md-3 col-sm-offset-1 col-sm-3 col-xs-offset-1 col-xs-3">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td>No:</td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td>Date:</td>
									<td>{{date('d-F-Y')}}</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>

				<div class="row hide-default">
					<div class="col-md-12">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
			@php
			$total_quantity = 0;
			@endphp

				@foreach( $purchase_request->item_purchase_requests as $list )

				@php 
				$item = \App\Item::withTrashed()->find($list->item_id); 
				$output_vendor = array();
				@endphp


                   @if ($loop->first)

						@php
						$vendor_name = '';
						$td_counter = 0;
					

						$vendor_name .= '<tr><td rowspan="2" colspan="3" style="border-top: none;">&nbsp;</td><td><strong>SUPPLIERS NAME</strong></td>';

						foreach($purchase_request->comparative_statements as $cs)
						{
							if(!in_array($cs->vendor_id,$output_vendor ))
							{
								$output_vendor[] = $cs->vendor_id;
								$vendor_name .= '<td colspan="2"><center><strong>'.Ucfirst(\App\PurchaseRequestVendor::find($cs->vendor_id)->name).'</strong></center></td>';
								$td_counter++;
							}

					    }

						$vendor_name .=  '<tr>';

						echo $vendor_name;

						@endphp

							<tr>
								<td  colspan="3" style="border-top: none;">&nbsp;</td>
								<td><strong>QUOT REF.</strong></td>
								<?php
									for ($i=0; $i < $td_counter; $i++) 
									{ 
									?>
									<td colspan="2"><center><strong></strong></center></td>
									<?php
									}
								?>
							</tr>


								<tr>	
									<td><strong>S. No.</strong></td>
									<td><center><strong>DESCRIPTION</strong></center></td>
									<td><center><strong>UNIT</strong></center></td>
									<td><center><strong>QUANTITY</strong></center></td>

									<?php
									for ($i=0; $i < $td_counter; $i++) 
									{ 
										?>
											<td><center><strong>RATE</strong></center></td>
											<td><strong>Amount (Rs.)</strong></td>
										<?php
									}
								?>

								</tr>

								
                         @endif


								<tr>	

									<td><strong>
										{{$item->item_code}}
									</strong></td>

									<td><center><strong>
									{{$item->item_name}} - {{$item->manufacture->name}}
									<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
									</strong></center></td>

									<td><center><strong>
										{{$item->unit}}
									</strong></center></td>

									<td>
										<center>
											<strong>
										{{number_format($list->quantity , 2 ,'.','')}}
										@php
											$total_quantity +=$list->quantity;
										@endphp
									       </strong>
								       </center>
							        </td>

									<?php
									$Array = array();
								if (!empty($purchase_request->comparative_statements)) 
								{
	
									foreach ($purchase_request->comparative_statements as $key => $val) 
									{ 
										if(!in_array($val->vendor_id,$Array ))
										{
											$Array[] = $val->vendor_id;

											$rate = \App\ComparativeStatement::getItemPrices($purchase_request->id , $val->vendor_id , $list->item_id );
											$rate = json_decode(json_encode($rate));

											$price = ($rate->item) ? $rate->item->price : '';
											?>

											<td>
												<center>
													<strong>
														<?= ($price) ? number_format($price, 2 ,'.','') : '' ; ?>
													</strong>
												</center>
											</td>

											<td >
												 <strong class="amount" id="amount_<?= $key; ?>" data-id="<?= $key; ?>" ><?= ($price) ? number_format($price * $list->quantity , 2 ,'.','') : '' ; ?>
												 </strong>
											</td>

											<?php
										}
									}
										
							     }					

									?>

							</tr>

							@endforeach

			<tr>	
				<td><strong>&nbsp;</strong></td>
				<td style="text-align:right;"><strong>TOTAL</strong></td>
				<td><center><strong>&nbsp;</strong></center></td>
				<td><center><strong>{{$total_quantity}}</strong></center></td>

				<?php
					for ($i=0; $i < $td_counter; $i++) 
					{ 
						?>
							<td><center><strong>&nbsp;</strong></center></td>
							<td ><strong class="total_amount" id="total_amount_<?= $i; ?>"  data-id="<?= $i; ?>" ></strong></td>
						<?php
					}
				?>


				
			</tr>



							</tbody>
						</table>
					</div>
				</div>

				<div class="row hide-default">
					<div class="col-md-12">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td width="40%"><strong>TERMS & CONDITIONS:<br><br><br><br><br><br><br></strong></td>
									<td colspan="3">&nbsp;</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>

				<div class="row hide-default">
					<div class="col-md-12">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td rowspan="4" width="15%">Recommendation:</td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td>&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>

				<div class="row hide-default">
					<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td colspan="2"><br><br></td>
								</tr>
								<tr>
									<td colspan="2"><center><strong>PREPARED BY</strong></center></td>
								</tr>
								<tr>
									<td width="50%">Name;</td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td width="50%">Designation;</td>
									<td>&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td colspan="2"><br><br></td>
								</tr>
								<tr>
									<td colspan="2"><center><strong>VERIFIED BY</strong></center></td>
								</tr>
								<tr>
									<td width="50%">Name;</td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td width="50%">Designation;</td>
									<td>&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td><br><br></td>
								</tr>
								<tr>
									<td style="padding-top: 3.5rem; padding-bottom: 3.5rem;"><center><strong >APPROVED BY</strong></center></td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>


                           
                                <div class="row avoid-this">
								<div class="col-md-12 col-xs-12">

								<h3 class="box-title"><b style="">Company Details</b></h3>

								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;"  class="font-weight-bold">Company</span>
								<span style="margin-left: 5px;font-weight: 400;" id="project_name" class="blk_clr">
								{{ env('APP_NAME')}}
								</span>
								</div>

								<div class="col-md-3 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;"  class="font-weight-bold">Contact</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{env('APP_CONTACT')}}
								</span>
								</div>


								<div class="col-md-6 col-xs-5 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;"  class="font-weight-bold">Address</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{env('APP_ADDRESS')}}
								</span>
								</div>
								
								</div>

								</div>



								<h3 class="box-title avoid-this" style="margin-top: 5rem;"><b style="">Items Comparison List</b></h3>
								<p class="avoid-this">
								<b>Info :</b> <span>If You want to register new vendor and send rfq then go to bottom of specific item section.</span>
								</p>
	

                            
								<div id="header" class="avoid-this" style="width:100%;display: none;">
								<div class="alert alert-success" style="display: none;" role="alert" id="successMessage">
								Purchase Order Create Successfuly.
								</div>

								<div class="alert alert-danger" style="display: none;" role="alert" id="errorMessage"></div>

								<div id="delivery_date">

								<label style="color: white;margin-left: 2rem;margin-bottom: 1rem;margin-top: 2rem;">
								Delivery Date 
								<b style="color: red;">*</b> 
								<span id="delivery_date_error" style="display: none;background: red;padding: 4px 15px 4px 15px;margin-left: 1rem;border-radius: 15px;">Please Select Valid Delivery Date.
								</span>
								</label>

								<input type="date" id="order_delivery_date" style="width: 30%;margin-left: 2rem;" class="form-control" min="{{date('Y-m-d')}}" name="">

								<label style="color: white;margin-left: 2rem;margin-bottom: 1rem;margin-top: 1rem;">
								Select Role For Approval
								<b style="color: red;">*</b> 
								<span id="roles__error" style="display: none;background: red;padding: 4px 15px 4px 15px;margin-left: 1rem;border-radius: 15px;">
								</span>
								</label>
								<br>

								<select class="form-control chosen-select roles" style="width: 30%;margin-left: 2rem;" multiple="multiple"  name="department" >
								@if($roles->count() > 0  )
								@foreach($roles as $role_lists)
								<option value="{{ $role_lists->id }}">{{ $role_lists->name  }}</option> 
								@endforeach
								@endif
								</select>

								<textarea  placeholder="Write Special Instruction" class="form-control special_ins" rows=5 id="special_ins"></textarea>

								</div>

								@permission('create-purchase-order')
								<button type="button"   onclick="return createPo('addAdvancePayment', '{{$purchase_request->id}}' , this)" style="margin-bottom:2rem;margin-top: 2rem;margin-left: 2rem;" class="btn btn-success po_btn"  id="po_btn">Make PO</button>
								@endpermission

								<button type="button" style="margin-bottom:2rem;margin-top: 2rem;margin-left: 2rem;display:none;" class="btn btn-success"  id="register_vendor_btn" data-toggle="modal" data-target="#rfqModal">Add </button>

								</div>
							

                              @php $total_items = 0; $amount = 0;  $quantity = 0; @endphp
								@foreach( $purchase_request->item_purchase_requests as $list )

							<div class="cs-section avoid-this" >

							<table id="myTable" class="table table-striped dataTable no-footer table-bordered avoid-this" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">


							<th  class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Code</th>

							<th  class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Item - Brand</th>

							<th  class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Detail</th>

							<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Demand Qty</th>

							<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Order Qty</th>

							<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Remain Qty</th>

							<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> Price</th>

							<th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 80px;"> CS Recv</th>

							</tr>

							</thead>
							<tbody>
                             @php 
							$item = \App\Item::withTrashed()->find($list->item_id); 
							@endphp

							<tr role="row" class="odd"  >

							<td>{{$item->item_code}} </td>

							<td class="item_name">
							{{$item->item_name}} - {{$item->manufacture->name}}
							<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
							</td>

							<td class="description"> 
							<span class="default-text">{{$list->description}}</span>
							<span class="after-load-more" style="display:none;"></span>
							</td>

							<td>{{number_format($list->quantity , 2)}} </td>

							<td>{{number_format($list->quantity - $list->remaining_quantity , 2)}} </td>

							<td>{{number_format($list->remaining_quantity , 2)}} </td>

							<td>{{number_format($list->price , 2)}} </td>

							<td style="text-align:center;"> 
							@php
							$count = 0;
							$table_content = '';
							foreach($purchase_request->comparative_statements as $cs)

							if($list->item_id == $cs->item_id)
							{
							  $count++;
					
							  $table_content .= '<tr>

							    <td class="avoid-this">';

		                         if($total_cs == $total_rfq || (strtotime(date("Y-m-d")) > strtotime(date("Y-m-d" , strtotime($purchase_request->quotation_valid_date)))  ))
						    	{
						    	 $table_content .='<input type="checkbox" value="'.$list->item_id.'" name="items[]" onchange="return addItems()" >';
						    	}
						    	else
						    	{
									$table_content .='<span class="d-inline-block"  data-toggle="tooltip" title="Some of the cs not yet receive. once all cs receive you will be able to make purchase order." title="Pending" data-placement="bottom">
									<input type="checkbox" disabled  >
									</span>';
						    	}
							    	
							    $table_content .='</td>

							    <td>'.Ucfirst(\App\PurchaseRequestVendor::find($cs->vendor_id)->name).'</td> 
								<td>'.number_format($cs->price , 2).'</td>
								<td>'.$cs->message.'</td>
								<td>'.date("d-F-Y" , strtotime($cs->created_at)).'</td>
								<td><input type="number" style="border: none;" placeholder="Enter Quantity" id="item_quantity" >
                                <input type="hidden" value="'.$cs->vendor_id.'" id="vendor_id">
								</td>
								<tr>';
							}

							if($count > 0)
							{
							  $string = '<b >[ '. $count .' ]</b> '  ;
							}
							else
							{
								 $string = 'No Cs Receive yet';
							}
                             
							echo $string;

							@endphp
							</td>

							</tr>

							@php

							$total_items ++;
							$amount += ( $list->price * $list->quantity ); 
							$quantity += $list->quantity;

							@endphp

							</tbody>
							</table>

							@if($count > 0)
							
							<center ><h3 class="avoid-this">Vendor Statements</h3></center>

							<table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table avoid-this" id="editable-datatable" style="cursor: pointer;" role="grid" aria-describedby="editable-datatable_info">
							<thead>
							<tr role="row">

							<th  class="avoid-this" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1"  style="width: 36px;">Select </th>

							<th  class="sorting" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1" aria-label="Platform(s): activate to sort column ascending" style="width: 157px;">Vendor</th>

							<th  class="sorting" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1" aria-label="Engine version: activate to sort column ascending" style="width: 86px;">Price</th>

							<th  class="sorting" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1" aria-label="CSS grade: activate to sort column ascending" style="width: 211px;">Message</th>



							<th class="sorting" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1" aria-label="CSS grade: activate to sort column ascending" style="width: 111px;"> Date</th>

							<th  class="sorting" tabindex="0" aria-controls="editable-datatable" rowspan="1" colspan="1" aria-label="CSS grade: activate to sort column ascending" style="width: 111px;"> Order Quantity</th>

							</tr>
							</thead>
							<tbody>
							<tr>
								@php echo  $table_content; @endphp
							</tr>
							
							</tbody>

							</table>




						    <div id="parent" class="avoid-this">
							<label style="margin-right: 10px;">Register New Vendor</label>

							@if($total_cs == $total_rfq || (strtotime(date("Y-m-d")) > strtotime(date("Y-m-d" , strtotime($purchase_request->quotation_valid_date)))  ))
							
							<input type="checkbox"  name="item_for_new_vendor[]" value="{{$list->item_id}}" onchange="return item_for_new_vendor(this)" style="position: relative;top: 2px;">
							
							@else

							<span class="d-inline-block"  data-toggle="tooltip" title="Some of the cs not yet receive. once all cs receive you will be able to make purchase order." title="Pending" data-placement="bottom">
							<input type="checkbox" disabled  >
							</span>

							@endif
						
                            <br>
							<input type="number" placeholder="Item Quantity"  style="width: 18%; display: none;" class="form-control item_qty" id="qty">
						    </div>
							@endif
							</div >
								 @endforeach 

					
							

								<div class="row avoid-this">
                                <div class="col-md-6 col-xs-6">


								<br>

                                	
                                </div>

								<div class="col-md-6 col-xs-6" style="text-align: right;">
								<div class="pricing-section">
								<p>
								<b style="color:black;" class="us-text">Total Item:</b> <span style="margin-left: 10rem;"> {{number_format($total_items, 2)}}</span>
								</p>

								<p>
								<b style="color:black;" class="us-text">Total Items Quantity:</b> <span style="margin-left: 9.5rem;"> {{number_format($quantity, 2)}}</span>
								</p>

                                <p>
								<b style="color:black;" class="us-text">Total Amount:</b> 
								<span style="margin-left: 3rem"> 
								PKR {{number_format($amount , 2) }}
								</span>
								</p>
							
								
								</div>
							</div>
						</div>




								</div>

								</div>
								</div>
								</div>
								</div>
								</div>



<!-- Modal -->
<div class="modal fade" id="advanceModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Advance Payments</h4>
      </div>
      <div class="modal-body">
       <table class="table table-striped">
  <thead>
    <tr>
      <th scope="col">Id#</th>
      <th scope="col">Vendor</th>
      <th scope="col">Total</th>
      <th scope="col">Advance (%)</th>
    </tr>
  </thead>
  <tbody id="vendor_advances">
    
  </tbody>
</table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      

		@permission('create-purchase-order')
		<button type="button"   onclick="return createPo('confirm', '{{$purchase_request->id}}' , this)"  class="btn btn-success po_btn"  >Confirm</button>
		@endpermission


      </div>
    </div>
  </div>
</div>



<!--------------------Register Vendor Modal-------------------------->

	<div class="modal fade" id="rfqModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
							<div class="modal-dialog modal-lg" role="document">
							<div class="modal-content">
							<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							<h4 class="modal-title" id="exampleModalLabel1">REGISTER VENDOR</h4></div>
							<div class="modal-body">
							<div class="alert alert-success" role="alert" style="display: none;" id="succeessMessage">
							Your request for quotation send successfully to vendors.
							</div>

							<div class="alert alert-danger" role="alert" style="display: none;" id="quantity_error">
							
							</div>


							<form method="post" onsubmit="return registerNewVendorAndSendRfq('{{$purchase_request->id}}' , this)">

                            <div class="row">
							<div class="col-md-6">
							<div class="form-group">
							<label for="recipient-name" class="control-label">Name 
							<b style="color:red;">*</b>
						    </label>
							<span id="name_error" style="color:red; display: none;"></span>
							<input type="text"  class="form-control" id="name">
						    </div>
							</div>



							<div class="col-md-6">
							<div class="form-group">
							<label for="recipient-name" class="control-label">Phone 
							<b style="color:red;">*</b></label>
							<span id="contact_error" style="color:red; display: none;"></span>
							<input type="text"  class="form-control" id="contact">
						    </div>
							</div>


							<div class="col-md-6">
							<div class="form-group">
							<label for="recipient-name" class="control-label">Email
							<b style="color:red;">*</b></label>
							<span id="email_error" style="color:red; display: none;"></span>
							<input type="text"  class="form-control" id="email">
						    </div>
							</div>


							<div class="col-md-6">
							<div class="form-group">
							<label for="recipient-name" class="control-label">Cnic
							<b style="color:red;">*</b></label>
							<span id="cnic_error" style="color:red; display: none;"></span>
							<input type="text"  class="form-control" id="cnic">
						    </div>
							</div>


							<div class="col-md-12">
							<div class="form-group">
							<label for="message-text" class="control-label">
							Address: (Optional)</label>
							<textarea class="form-control" rows="3" id="address"></textarea>
							</div>
							</div>


							<div class="col-md-12">

							<center>  <h3 style="background: rgb(2 131 204);padding: 1rem;color: white;">Quotation Information</h3></center>

							</div>


							<div class="col-md-12" style="margin-top:1rem;">
							<div class="form-group">
							<label for="recipient-name" class="control-label">Quatation Valid Date
							<b style="color:red;">*</b></label>
							<span id="quotation_date_error" style="color:red; display: none;"></span>
							<input type="date"  min="{{date('Y-m-d')}}" class="form-control" id="quotation_valid_date">
							</div>
							</div>



							<div class="col-md-12">
							<div class="form-group">
							<label for="message-text" class="control-label">
							Message</label>
							<textarea class="form-control" rows="3" id="message"></textarea>
							</div>
							</div>


					        </div>
							</div>


							<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button type="submit" class="btn btn-primary" id="thisBtn" >Save & Send Rfq</button>
							</form>
							</div>
							</div>
							</div>

@stop





@section('js')  

<script type="text/javascript">

	$( document ).ready(function() 

	{
		var total = 0;

	$('.amount').each(function()
	{

		if($(this).text() != '')
		{
			if ($(this).data("id") == $('#total_amount_'+$(this).data("id")).data("id")) 
			{
			  var val_1 =  parseFloat($('#total_amount_'+$(this).data("id")).text()) || 0;
			  var val_2 =  parseFloat($(this).text()) || 0;

			  total = val_1 + val_2

              $('#total_amount_'+$(this).data("id")).text(total)
			}
	     
		}

	});

   });


	$(document).ready(function() {

$('.odd').each(function()
{
var description = $(this).find('.description .default-text').text();
// var word = description.split(" ");
if(description.length > 2 )
{
$(this).find('.after-load-more').html(description);
var content =   description.slice(0 , 2)+'... <a href="javascript:void(0)" onclick="return showContent(this)">load more</a>'
$(this).find('.description .default-text').html(content);
}

});

});
function showContent(self) {
$(self).closest('.description').find('.after-load-more').show();
$(self).closest('.description').find('.default-text').hide();
}



function add_cs_officers(purchase_request_id , self , status) {

var manager_name = $('#manager_name').val();
var officer_name = $('#officer_name').val();

$.ajaxSetup({
headers: {
'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}
});

$.ajax({
url:"{{ route('purchase-orders.add_cs_officers') }}",
method:'POST',
dataType:'json',
data: {purchase_request_id:purchase_request_id,status:status,manager_name:manager_name , officer_name:officer_name},
success:function(data)
{
 if(data.response == 'invalid')
 {
     alert(data.message)

 }
 else if(data.response == 'yes')
 {
	alert('Successfully Added.')
	location.reload(true)
 }
 else
 {
  	alert('Something went wrong.')
  	location.reload(true)
 }
}
})

return false;
}

$('document').ready(function(){
    $('[data-toggle=tooltip]').tooltip();
});
window.onscroll = function() {myFunction()};

var btn_stick = document.getElementById("header");
var sticky = btn_stick.offsetTop;

function myFunction() {
  if (window.pageYOffset > sticky) {
    btn_stick.classList.add("sticky");
    btn_stick.style.backgroundColor = '#0283cc';
  } else {
    btn_stick.classList.remove("sticky");
    btn_stick.style.backgroundColor = 'white';
  }
}

function createPo(type , purchase_request_id , self)
{
$(self).html('Processing...');
$(self).prop('disabled' , true);

var items = [];
var delivery_date = $('#order_delivery_date').val();
var special_ins = $('#special_ins').val();
var roles = [];
var vendor_per = [];

$('input[name="items[]"]:checked').each(function()
{
items.push({'item_id':$(this).val(),'item_quantity': $(this).closest('tr').find('#item_quantity').val() , 'item_vendor' : $(this).closest('tr').find('#vendor_id').val()});
});

$('.roles option:selected').each(function()
	{
	roles.push($(this).val());
	});

if (type != 'addAdvancePayment') 
{
	$('.advancePer').each(function()
	{
	vendor_per.push({'vendor_id':$(this).data("vendor-id"),'amount': $(this).data("total-amount") , 'advance_percentage' : $(this).val()});
	});

}

$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders.create') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:purchase_request_id ,items:items , delivery_date:delivery_date ,special_ins:special_ins , roles:roles , type: type, vendor_per:vendor_per},
		success:function(data)
		{
         
     if(data.quantity)
     {
     	  $('#errorMessage').html(data.quantity);
     		$('#errorMessage').show();
     		$(self).html('Make PO');
        $(self).prop('disabled' , false);
     		setTimeout(function(){ 	$('#errorMessage').hide(); }, 3000);
     }
     if(data.delivery_date_error)
     {
     		$('#delivery_date_error').show();
     		$(self).html('Make PO');
        $(self).prop('disabled' , false);
     		setTimeout(function(){ 	$('#delivery_date_error').hide(); }, 3000);
     }

      if(data.roles_error)
     {
     	    $('#roles__error').html(data.roles_error);
     		$('#roles__error').show();
     		$(self).html('Make PO');
            $(self).prop('disabled' , false);
     		setTimeout(function(){ 	$('#roles__error').hide(); }, 3000);
     }

     if (data.response == 'addAdvancePayment') 
     {
			var counter = 1;
			var output = '';

			
			$.each(data.total, function(key, value) {
			output += '<tr>';
			output += '<td>'+counter+++'</td>';
			output += '<td>'+value.vendor+'</td>';
			output += '<td>'+value.amount+'</td>';
			output += '<td><input type="number" value="0" class="advancePer" data-vendor-id="'+value.vendor_id+'" data-total-amount="'+value.amount+'" oninput="this.value = Math.abs(this.value)" style="border:none;" /></td>';
			output += '</tr>';
			});

			$('#vendor_advances').html(output);
			$('#advanceModal').modal({ backdrop: 'static'})
			$(self).html('Make PO');
            $(self).prop('disabled' , false);
     }


     if(data.response == 'yes')
     {

			$('#advanceModal').modal('hide')
     		$('#successMessage').show();
     		setTimeout(function(){ location.reload(true) }, 3000);
     }

		}
		})



	return false;
}

	function registerNewVendorAndSendRfq(purchase_request_id , self) {

	var item_ids = [];
	var item_qty = [];
	var name = $('#name').val();
	var email = $('#email').val();
	var contact = $('#contact').val();
	var cnic = $('#cnic').val();
	var address = $('#address').val();
	var project_name = $('#project_name').text();
	var quotation_valid_date  =  $('#quotation_valid_date').val();
	var message  =  $('#message').val();
     
     $('#thisBtn').html('Processing...')
     $('#thisBtn').prop('disabled' , true)

	$('input[name="item_for_new_vendor[]"]:checked').each(function()
	{
	  item_ids.push($(this).val());
	  item_qty.push($(this).closest('#parent').find('#qty').val());
	});



	$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders.register-vendor') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:purchase_request_id ,item_ids:item_ids , name:name , email:email , contact:contact , cnic:cnic , item_qty:item_qty ,address:address , project_name:project_name , quotation_valid_date:quotation_valid_date , message:message },
		success:function(data)
		{
           if(data.name)
           {
           	var message = data.name;
           	var div_id = '#name_error';
           	error_messages(message , div_id)
           }

           if(data.email)
           {
			var message = data.email;
           	var div_id = '#email_error';
           	error_messages(message , div_id)
           }

           if(data.contact)
           {
			var message = data.contact;
           	var div_id = '#contact_error';
           	error_messages(message , div_id)
           }

           if(data.cnic)
           {
			var message = data.cnic;
           	var div_id = '#cnic_error';
           	error_messages(message , div_id)
           }

           if(data.quotation_valid_date)
           {
			var message = data.quotation_valid_date;
           	var div_id = '#quotation_date_error';
           	error_messages(message , div_id)
           }

          if(data.quantity)
           {
			var message = data.quantity;
           	var div_id = '#quantity_error';

           	error_messages(message , div_id)
           	setTimeout(function(){ $('#rfqModal').modal('hide');}, 4000);
           }

           if(data.response)
           {
			    $('#succeessMessage').html(data.response);
		        $('#succeessMessage').show(); 
		        setTimeout(function(){ location.reload(true)}, 3000);       	
           }
   
		}
		})

	return false;
	}

	function error_messages(message , div_id) {
		$(div_id).html(message);
		$(div_id).show();
		setTimeout(function(){ $(div_id).hide(); }, 5000);
		$('#thisBtn').html('Save & Send Rfq')
		$('#thisBtn').prop('disabled' , false)
	}

	function addItems() 
	{
	  var checkedNum = $('input[name="items[]"]:checked').length;

		if (!checkedNum) 
		{
		  $('#header').hide();
		}
		else
		{
		  $('#header').show();

		}
	}



	function item_for_new_vendor(self) 
	{
	  var item_for_new_vendor = $('input[name="item_for_new_vendor[]"]:checked').length;

		if (!item_for_new_vendor) 
		{
		  $('#header').hide();
		  $('#po_btn').show();
		  $('#delivery_date').show();
		  $('#register_vendor_btn').hide();
		  $(self).closest('#parent').find('#qty').hide()
		}
		else
		{
			$('#header').show();
			$('#register_vendor_btn').show();
			$('#po_btn').hide();
			$(self).closest('#parent').find('#qty').show()
			$('#delivery_date').hide();
			
		}
	}



</script>
@stop