@extends('layouts.app')

@section('title')
All Departments
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Departments</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
            
            <div class="col-md-3">
            <div class="white-box bg-success color-box" style="background-color: #1c3752;">
            <h1 style="font-size: 2rem;" class="text-white font-light m-b-0">Purchase Requests</h1>
            
            <p class="cb-text">Info</p>
            <a href="{{ route('purchase-requests.detail' , ['status' => 'complete' , 'department' => $department_id])}}">
            <h6 class="text-white font-semibold cus_btn_3" style="width: 65%;"><b style="margin-left: 10px;">Complete</b> <span style="margin-left: 2rem;font-weight: bold;color: white;" class="font-light">{{\App\PurchaseRequest::getPrWithStatus('complete' , $department_id)[0] }}</span></h6></a>


            <a href="{{ route('purchase-requests.detail' , ['status' => 'pending' , 'department' => $department_id])}}">
            <h6 class="text-white font-semibold cus_btn_3" style="width: 65%;"><b style="margin-left: 5px;">In Progress</b> <span style="margin-left: 2rem;font-weight: bold;color: white;" class="font-light">{{\App\PurchaseRequest::getPrWithStatus('pending' , $department_id)[0] }}</span></h6></a>


             <a href="{{ route('purchase-requests.detail' , ['status' => 'cancel' , 'department' => $department_id])}}">
            <h6 class="text-white font-semibold cus_btn_3" style="width: 65%;" ><b style="margin-left: 10px;">Cancel</b> <span style="margin-left: 1rem;font-weight: bold;color: white;" class="font-light">{{\App\PurchaseRequest::getPrWithStatus('cancel' , $department_id)[0] }}</span></h6></a>
           
            </div>
            </div>


            <div class="col-md-3">
            <div class="white-box bg-primary color-box">
            <h1 style="font-size: 2rem;" class="text-white font-light m-b-0">RFQ's & CS's</h1>
            
            <p class="cb-text">Info</p>
            <a href="{{ route('request-for-quotations.all' , ['status' => 'rfq-sent'  , 'department' => $department_id]) }}">

             <h6 class="text-white font-semibold cus_btn_2" style="width:65%;"><b style="margin-left: 10px;">Sent Rfq's</b> <span style="margin-left: 2rem;font-weight: bold; color: white;" class="font-light">{{\App\PurchaseRequest::getrfqAndCsCount($department_id)[0] }}</span></h6></a>


            <a href="{{ route('request-for-quotations.all' , ['status' => 'cs-receive'  , 'department' => $department_id]) }}">
            <h6 class="text-white font-semibold cus_btn_2" style="width:65%;"><b style="margin-left: 10px;">Receive  CS </b><span style="margin-left: 2rem;font-weight: bold; color: white;" class="font-light">{{\App\PurchaseRequest::getrfqAndCsCount($department_id)[2] }}</span></h6></a>

            <a href="{{ route('request-for-quotations.all' , ['status' => 'cs-pending'  , 'department' => $department_id]) }}">
            <h6 class="text-white font-semibold cus_btn_2" style="width:65%;"><b style="margin-left: 10px;">Pending CS</b><span style="margin-left: 1rem;font-weight: bold; color: white;" class="font-light">{{\App\PurchaseRequest::getrfqAndCsCount($department_id)[1] }}</span></h6></a>
           
            </div>
            </div>



            <div class="col-md-3">
            <div class="white-box bg-info color-box" style="background-color:#57a56b;">
            <h1 style="font-size: 2rem;" class="text-white font-light m-b-0">Purchase Orders</h1>

            <p class="cb-text">Info</p>
            <a href="{{ route('purchase-orders.lists' , ['status' => 'po-sent' , 'department' => $department_id] ) }}">
            <h6 class="text-white font-semibold cus_btn_3" style="width: 65%;"><b style="margin-left: 10px;">Sent PO</b><span style="margin-left: 2rem;font-weight: bold; color: white;" class="font-light">{{\App\PurchaseRequest::getPoStatus('1' , $department_id) }}</span></h6></a>


            <a href="{{ route('purchase-orders.lists' , ['status' => 'po-receive' , 'department' => $department_id]) }}">

            <h6 class="text-white font-semibold cus_btn_3" style="width: 65%;"><b style="margin-left: 10px;">Received</b> <span style="margin-left: 2rem;font-weight: bold; color: white;" class="font-light">{{\App\PurchaseRequest::getPoStatus('2' , $department_id) }}</span></h6></a>


            <a href="{{ route('purchase-orders.lists' , ['status' => 'po-partial-receive' , 'department' => $department_id] ) }}">

            <h6 class="text-white font-semibold cus_btn_3" style="width: 65%;"><b style="margin-left: 10px;">Partial Recv</b><span style="margin-left: 1rem;font-weight: bold; color: white;" class="font-light">{{\App\PurchaseRequest::getPoStatus('3' , $department_id) }}</span></h6></a>

            </div>
            </div>




            <div class="col-md-3">
            <div class="white-box bg-warning color-box">
            <h1 style="font-size: 2rem;" class="text-white font-light m-b-0">Receipts</h1>

            <p class="cb-text">Info</p>
            <a href="{{ route('purchase-order-receipts.lists' , ['status' => 'paid'  , 'department' => $department_id]) }}"> 
            <h6 class="text-white font-semibold cus_btn" style="width:65%;"><b style="margin-left: 10px;">Paid</b> <span style="margin-left: 2rem;font-weight: bold; color:white;" class="font-light">{{\App\PurchaseRequest::getReceiptStatus('1' , $department_id) }}</span></h6></a>


            <a href="{{ route('purchase-order-receipts.lists' , ['status' => 'unpaid'  , 'department' => $department_id]) }}"> 
            <h6 class="text-white font-semibold cus_btn" style="width:65%"><b style="margin-left: 10px;">Unpaid </b><span style="margin-left: 3rem;font-weight: bold; color:white;" class="font-light">{{\App\PurchaseRequest::getReceiptStatus('0' , $department_id) }}</span></h6></a>

            <a href="{{ route('purchase-order-receipts.lists' , ['status' => 'partial-paid'  , 'department' => $department_id]) }}">

            <h6 class="text-white font-semibold cus_btn" style="width: 65%;"><b style="margin-left: 10px;">Partially Paid</b><span style="margin-left: 1rem;font-weight: bold; color:white;" class="font-light">{{\App\PurchaseRequest::getReceiptStatus('2' , $department_id) }}</span></h6></a>

            </div>
            </div>



              <div class="col-md-4">
                <div class="white-box ecom-stat-widget">
                <div class="row">
                <div class="col-xs-6">
                <span class="text-blue font-light">PKR {{number_format($total_purchase, 2)}} </span>
                <p class="font-12">Total Purchasing</p>
                </div>
                <div class="col-xs-6">
                <span class="icoleaf bg-danger text-white"><i class="mdi mdi-coin"></i></span>
                </div>
                </div>
                </div>
                </div>



                <div class="col-md-4">
                <div class="white-box ecom-stat-widget">
                <div class="row">
                <div class="col-xs-6">
                <span class="text-blue font-light">PKR {{number_format($total_monthly_purchase, 2)}} </span>
                <p class="font-12">{{date('F')}}</p>
                </div>
                <div class="col-xs-6">
                <span class="icoleaf bg-danger text-white"><i class="mdi mdi-coin"></i></span>
                </div>
                </div>
                </div>
                </div>



                <div class="col-md-4">
                <div class="white-box ecom-stat-widget">
                <div class="row">
                <div class="col-xs-6">
                <span class="text-blue font-light">PKR {{number_format($total_pay_purchase , 2)}} </span>
                <p class="font-12">Paid  Amount</p>
                </div>
                <div class="col-xs-6">
                <span class="icoleaf bg-danger text-white"><i class="mdi mdi-coin"></i></span>
                </div>
                </div>
                </div>
                </div>


 <div class="col-sm-12">
                     <div class="white-box">
                <h3 class="box-title" style="margin-bottom: 3rem;"> Purchase Requests For Approval</h3>

                @if(Session::has('success'))   
                <div id="successMessage" class="alert alert-success" role="alert">
                {{ Session::get('success') }}
                </div>
                @endif


                <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                <thead>
                <tr role="row">
                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">Id#</th>

                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 150px;">Project</th>

                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px;">Department</th>


                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Created By</th>


                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 150px;">Current Status</th>



                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 200px;">Action</th>

                </tr>
                </thead>
                <tbody>
  
                    @if( $purchase_requests->count() > 0 )
                    @foreach( $purchase_requests as $list )

                     <tr role="row" class="odd">

                        <td>PR-{{$list->id }} 
                       
                      
                      </td>

                    <td>{{ \App\Project::withTrashed()->find($list->project_id)->project_name }} 

                    </td>

                    <td>{{ \App\Department::withTrashed()->find($list->department_id)->department_name }}  </td>
                    <td>{{ $list->created_by}} </td>


                    <td>
                    @if($list->status == 0)
                    <span style="color:#eab800;">Pending</span>
                    @elseif($list->status == 1)
                    <span style="color:#ffbd02;">Approvals In Progress</span>
                    @elseif($list->status == 2)
                    <span style="color:red;">Rejected</span>
                    @elseif($list->status == 3)
                    <span style="color:#0d6efd;">RFQ</span>
                    @elseif($list->status == 4)
                    <span style="color:#0d6efd;"><a target="_blank" href="{{ route('request-for-quotations.view' , [$list->id]) }}">RFQ SEND</a></span>
                    @elseif($list->status == 5)
                    <span style="color:#0d6efd;"><a target="_blank" href="{{ route('comparative-statements.view' , [$list->id]) }}">CS Received</a></span>
                    @elseif($list->status == 6)
                    <span style="color:#0d6efd;"><a target="_blank" href="{{ route('purchase-orders.view' , [$list->id]) }}">PO Sent</a></span>
                    @elseif($list->status == 7)
                    @php
                    $getPrStatus = \App\PurchaseRequest::getPrStatus($list->id);
                    @endphp


                    @if( $getPrStatus['pending_po'] > 0)
                    <span style="color:#0d6efd;"><a style="font-size: 12px;" target="_blank" href="{{ route('purchase-orders.view' , [$list->id]) }}">PO PENDING</a> <span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{ $getPrStatus['pending_po'] }}</span></span>
                    @elseif( $getPrStatus['pending_recipt'] > 0)
                    <span style="color:#0d6efd;"><a  style="font-size: 12px;" target="_blank" href="{{ route('purchase-order-receipts.view' , [$list->id]) }}">RECEIPT PENDING</a><span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{$getPrStatus['pending_recipt']}}</span></span>

                    @elseif($getPrStatus['total_rfq'] > $getPrStatus['total_cs'])
                    <span style="color:#0d6efd;font-size: 12px;"><a target="_blank" href="{{ route('request-for-quotations.view' , [$list->id]) }}">CS PENDING</a><span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{$getPrStatus['total_rfq'] - $getPrStatus['total_cs']}}</span></span>
                    @else
                    <span style="color:#0ef30e;">Complete</span>
                    @endif

                    @endif
                    </td>

                    <td>
                    <a href="{{ route('purchase-requests.view',[$list->id] ) }}" target="_blank" class="btn btn-warning btn-xs" >view</a>
                    
                    <form method="POST" style="display: inline;" action="{{ route('purchase-request-approvals.changeStatus') }}"  id="pr_approval_form_{{$list->id}}">
                    {{csrf_field()}}
                    <input type="hidden" name="role_id" id="role_id" value="{{$role_id}}">
                    <input type="hidden" name="pr_id" id="pr_id" value="{{$list->id}}">
                    <button type="submit" name="status" class="btn btn-success btn-xs" value="approve">Approve</button>
                    <button type="submit" name="status" class="btn btn-danger btn-xs" value="unapprove">Unapprove</button>
                    </form>
                   

                    </td>
                    </tr>
                 @endforeach   
                 @endif


                </tbody>
                </table>
                </div>
                </div>



                 <div class="col-md-12">

                <div class="white-box">
                <div class="row">

                <div class="col-md-6">
                <h3 class="box-title" style="margin-bottom: 3rem;">Latest Purchase Requests</h3>


                <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                <thead>
                <tr role="row">
                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">Id#</th>

                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 150px;">Project</th>

                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px;">Department</th>


                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Created By</th>


                <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 150px;">Current Status</th>

                </tr>
                </thead>
                <tbody>

                @if( $data['purchase_request_latest']->count() > 0 )
                @foreach(  $data['purchase_request_latest'] as $list )

                <tr role="row" class="odd">

                <td><a href="{{ route('purchase-requests.view',[$list->id] ) }}" target="_blank"  > PR-{{$list->id }} </a></td>

                <td>{{ \App\Project::withTrashed()->find($list->project_id)->project_name }} 

                </td>

                <td>{{ \App\Department::withTrashed()->find($list->department_id)->department_name }}  </td>

                <td>{{ $list->created_by}} </td>


                <td>
                @if($list->status == 0)
                <span style="color:#eab800;">Pending</span>
                @elseif($list->status == 1)
                <span style="color:#ffbd02;">Approvals In Progress</span>
                @elseif($list->status == 2)
                <span style="color:red;">Rejected</span>
                @elseif($list->status == 3)
                <span style="color:#0d6efd;">RFQ</span>
                @elseif($list->status == 4)
                <span style="color:#0d6efd;"><a target="_blank" href="{{ route('request-for-quotations.view' , [$list->id]) }}">RFQ SEND</a></span>
                @elseif($list->status == 5)
                <span style="color:#0d6efd;"><a target="_blank" href="{{ route('comparative-statements.view' , [$list->id]) }}">CS Received</a></span>
                @elseif($list->status == 6)
                <span style="color:#0d6efd;"><a target="_blank" href="{{ route('purchase-orders.view' , [$list->id]) }}">PO Sent</a></span>
                @elseif($list->status == 7)
                @php
                $getPrStatus = \App\PurchaseRequest::getPrStatus($list->id);
                @endphp


                @if( $getPrStatus['pending_po'] > 0)
                <span style="color:#0d6efd;"><a style="font-size: 12px;" target="_blank" href="{{ route('purchase-orders.view' , [$list->id]) }}">PO PENDING</a> <span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{ $getPrStatus['pending_po'] }}</span></span>
                @elseif( $getPrStatus['pending_recipt'] > 0)
                <span style="color:#0d6efd;"><a  style="font-size: 12px;" target="_blank" href="{{ route('purchase-order-receipts.view' , [$list->id]) }}">RECEIPT PENDING</a><span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{$getPrStatus['pending_recipt']}}</span></span>

                @elseif($getPrStatus['total_rfq'] > $getPrStatus['total_cs'])
                <span style="color:#0d6efd;font-size: 12px;"><a target="_blank" href="{{ route('request-for-quotations.view' , [$list->id]) }}">CS PENDING</a><span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{$getPrStatus['total_rfq'] - $getPrStatus['total_cs']}}</span></span>
                @else
                <span style="color:#0ef30e;">Complete</span>
                @endif

                @endif
                </td>

                </tr>

                @endforeach   
                @endif


                </tbody>
                </table>


                </div>

                <div class="col-md-6">

                <h3 class="box-title" style="margin-bottom: 3rem;">Latest Purchase Orders</h3>

                <table id="myTable"  class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                    
                    <thead>
                    <tr role="row">

                    <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 80px;">ID#</th>

                    <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>



                    <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 20px;">Total Item</th>


                    <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 110px;">Status</th>



                    <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Action</th>

                    </tr>

                    </thead>
                    <tbody>

                   
                @foreach($data['total_purchase_orders'] as $pr )

                  @foreach($pr->purchase_orders as $po )
                @php
                $vendor = \App\PurchaseRequestVendor::find( $po->vendor_id);
                @endphp

                <tr role="row" class="odd">

                <td>  <a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($vendor->id).'&purchase_request='.Crypt::encryptString($po->purchase_request_id).'')}}"  target="_blank"> PO-{{$po->id}} </a></td>

                <td><a href="{{route('vendor.view' , [$vendor->id])}}">{{ucfirst($vendor->name)}}</a> </td>

                <td>
                [ {{\App\PurchaseOrder::getPurchaseOrderTotalItems($po->id , $po->purchase_request_id)}} ]
                </td>


                <td>
                @if($po->status == 1) 
                <div style="background: #0283cc;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
                {{ 'PO SENT' }}
                </div>
                @elseif ($po->status == 2) 
                <div style="background: #03c500;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
                {{ 'PO RECEIVED' }}
                </div>
                @elseif($po->status == 3)
                <div style="background: #f5cb00;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">

                {{ 'PARTIALLY RECEIVED' }} 

                </div>
                @endif
                </td>

                <td>


                @if($po->status == 1) 
                <a href="{{route('purchase-orders.cancel' , [$po->id])}}" onclick="return validate(this)" class="btn btn-danger btn-xs" >Cancel</a> 
                @else
                 <a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($vendor->id).'&purchase_request='.Crypt::encryptString($po->purchase_request_id).'')}}" class="btn btn-success btn-xs" target="_blank">View</a>
                @endif
                </td>

                </tr>

                    @endforeach   
    @endforeach  
                    </tbody>
                    </table>


                </div>
                </div>
                </div>
                </div>



</div>

</div>
     
@stop


@section('js')

 <script src="{{ asset('pusher/pusher.min.js')}}"></script>
  <script type="text/javascript">
  // Enable pusher logging - don't include this in production
  Pusher.logToConsole = false;
  var pusher = new Pusher('{{env('PUSHER_APP_KEY')}}' , {
  cluster: '{{env('PUSHER_APP_CLUSTER')}}'
  });
  var channel = pusher.subscribe('approval-channel');
  channel.bind('{{ $role_id }}', function(data) {
   location.reload(true);
  setTimeout(function(){ $('#successMessage').hide() }, 3000);
  });
  function validate(self) {
$(self).prop('disabled' ,true);
if (confirm('Are you sure about cancel this PO?')) 
{
    return true;
}
        return false;
        
    }
  </script>

  @stop