@extends('layouts.app')

@section('title')
Edit Department
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Departments</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
<div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        <h3 class="box-title m-b-0">Add New Department</h3>
                        <p class="text-muted m-b-30 font-13">  </p>
                        <form class="form-horizontal" method="POST" action="{{ route('department.update') }}">

                            	 {{csrf_field()}}

                                 <input type="hidden" name="id" value="{{$finddepartment->id}}">
                                 <div class="form-group">
                                   
                                    <div class="col-md-6">
                                    <label>Name</label>
                                    <input type="text" class="form-control" placeholder ="Type Department Name here...." value="{{ $finddepartment->department_name}}" name="name">
                                    @if ($errors->has('name'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                                    </span>
                                    @endif

                                    </div>

                                    <div class="col-md-6">
                                        <label>Department</label>
                                    <select class="form-control chosen-select" name="role_name">
                                    <option value="">Select role</option>
                                    @if($roles->count() > 0  )
                                    @foreach($roles as $list)
                                    <option <?php if($finddepartment->role->id == $list->id) echo 'selected'; ?> value="{{ $list->id }}">{{ $list->name }}</option> 
                                    @endforeach
                                    @endif
                                    </select>

                                    @if ($errors->has('role_name'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('role_name') }}</strong>
                                    </span>
                                    @endif
                                    </div>
                                    </div>
                               
                               

                                <div class="form-group">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop