@extends('layouts.app')

@section('title')
Update Asset Type
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Update Asset Type</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Update Asset Type</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{ route('update.fixed.asset.type') }}">
                                <input type="hidden" value="{{$fixed_asset_type->id}}" name="id">
                            	 {{csrf_field()}}
                                <div class="form-group">
                                
                                <div class="col-md-4">
                                <label>Name <b style="color:red;">*</b></label>
                                <input type="text" class="form-control" placeholder ="Update Asset Type Name here...." value="{{$fixed_asset_type->name}}" name="name">
                                @if ($errors->has('name'))
                                <span >
                                <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                                </span>
                                @endif

                                </div>



                                  <div class="col-md-4" >
                                    <label >
                                        Depreciation Policy 
                                        <b style="color:red;">*</b>
                                    </label>
                                        <select class="form-control chosen-select" name="depreciation_policy"> 
                                        
                                        <option <?=($fixed_asset_type->depreciation_policy == 'straight_line_method' ) ? 'selected' : '' ?> value="straight_line_method">Straight Line Method</option>
                                          <option <?=($fixed_asset_type->depreciation_policy == 'reducing_balance_method') ? 'selected' : '' ?> value="reducing_balance_method">Reducing Balance Method</option>

                                        </select>

                                        @if ($errors->has('depreciation_policy'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('depreciation_policy') }}</strong>
                                        </span>
                                        @endif


                                        </div>
                                         

                                          
                                    <div class="col-md-4" >
                                    <label >Depreciation Rate <b style="color:red;">*</b></label>

                                    <div class="input-group">
                                    <div class="input-group-addon">%</i></div>

                                    <input type="text" minlength="1" min="1" max="100" maxlength="3" onkeypress="return onlyNumber(event)"  class="form-control" placeholder ="Type depreciation rate " value="{{$fixed_asset_type->depreciation_rate}}" name="depreciation_rate">
                                    @if ($errors->has('depreciation_rate'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('depreciation_rate') }}</strong>
                                    </span>
                                    @endif

                                    </div>

                                    </div>

                                </div>
                               
                                <div class="form-group">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop 