@extends('layouts.app')

@section('title')
All Asset Type
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
<li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

<li class="active">Asset Type List</li>
</ol>
@stop

@section('content')
  <div class="container-fluid">
    <div class="row">
                    
<div class="col-sm-12">
                        <div class="white-box">

                            @permission('fixed-asset-types')
                           
                             <h3 style="text-align: right;" class="box-title m-b-0">
                                <span style="float: left;">Asset Type List</span><a class="btn btn-info btn-sm" href="{{ route('create.fixed.asset.type') }}">Add Asset Type</a></h3>

                             @endpermission

                            <div class="table-responsive">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                                <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                    <thead>
                                        <tr role="row">
                                        	<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name</th>

                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Depreciation Policy</th>

                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Depreciation Rate</th>
                                          
                                        	<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Created </th>

                                            <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Action</th>


                                        </tr>
                                    </thead>
                                    <tbody>
  
                                    @if( $fixed_asset_types->count() > 0 )
                                    @foreach( $fixed_asset_types as $list )

                                        <tr role="row" class="odd">
                                            <td>{{$list->name}}</td>
                                          
                                            <td>
                                            @if($list->depreciation_policy == 'straight_line_method')
                                            {{'Straight Line Method'}}
                                            @else
                                            {{'Reducing Balance Method'}}
                                            @endif
                                            </td>

                                            <td>{{$list->depreciation_rate}}%</td>

                                            <td>
                                                {{date('d-F-Y' , strtotime($list->created_at))}}
                                            </td>

                                             <td>

                                                
                                                <a style="color:red;" href="{{ route('delete.fixed.asset.type',[$list->id] ) }}" data-toggle="confirmation" data-title="Are you sure to delete?" ><i class="fa fa-trash-o" aria-hidden="true"></i></a>
                                               

                                                 <a style="margin-left: 1rem;"  href="{{ route('edit.fixed.asset.type',[$list->id] ) }}"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>

                                                

                                            </td>

                                        </tr>
                                     @endforeach   
                                     @endif

                                      
                                    </tbody>
                                </table>
                                
                            </div>
                            </div>
                        </div>
                    </div>


    </div>

      </div>
@stop
