@extends('layouts.app')

@section('title')
Add Work Order
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Work Order</li>
      </ol>
@stop

@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Add New Work Order</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" onsubmit="return addWorkOrder(this)">
                            	 {{csrf_field()}}
                                <div class="form-group" style="margin-bottom: 25px;">
                                    <!-- <label class="col-md-12">Default Text <span class="help"> e.g. "George deo"</span></label> -->


                                <div class="col-md-6">
                                    <label>Name</label>
                                    <input type="text" class="form-control" placeholder ="Type Task Name ...." value="{{old('name')}}" id="name" name="name">
                                    @if ($errors->has('name'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                                    </span>
                                    @endif
                                </div>



                                <div class="col-md-6" id="taskCategory">

                                    <label>Is Parent</label>
                                        <select class="form-control select2"  onchange="return taskCategory(this)" id="TaskCategory">
                                            <option value="">None</option>
                                            <option value="task">Task</option>
                                            <option value="sub-task">Sub task</option>
                                        </select> 
                                    </div>


                                    <div class="col-md-6" style="display: none;" id="task_list">
                                        <label>Task List</label>

                                        <div class="row">
                                        <div class="col-md-10">
                                               
                                        <select class="form-control select2" name="category" id="sub_task">
                                        @if($task->count() > 0  )

                                        @foreach($task as $parent_list)
                                         
                                        <optgroup label="{{$parent_list->text}}">
                                       
                                        @if( $parent_list->children->count() > 0)
                                        @foreach($parent_list->children as $child_list)

                                        <option value="{{ $child_list->id }}">
                                        {{ $child_list->text }}
                                        </option> 
 
                                        @endforeach
                                         @endif
                                        </optgroup>
                                        
                                        @endforeach
                                    
                                        @endif
                                        </select>



                                            </div>

                                            <div class="col-md-2">
                                              <button type="button" class="us_task_btn" onclick="return hideTaskCategory(this)"><i class="fa fa-times" aria-hidden="true"></i></button>
                                            </div>
                                        </div>
                                    </div>

                                   <div id="form_fileds" style="display:none;">
                                        <div class="col-md-12" style="margin-top:1rem;">

                                        <center><h3 class="us-nav">Task Details</h3></center>

                                        </div>


                                        <div class="col-md-4">
                                        <label>Start date</label>
                                        <input type="date"  id="start_date" class="form-control" name="">
                                        </div>

                                        <div class="col-md-4">
                                        <label>Duaration</label>
                                        <input type="text" id="duration"  placeholder="Duration in days" class="form-control" name="">
                                        </div>

                                        <div class="col-md-4">
                                        <label>Progress</label>
                                        <input type="text" id="progress" placeholder="Progress in %" class="form-control" name="">
                                        </div>

                                        <div class="col-md-12" style="margin-top: 3rem;">
                                        <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                        </div>
                                     

                                   </div>

                                    </div>

                                </div>
                               
                               
    	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop 

@section('js')
<script type="text/javascript">
function addWorkOrder(self) {

var name = $('#name').val();
var start_date = $('#start_date').val();
var duration = $('#duration').val();
var progress = $('#progress').val();


 if ($('#TaskCategory').val() == 'sub-task')
     {
         var parent = $('#sub_task').val();
     }
     else
     {
         var parent = 0;
     }

$.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('store.work-order') }}",
        method:'POST',
        dataType:'json',
        data: {name:name , start_date: start_date , duration:duration , progress:progress , parent:parent},
        success:function(data)
        {
             
        }
        })

 return false;
}
    function hideTaskCategory(self) {
        $('#task_list').hide();
        $('#taskCategory').show()
        $('#form_fileds').hide();
    return false;
    }

    function taskCategory(self) {
    if ($(self).val() == 'sub-task')
     {
        $('#task_list').show();
        $('#taskCategory').hide()
        $('#form_fileds').show();
     }
     else if($(self).val() == 'task')
     {
        $('#task_list').hide();
        $('#taskCategory').show()
        $('#form_fileds').show();
     }
     else
     {
          $('#task_list').hide();
        $('#taskCategory').show()
        $('#form_fileds').hide();
     }

    return false;
    }
</script>
@stop