<!DOCTYPE html>
<head>
    <meta http-equiv="Content-type" content="text/html; charset=utf-8">
 
    <script src="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link href="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.css" rel="stylesheet">
 
    <style type="text/css">
        html, body{
            height:100%;
            padding:0px;
            margin:0px;
            overflow: hidden;
        }
        .gantt_task_line.gantt_bar_task
        {
            pointer-events: none;
        }
       .gantt_grid_head_cell.gantt_grid_head_add.gantt_last_cell
       {
        pointer-events: none;
        display: none;
       } 
       .gantt_add
       {
        pointer-events: none;
        display: none;
       }
    </style>
</head>
<body>

<div id="gantt_here" style='width:100%; height:100%;'></div>
<script type="text/javascript">

gantt.config.date_format = "%Y-%m-%d %H:%i:%s";


gantt.config.columns =  [
    {name:"text",       label:"Task name",  tree:true, width:"*" , min_width: 200, max_width:300},
    {name:"start_date", label:"Start time", align:"center" },
    {name:"end_date",   label:"End date",   align:"center" },
    {name:"progress",   label:"Progress",   align:"center" },
];

 
gantt.init("gantt_here");
 
gantt.load("/api/data");

// A $( document ).ready() block.
$( document ).ready(function() {
setTimeout(function(){ 
    $('.gantt_task_progress_drag').remove(); 
    $('.gantt_link_point').remove();
}, 1000);
})


$(document).on("click",function() {

$('.gantt_task_progress_drag').remove(); 
$('.gantt_link_point').remove();
$('.gantt_task_line.gantt_bar_task').removeAttr('data-task-id')
$('.gantt-info.dhtmlx-info.gantt-error.dhtmlx-error').remove();
return false
});


$(document).on("click",".gantt_task_line.gantt_bar_task",function() {

$('.gantt_task_progress_drag').remove(); 
$('.gantt_link_point').remove();
$('.gantt_task_line.gantt_bar_task').removeAttr('data-task-id');
$('.gantt-info.dhtmlx-info.gantt-error.dhtmlx-error').remove();
return false
});



</script>


</body>