@extends('layouts.app')

@section('title')
All Unit
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
<li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

<li class="active">Item Unit List</li>
</ol>
@stop

@section('content')
  <div class="container-fluid">
    <div class="row">
                    
<div class="col-sm-12">
                        <div class="white-box">

                            @permission('item-unit')
                           
                             <h3 style="text-align: right;" class="box-title m-b-0">
                                <span style="float: left;">Item Unit List</span><a class="btn btn-info btn-sm" href="{{ route('create.item.unit') }}">Add New Unit</a></h3>

                             @endpermission

                            <div class="table-responsive">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                                <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                    <thead>
                                        <tr role="row">
                                        	<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name</th>

                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Description</th>
                                          
                                        	<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Created Date</th>

                                            <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Action</th>


                                        </tr>
                                    </thead>
                                    <tbody>
  
                                    @if( $item_units->count() > 0 )
                                    @foreach( $item_units as $list )

                                            <tr role="row" class="odd">
                                            <td>{{$list->name}}</td>
                                            <td>{{$list->description}}</td>
                                          
                                            <td>{{date('d-F-Y' , strtotime($list->created_at))}}</td>
                                             <td>

                                                @permission('item-unit')

                                                <form action="{{route('delete.unit',[$list->id] ) }}" method="post" style='display: inline;'>
                                                    @method('DELETE')
                                                    @csrf                                       
                                                    <button class="btn btn-link btn-s" style="color:red;"  type="submit" name="action" value="delete" data-toggle="confirmation" data-title="Are you sure to delete?">
                                                        <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                    </button>                                                  
                                                 </form>
                                               
                                                  
                                                @endpermission

                                                @permission('item-unit')
                                                <a  href="{{ route('edit.unit',[$list->id] )}}">
                                                    <button class="btn btn-link btn-s">
                                                        <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                                                    </button>
                                                    </a>
                                                
                                                 {{-- <a style="margin-left: 1rem;"  href="{{ route('edit.unit',[$list->id] ) }}"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a> --}}

                                                 @endpermission

                                            </td>

                                        </tr>
                                     @endforeach   
                                     @endif

                                      
                                    </tbody>
                                </table>
                                
                            </div>
                            </div>
                        </div>
                    </div>


    </div>

      </div>
@stop

@section('js')  

<script type="text/javascript">
    function validate()
    { 
        if(!confirm('Are you sure you want to delete?'))
        {
            return false;
        } 
    }
</script>
@stop