@extends('layouts.app')

@section('title')
Add Inventory
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Add Inventory</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Add  Inventory</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{ route('item.insert') }}">
                            	 {{csrf_field()}}
                                <div class="form-group">

                                          
                                     <div class="col-md-3">
                                        <label >Code <b style="color:red;">*</b></label>
                                        <input type="text" class="form-control" placeholder ="Type Inventory Code here...." value="{{rand('00000' , '999999')}}" name="itemcode">
                                         @if ($errors->has('itemcode'))
                                    <span >
                                        <strong class="error_messages" >{{ $errors->first('itemcode') }}</strong>
                                    </span>
                                         @endif

                                     </div>
                                 

                                    <div class="col-md-3">
                                        <label >Name <b style="color:red;">*</b></label>
                                    <input type="text" class="form-control" placeholder ="Type Inventory Name here...." value="{{old('name')}}" name="name">
                                    @if ($errors->has('name'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                                    </span>
                                    @endif

                                    </div>


                                    <div class="col-md-3">
                                   <label >Manufacture <b style="color:red;">*</b></label>
                                        <select class="form-control chosen-select" name="brand">
                                        <option value="">Select Manufacture</option>
                                        @if($manufacture_list->count() > 0  )
                                        @foreach($manufacture_list as $list)
                                        <option value="{{ $list->id }}">{{ $list->name }}</option> 
                                        @endforeach
                                        @endif
                                        </select>

                                        @if ($errors->has('brand'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('brand') }}</strong>
                                        </span>
                                        @endif
                                     

                                    </div>


                                    <div class="col-md-3">
                                        <label >Opening qty <b style="color:red;">*</b></label>
                                    <input type="text" class="form-control" placeholder ="Inventory Opening Quantity...." value="{{old('quantity')}}" name="quantity">
                                    @if ($errors->has('quantity'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('quantity') }}</strong>
                                    </span>
                                    @endif

                                    @if (session('quantity'))
                                    <span >
                                    <strong class="error_messages" >
                                    {!! session('quantity') !!}</strong>
                                    </span>
                                    @endif

                                    </div>


                                    </div>


                                    <div class="form-group">


                                     <div class="col-md-6">

                                        <div class="row">
                                            
                                        <div class="col-md-6">
                                            <label >Category <b style="color:red;">*</b></label>
                                        <select class="form-control chosen-select" name="category">

                                        @if($parent_category->count() > 0  )

                                        @foreach($parent_category as $parent_list)
                                        
                                        <option value="{{ $parent_list->id }}">
                                        {{ $parent_list->category_name }}
                                        </option>
                                      
                                        @endforeach
                                      
                                        @endif

                                        </select>

                                        @if ($errors->has('category'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('category') }}</strong>
                                        </span>
                                        @endif
                                        </div>

                                        <div class="col-md-6">
                                            <label >Measurement Unit <b style="color:red;">*</b>
                                        </label>

                                        <select class="form-control chosen-select" name="unit">
                                        <option value="">Select Inventory Unit</option>
                                        @if($item_units->count() > 0  )
                                        @foreach($item_units as $list)
                                        <option value="{{ $list->name }}">{{ $list->name }}</option> 
                                        @endforeach
                                        @endif
                                        </select>

                                        @if ($errors->has('unit'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('unit') }}</strong>
                                        </span>
                                        @endif
                                        </div>

                                        </div> 

                                   

                                     </div>
                                 
                                 
                                    <div class="col-md-6">

                                     <div class="row">
                                         <div class="col-md-6">
                                            <label >Min Qty <b style="color:red;">*</b></label>
                                            <input type="number" class="form-control" placeholder ="Min Quantity here...." value="{{old('minqty')}}" name="minqty">
                                         @if ($errors->has('minqty'))
                                    <span >
                                        <strong class="error_messages" >{{ $errors->first('minqty') }}</strong>
                                    </span>
                                         @endif


                                         @if (session('minquantity'))
                                         <span >
                                        <strong class="error_messages" >
                                        {!! session('minquantity') !!}</strong>
                                        </span>
                                        @endif

                                          </div>

                                         

                                           <div class="col-md-6">
                                            <label >Max Qty <b style="color:red;">*</b></label>
                                             <input type="number" class="form-control" placeholder ="Max Quantity here...." value="{{old('maxqty')}}" name="maxqty">
                                         @if ($errors->has('maxqty'))
                                    <span >
                                        <strong class="error_messages" >{{ $errors->first('maxqty') }}</strong>
                                    </span>
                                         @endif
                                          </div>


                                         </div>
                                     </div>


                                    </div>

                                        <div class="form-group">
                                        <div class="col-md-12">
                                        <div class="row">
                                     
                                        <div class="col-md-6">
                                        <label>Inventory Type <b style="color:red;">*</b></label>
                                        <select class="form-control chosen-select" name="type">
                                        <option value="consumable">Consumable</option> 
                                        <option value="tools">Tools or Assets</option>
                                        <option value="direct_material">Direct Material</option>
                                       
                                        </select>

                                        @if ($errors->has('type'))
                                        <span >
                                        <strong class="error_messages" >
                                            {{ $errors->first('type') }}
                                        </strong>
                                        </span>
                                        @endif
                                    </div>


                                     <div class="col-md-3">
                                        <label >Size </label>
                                            <input type="text" class="form-control"  placeholder ="Size here...." value="{{old('size')}}" name="size">
                                            @if ($errors->has('size'))
                                            <span >
                                                 <strong class="error_messages" >{{ $errors->first('size') }}</strong>
                                            </span>
                                            @endif
                                    </div>


                                    <div class="col-md-3">
                                         <label>Risk type <b style="color:red;">*</b></label>
                                     <div class="row" style="margin-top: 0.6rem;">
                                       <div class="col-md-6">
                                             Critical : <input type="radio" value="critical" name="storage_type">
                                       </div>
                                       <div class="col-md-6">
                                           Non Critical : <input type="radio" value="non_critical"  name="storage_type">
                                       </div>
                                     </div>
                                        @if ($errors->has('storage_type'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('storage_type') }}</strong>
                                        </span>
                                        @endif
                                    </div>


                                    </div>
                                  </div>
                                </div>




                                    <div class="form-group">
                                    <label class="col-md-12">Specification</label>
                                    <div class="col-md-12">
                                        <textarea class="form-control" name="description" rows="5"></textarea>
                                    </div>
                                </div>
                                
                               
                                <div class="form-group">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop
