@extends('layouts.app')

@section('title')
Aging Report
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right" >
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Aging Report</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
  <div class="container-fluid" id="printableSection">
  <div class="row">
                    
    <div class="col-sm-12">
    <div class="white-box">

    <h3 class="box-title m-b-0" style="text-align: right;">
      <span style="float: left;" class="test"> Items Aging Report</span>

       <a class="btn btn-warning avoid-this btn-sm" id="print" href="#">Print</a>
    </h3>

    <div class="">

    @if(Session::has('success'))   
    <div id="successMessage" class="alert alert-success" role="alert">
    {{ Session::get('success') }}
    </div>
    @endif

    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
    <thead>
    <tr role="row">

    <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Code</th>


    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 150px;">Name  - Brand</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">0-30 Days</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">30 - 60 Days</th>

     <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">60-90 Days</th>

      <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">90+ Days</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Quantity</th>

  


    </tr>
    </thead>
    <tbody>

    @if( $items->count() > 0 )

    @foreach( $items as $item )
   
   @php
      $result = \App\Http\Controllers\ItemController::getItemAgingReport($item->id);
   @endphp

    <tr class="active">
    <td >{{$item->item_code }}</td>
     <td class="item_name">
            {{$item->item_name}} - {{$item->manufacture->name}}
            <?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
        </td>
    <td>{{ number_format( $result[0]  , 2) }}</td>
    <td>{{  number_format( $result[1]  , 2)}}</td>
    <td >{{  number_format( $result[2] , 2) }}</td>
     <td >{{  number_format( $result[3]  , 2)}}</td>
    <td>{{number_format($result[0] + $result[1] + $result[2] + $result[3] , 2)}}</td>
    </tr>

    @endforeach   
    @endif

    </tbody>
    </table>

    </div>
    </div>
    </div>
    </div>


    </div>

    </div>
    </div>


@stop



@section('js')  


@stop