@extends('layouts.app')

@section('title')
Asset Ledger Report
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li>
            <a href="{{route('home')}}">
            <i class="fa fa-dashboard"></i> 
            Home
        </a>
        </li>

        <li class="active">
             Asset Ledger
        </li>
    </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
 <style type="text/css">
     .reassign_form
     {
        display: none;
     }
 </style>
@stop
@section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">
    <div class="white-box">

    <h3 style="text-align: center;" class="box-title m-b-0">
        <span >Assets Ledger </span>
      
      
    </h3>


      <!-- Nav tabs -->
    <ul class="nav customtab nav-tabs" role="tablist" style="margin-top: 3rem;">

        <li role="presentation" class="active"><a href="#depreciation" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs"> Depreciation </span></a></li>


        <li role="presentation" class=""><a href="#sold" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Sold</span></a></li>


    </ul>


 <!-- Tab panes -->
<div class="tab-content">

    <div  role="tabpanel"  class="table-responsive tab-pane fade active in" id="depreciation">


    <form method="get" style="margin-bottom: 3rem;margin-top: 1rem;" onsubmit="return getAssetLedger(this , 'depreciation');">
        <div class="row">

            <div class="col-sm-5">
                <label>By Category</label>
                <select class="form-control chosen-select" id="category">
                <option value="">Select Category</option>
                 @foreach( $fixed_asset_types as $fixed_asset_type )
                  <option value="{{$fixed_asset_type->id}}">{{$fixed_asset_type->name}}</option>
                 @endforeach
                </select>
            </div>


            <div class="col-sm-5">
                <div class="row">

                    <div class="col-sm-6">
                        <label>From</label>
                        <input type="month" value="{{date('Y-m')}}" class="form-control" name="from" id="from">
                    </div>

                    <div class="col-sm-6">
                        <label>To</label>
                        <input type="month"  class="form-control" name="to" id="to">
                    </div>

                </div>
            </div>

            <div class="col-sm-2" style="margin-top: 2.5rem;">
                <button type="submit" class="btn btn-success">Calculate</button>
            </div>

        </div>
    </form>

 

  <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
    
    <thead>
    <tr role="row">

    <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 20px;">Tag</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Name - Brand</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Purchase</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Month(s)</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> Rate</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Cost</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Type</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> Policy</th>


    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Opening</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;" title="Booking Value">BV</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;" title="For The Period">FTP</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;" title="For The Period">Maintainance</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> Closing</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;" title="Writen Down Value"> WDV</th>

    </tr>
    </thead>
    <tbody id="tbl_data">


    </tbody>
    </table>

    </div>



    <!--------------------tab 2 ----------------------------------------------------->



        <div  role="tabpanel"  class="table-responsive tab-pane fade" id="sold">


    <form method="get" style="margin-bottom: 3rem;margin-top: 1rem;" onsubmit="return getAssetLedger(this , 'sold');">
        <div class="row">

            <div class="col-sm-5">
                <label>By Category</label>
                <select class="form-control chosen-select" id="category">
                <option value="">Select Category</option>
                 @foreach( $fixed_asset_types as $fixed_asset_type )
                  <option value="{{$fixed_asset_type->id}}">{{$fixed_asset_type->name}}</option>
                 @endforeach
                </select>
            </div>


            <div class="col-sm-5">
                <div class="row">

                    <div class="col-sm-6">
                        <label>From</label>
                        <input type="month" value="{{date('Y-m')}}" class="form-control" name="from" id="from">
                    </div>

                    <div class="col-sm-6">
                        <label>To</label>
                        <input type="month"  class="form-control" name="to" id="to">
                    </div>

                </div>
            </div>

            <div class="col-sm-2" style="margin-top: 2.5rem;">
                <button type="submit" class="btn btn-success">Calculate</button>
            </div>

        </div>
    </form>

 

    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
    <thead>

        <tr role="row">

        <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 20px;">Tag</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Name - Brand</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Purchase</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Month(s)</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> Rate</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Cost</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Type</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> Policy</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Opening</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;" title="Booking Value">BV</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;" title="For The Period">FTP</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;" title="For The Period">Maintainance</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> Closing</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;" title="Writen Down Value"> WDV</th>

        </tr>

    </thead>
    <tbody id="tbl_data_tab2">


    </tbody>
    </table>

    </div>


</div>




    </div>
    </div>
    </div>


    </div>

    </div>
    </div>

  
@stop


@section('js')


<script type="text/javascript">

function getAssetLedger(self , tab_type) 
{
    var category = $(self).find('#category').val()
    var from = $(self).find('#from').val()
    var to =$(self).find('#to').val()
    var type = 'asset_ledger';

      $.ajax({

        url:"{{ route('filter.asset.ledger') }}",
        method:'GET',
        dataType:'json',
        data:{category:category , from:from , to:to , type:type , tab_type:tab_type},
        success:function(data)
        {
           if (data.response == 'from_error') 
           {
            alert('Please Select From Date.');
           }

            if (data.response == 'greater_error') 
           {
            alert('To Date Not Be Greater Than From.');
           }

           if (data.response == 'ok') 
           {
                $td_data_rows = '';
                $total_cost = 0;
                $total_opening = 0;
                $total_for_the_period = 0;
                $total_maintainance_charges = 0;
                $total_closing = 0;
                $total_wdv = 0;
                $total_bv = 0;

                $.each(data.output, function(k, v) 
                {
                    $td_data_rows +='<tr>';
                    $td_data_rows += '<td >'+v.asset_tag+'</td>';
                    $td_data_rows += '<td >'+v.name+'</td>';
                    $td_data_rows += '<td >'+v.purchase_date+'</td>';
                    $td_data_rows += '<td >'+v.total_month+'</td>';
                    $td_data_rows += '<td >'+v.rate+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.cost)+'</td>';
                    $td_data_rows += '<td >'+v.asset_type+'</td>';
                    $td_data_rows += '<td >'+v.policy+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.total_opening_month)+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.bv)+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.for_the_period)+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.maintainance)+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.closing)+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.wdv)+'</td>';
                    $td_data_rows +='</tr>';


                    $cost =  parseFloat(v.cost) || 0;
                    $opening =  parseFloat(v.total_opening_month) || 0;
                    $for_the_period =  parseFloat(v.for_the_period) || 0;
                    $maintainance_charges =  parseFloat(v.maintainance) || 0;
                    $closing =  parseFloat(v.closing) || 0;
                    $wdv =  parseFloat(v.wdv) || 0;
                    $bv =  parseFloat(v.bv) || 0;

                    $total_cost = $total_cost +  $cost
                    $total_opening = $total_opening + $opening;
                    $total_for_the_period = $total_for_the_period + $for_the_period;
                    $total_maintainance_charges = $total_maintainance_charges + $maintainance_charges;
                    $total_closing = $total_closing + $closing;
                    $total_wdv = $total_wdv + $wdv;
                    $total_bv =  $total_bv + $bv;

                });

                  $td_data_rows +='<tr>';
                  $td_data_rows += '<td colspan="5" style="font-weight:bold;">Total:</td>';
                  $td_data_rows += '<td colspan="3" style="font-weight:bold;">'+ addCommas($total_cost)+'</td>';
                  $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_opening)+'</td>';
                  $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_bv)+'</td>';
                  $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_for_the_period)+'</td>';
                  $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_maintainance_charges)+'</td>';
                  $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_closing)+'</td>';
                  $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_wdv)+'</td>';
                  $td_data_rows +='</tr>';


                    if (tab_type == 'depreciation') 
                    {
                        $('#tbl_data').html($td_data_rows);   
                    }


                     if (tab_type == 'sold') 
                    {
                        $('#tbl_data_tab2').html($td_data_rows);   
                    }
               
           }
        }
    })

    return false;
}


function addCommas(nStr)
{
    nStr += '';
    x = nStr.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
}


</script>

@stop