@extends('layouts.app')

@section('title')
Add Asset
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Add Asset</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Add  Asset</h3>

                        @if(Session::has('quantity'))   
                            <div  class="alert alert-danger" role="alert">
                            {{ Session::get('quantity') }}
                            </div>
                        @endif


                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{ route('fixed.assets.insert') }}">
                            	 {{csrf_field()}}
                                <div class="form-group">

                                          
                                     <div class="col-md-4" >
                                        <label >Asset tag <b style="color:red;">*</b></label>
                                        <input type="text" class="form-control" placeholder ="Type asset tag here...."  value="AST{{rand('00000' , '999999')}}" name="asset_tag">
                                        @if ($errors->has('asset_tag'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('asset_tag') }}</strong>
                                        </span>
                                        @endif

                                     </div>
                                 

                                    <div class="col-md-4">
                                        <label >Name <b style="color:red;">*</b></label>
                                    <input type="text" class="form-control" placeholder ="Type Item Name here...." value="{{old('name')}}" name="name">
                                    @if ($errors->has('name'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                                    </span>
                                    @endif

                                    </div>


                                    <div class="col-md-4" >
                                        <label >Items <b style="color:red;">*</b></label>
                                        <select class="form-control chosen-select" name="items"> 
                                        
                                        @if($items->count() > 0 )

                                        @foreach($items as $list)
                                         
                                        <option value="{{$list->id}}">
                                            {{$list->item_name}} 

                                             @php

                                            $total_items = \App\FixedAsset::where('item_id' , $list->id)->count();

                                            if(( $list->quantity - $total_items ) <= 0 )
                                            {
                                               echo  '( '. 0 .' )';
                                            }
                                            else
                                            {
                                                echo '( '. ($list->quantity - $total_items) .' )';
                                            }
                                            @endphp

                                           
                                        </option>

                                        @endforeach

                                        @endif

                                        </select>

                                        @if ($errors->has('items'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('items') }}</strong>
                                        </span>
                                        @endif


                                        </div>


                                    <div class="col-md-4" style="margin-top: 1.5rem;" >
                                    <label >Serial <b style="color:red;">*</b></label>
                                    <input type="text" class="form-control" placeholder ="Type Serial..." value="{{old('serial')}}" name="serial">
                                    @if ($errors->has('serial'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('serial') }}</strong>
                                    </span>
                                    @endif

                                    </div>


                                    <div class="col-md-4" style="margin-top: 1.5rem;" >
                                    <label >Cost <b style="color:red;">*</b></label>
                                    <input type="number" step="any" class="form-control" placeholder ="Type Cost..." value="{{old('cost')}}" name="cost">
                                    @if ($errors->has('cost'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('cost') }}</strong>
                                    </span>
                                    @endif

                                    </div>


                                    <div class="col-md-4" style="margin-top: 1.5rem;" >
                                    <label >Purchase Date <b style="color:red;">*</b></label>
                                    <input type="date"  class="form-control"   value="{{date('Y-m-d')}}" name="purchase_date">
                                    @if ($errors->has('purchase_date'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('purchase_date') }}</strong>
                                    </span>
                                    @endif

                                    </div>

                                    <div class="col-md-4" style="margin-top: 1.5rem;">
                                        <label >Asset Location <b style="color:red;">*</b></label>
                                        <select class="form-control chosen-select" name="asset_location"> 
                                        
                                        @if($asset_locations->count() > 0 )

                                        @foreach($asset_locations as $list)
                                         
                                         <option value="{{$list->id}}">{{$list->name}}</option>

                                        @endforeach

                                        @endif

                                        </select>

                                        @if ($errors->has('asset_location'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('asset_location') }}</strong>
                                        </span>
                                        @endif


                                        </div>

                                          <div class="col-md-4" style="margin-top: 1.5rem;">
                                            <label >Asset Type <b style="color:red;">*</b></label>
                                        <select class="form-control chosen-select" name="asset_type"> 
                                        
                                        @if($fixed_asset_types->count() > 0 )

                                        @foreach($fixed_asset_types as $list)
                                         
                                         <option value="{{$list->id}}">{{$list->name}}</option>

                                        @endforeach

                                        @endif

                                        </select>

                                        @if ($errors->has('asset_type'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('asset_type') }}</strong>
                                        </span>
                                        @endif


                                        </div>



                                    <div class="col-md-4" style="margin-top: 1.5rem;">
                                    <label >Warranty <b style="color:red;">*</b></label>
                                    <div class="input-group">
                                    <div class="input-group-addon">Month(s)</i></div>
                                    <input type="text" class="form-control" placeholder ="Type Warranty in months..." value="{{old('warranty')}}" name="warranty">
                                    @if ($errors->has('warranty'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('warranty') }}</strong>
                                    </span>
                                    @endif

                                    </div>

                                    </div>
                                    </div> 


                                    <div class="form-group">
                                    <label class="col-md-12" style="margin-top: 1.5rem;">Specification</label>
                                    <div class="col-md-12">
                                        <textarea class="form-control" name="description" rows="5"></textarea>
                                    </div>
                                </div>
                                
                               
                                <div class="form-group">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop

@section('js')  

<script type="text/javascript">

    function onlyNumber(evt) {
    var charCode = (evt.which) ? evt.which : event.keyCode
    if (charCode > 31 && (charCode < 48 || charCode > 57)){
            return false;
        }
    return true;
}

</script>
@stop