@extends('layouts.app')

@section('title')
Dashboard
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Dashboard</li>
      </ol>
@stop

@section('css')
<style type="text/css">
  #purchase_requests_id_chosen
  {
     display: none;
  }
</style>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
            
            <div class="col-md-4">
            <div class="white-box bg-success color-box" style="padding: 0px 0px 20px 20px;">
            <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">Assets</h1>
            
            <p class="cb-text">Info</p>
            <h6 class="text-white font-semibold">Total <span style="margin-left: 2rem;" class="font-light">{{$total_fixed_assets}}</span></h6>

          
            </div>
            </div>



             <div class="col-md-4">
            <div class="white-box bg-primary color-box" style="padding: 0px 0px 20px 20px;">
            <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">Maintainance</h1>
            
            <p class="cb-text">Info</p>
            <h6 class="text-white font-semibold">Total <span style="margin-left: 2rem;" class="font-light">{{$total_fixed_asset_maintainces}}</span></h6>
           
            </div>
            </div>




             <div class="col-md-4">
            <div class="white-box bg-warning color-box" style="padding: 0px 0px 20px 20px;">
            <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">Asset Types</h1>
            
            <p class="cb-text">Info</p>
             <h6 class="text-white font-semibold">Total <span style="margin-left: 2rem;" class="font-light">{{$total_fixed_asset_types}}</span></h6>
           
            </div>
            </div>



            <!-------------------------End----------------------------------------->




            <div class="col-md-6">
<div class="white-box " >
<h3 class="box-title" > Recently Assigning Activity</h3>

<table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
<thead>
<tr role="row">


<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Name </th>

<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Assign Date</th>

<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Till</th>

</tr>
</thead>
<tbody>



@foreach( $fixed_asset_assignee as $list )

<tr class="active">


<td >{{ \App\HrmEmployee::find($list->employee_id)->name }}</td>
<td >{{ date('d-F-Y' , strtotime($list->assign_date)) }}</td>
<td >{{ $list->till_date ? date('d-F-Y' , strtotime( $list->till_date)) : 'Curent Assigned'  }}</td>

</tr>
@endforeach   


</tbody>
</table>

</div>
</div>



                <div class="col-md-6">
                <div class="white-box " >

                  <h3 class="box-title" > Asset Usage</h3>
                  <div id="graph" style="text-align: center;"></div>

                  <div id="info" class="output" style="font-size: 2rem;"></div>

                </div>
                </div>





</div>

</div>



@stop

@section('js')  

<script type="text/javascript">
   
 var data = [
  <?php echo  $chartList; ?>,
  []
];


var i = 0;
var max = data.length-1;

var labels = function(dataarray) {
  var labels = "No Data to display";

  if(dataarray.length > 0) labels = dataarray.map(item => item.label+": "+item.value).join("<br>");
  $("#info").html(labels);
}

var labelsOnUpdate = function(dataarray) {
  var labels = "No Data to display";

  if(dataarray.length > 0) labels = dataarray.map(item => item.label+": "+item.value+" ("+item.percent+")").join("<br>");
  $("#info").html(labels);
}


var update = function() {
  if (i < max) i++; else i=0;

  return i;
}

//https://github.com/jnicol/jquery-plugin-boilerplate
jQuery(document).ready(function() {
  var graph;

  var init = function (data) {
    graph = $("#graph").donutgraph({
      data: data,
      donutWidth: 15,
      onChange: function(obj) {
        console.log(obj);
        labelsOnUpdate(obj);

      }
    });

  }


  /*
  d3.interval(() => {
    $("#graph").donutgraph("update", generate());
  }, 8000);
  */


  init(data[0]);
  //labels(data[0]);

  $(document).on('click', '#btn1', function(e) {
    var index = update();
    graph.donutgraph("update", data[index]);
    //labels(data[index]);
  });


  $(document).on('click', '#btn2', function(e) {
    $(this).toggleClass('lock'); //save state on button

    if($(this).hasClass('lock')) graph.donutgraph("setColor", 0); else graph.donutgraph("setColor", 1);
  });


});


</script>

@stop