@extends('layouts.app')

@section('title')
Depreciation Report
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li>
            <a href="{{route('home')}}">
            <i class="fa fa-dashboard"></i> 
            Home
        </a>
        </li>

        <li class="active">
             Depreciation Report
        </li>
    </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
 <style type="text/css">
     .reassign_form
     {
        display: none;
     }
 </style>
@stop
@section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">
    <div class="white-box">

    <h3 style="text-align: center;" class="box-title m-b-0">
        <span >Depreciation Report</span>
    </h3>

       <!-- Nav tabs -->
    <ul class="nav customtab nav-tabs" role="tablist" style="margin-top: 3rem;">
        <li role="presentation" class="active"><a href="#depreciation" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs"> Depreciation </span></a></li>

        <li role="presentation" class=""><a href="#sold" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Sold</span></a></li>
    </ul>


    <!-- Tab panes -->
<div class="tab-content">

  <div  role="tabpanel"  class="table-responsive tab-pane fade active in" id="depreciation">

   <form method="get" style="margin-bottom: 3rem;margin-top: 1rem;" onsubmit="return getAssetLedger(this , 'depreciation' );">

        <div class="row">

            <div class="col-sm-10">
                <div class="row">

                    <div class="col-sm-6">
                        <label>From</label>
                        <input type="month" value="{{date('Y-m')}}" class="form-control" name="from" id="from">
                    </div>

                    <div class="col-sm-6">
                        <label>To</label>
                        <input type="month"  class="form-control" name="to" id="to">
                    </div>

                </div>
            </div>

            <div class="col-sm-2" style="margin-top: 2.5rem;">
                <button type="submit" class="btn btn-success">Calculate</button>
            </div>

          

        </div>
    </form>

  <div class="alert alert-success us_success_alert"  style="display: none;" role="alert" >
 Data Sent Successfully To Accounts
</div>


<div class="alert alert-danger us_error_alert"  style="display: none;" role="alert" >
</div>

    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
    <thead>
    <tr role="row">

    <th  class=""    tabindex="0"  rowspan="1" colspan="1"  style="width: 10px;text-align: center;"><input style="zoom: 1.6;" type="checkbox" name="" id="depreciation_parent_check_box"></th>

     <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Type</th>

     <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Policy</th>

       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Cost</th>

       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Opening</th>

       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">BV</th>

       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">For The Period</th>

       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Maintainance</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> Closing</th>

     <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> WDV</th>

    </tr>
    </thead>
    <tbody id="tbl_data">


    </tbody>
    </table>


  <button type="button" class="btn btn-info" onclick="return send(this , 'depreciation')" style="float: right;margin-top: 1rem;margin-bottom: 1rem;">Sent To Accounts</button>
    </div>



      <div  role="tabpanel"  class="table-responsive tab-pane fade " id="sold">

   <form method="get" style="margin-bottom: 3rem;margin-top: 1rem;" onsubmit="return getAssetLedger(this , 'sold' );">

        <div class="row">

            <div class="col-sm-10">
                <div class="row">

                    <div class="col-sm-6">
                        <label>From</label>
                        <input type="month" value="{{date('Y-m')}}" class="form-control" name="from" id="from">
                    </div>

                    <div class="col-sm-6">
                        <label>To</label>
                        <input type="month"  class="form-control" name="to" id="to">
                    </div>

                </div>
            </div>

            <div class="col-sm-2" style="margin-top: 2.5rem;">
                <button type="submit" class="btn btn-success">Calculate</button>
            </div>

        </div>
    </form>

 <div class="alert alert-success us_success_alert"  style="display: none;" role="alert" >
 Data Sent Successfully To Accounts
</div>

<div class="alert alert-danger us_error_alert"  style="display: none;" role="alert" >
</div>


    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
    <thead>
    <tr role="row">


     <th  class=""   tabindex="0"  rowspan="1" colspan="1"  style="width: 10px;text-align: center;"><input style="zoom: 1.6;" type="checkbox" name="" id="sold_parent_check_box"></th>

     <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Type</th>

     <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Policy</th>


       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Cost</th>

    
       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Opening</th>

       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">BV</th>

       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">For The Period</th>

       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Maintainance</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> Closing</th>

     <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;"> WDV</th>

    </tr>
    </thead>
    <tbody id="tbl_data_tab2">


    </tbody>
    </table>


 <button type="button" class="btn btn-info" onclick="return send(this , 'sold')" style="float: right;margin-top: 1rem;margin-bottom: 1rem;">Sent To Accounts</button>


</div>



</div>




    </div>
    </div>
    </div>


    </div>

    </div>
    </div>

  
@stop


@section('js')


<script type="text/javascript">

    
$(function(){
  $('body').on('click','#depreciation_parent_check_box',function(e){
    
    if($(this).is(':checked')){
     $('.depreciation_chk_box').prop("checked", true);
    } else {
     $('.depreciation_chk_box').prop("checked", false);
    }
  })
})


$(function(){
  $('body').on('click','#sold_parent_check_box',function(e){
    
    if($(this).is(':checked')){
     $('.sold_chk_box').prop("checked", true);
    } else {
     $('.sold_chk_box').prop("checked", false);
    }
  })
})


function send(self , type) 
{
  

var assets = [];


if (type == 'sold')
 {
    $(self).closest('.table-responsive').find('input[name="assets[]"]:checked').each(function()
    {
    assets.push({'asset_type_id':$(this).val() , 'asset_type': $(this).closest('tr').find('#asset_type').text() , 'cost' : $(this).closest('tr').find('#wdv').text() , 'asset_maintainance_cost' : $(this).closest('tr').find('#maintainance').text(), 'asset_ids' : $(this).closest('tr').find('.assets_ids').val()  });
    });
 }


 if (type == 'depreciation')
 {
    $(self).closest('.table-responsive').find('input[name="assets[]"]:checked').each(function()
    {
    assets.push({'asset_type_id':$(this).val() , 'asset_type': $(this).closest('tr').find('#asset_type').text() , 'cost' : $(this).closest('tr').find('#for_the_period').text() , 'asset_maintainance_cost' : $(this).closest('tr').find('#maintainance').text() , 'asset_ids' : $(this).closest('tr').find('.assets_ids').val() });
    });
 }


    var from = $(self).closest('.table-responsive').find('#from').val()
    var to =$(self).closest('.table-responsive').find('#to').val()

   

    $.ajax({

        url:"{{ route('sent.to.accounts') }}",
        method:'GET',
        dataType:'json',
        data:{assets:assets , type:type , from:from , to:to},
        success:function(data)
        {
           if (data.response == 'yes') 
           {
                $(self).closest('.table-responsive').find('.us_success_alert').show();
                setTimeout(function() { 
                location.reload(true);
                }, 2000);
           }
           else if(data.response == 'error')
           {
            $(self).closest('.table-responsive').find('.us_error_alert').html(data.output);
             $(self).closest('.table-responsive').find('.us_error_alert').show();
           }
           else
           {
                alert('Something Went Wrong!')
                // location.reload(true);
           }
          
        }
    })


  return false;
}

function getAssetLedger(self , tab_type) 
{
    var category = $(self).find('#category').val()
    var from = $(self).find('#from').val()
    var to =$(self).find('#to').val()
    var type = 'depreciation';

      $.ajax({

        url:"{{ route('filter.asset.ledger') }}",
        method:'GET',
        dataType:'json',
        data:{category:category , from:from , to:to , type:type, tab_type:tab_type},
        success:function(data)
        {
           if (data.response == 'from_error') 
           {
            alert('Please Select From Date.');
           }

            if (data.response == 'greater_error') 
           {
            alert('To Date Not Be Greater Than From.');
           }

           if (data.response == 'ok') 
           {
                $td_data_rows = '';
                $total_cost = 0;
                $total_opening = 0;
                $total_for_the_period = 0;
                $total_maintainance_charges = 0;
                $total_closing = 0;
                $total_wdv = 0;
                $total_bv = 0;

                
                $.each(data.output, function(k, v) 
                {
                    $td_data_rows +='<tr>';

                    if (tab_type == 'depreciation') 
                    {
                        $td_data_rows += '<td style="text-align: center;"><input type="checkbox" class="depreciation_chk_box" name="assets[]" value="'+v.asset_type_id+'"> <input type="text" value="'+v.asset_ids+'" class="assets_ids" style="display:none;"></td>';
                    }

                    if (tab_type == 'sold') 
                    {
                        $td_data_rows += '<td style="text-align: center;"><input type="checkbox" class="sold_chk_box" name="assets[]" value="'+v.asset_type_id+'"> <input type="text" value="'+v.asset_ids+'" class="assets_ids" style="display:none;"></td>';
                    }
                    
                    $td_data_rows += '<td id="asset_type">'+v.asset_type+'</td>';
                    $td_data_rows += '<td >'+v.policy+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.cost)+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.total_opening_month)+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.bv)+'</td>';
                    $td_data_rows += '<td id="for_the_period">'+addCommas(v.for_the_period)+'</td>';
                    $td_data_rows += '<td id="maintainance">'+addCommas(v.maintainance)+'</td>';
                    $td_data_rows += '<td >'+addCommas(v.closing)+'</td>';
                    $td_data_rows += '<td id="wdv">'+addCommas(v.wdv)+'</td>';
                    $td_data_rows +='</tr>';

                     $cost =  parseFloat(v.cost) || 0;
                    $opening =  parseFloat(v.total_opening_month) || 0;
                    $for_the_period =  parseFloat(v.for_the_period) || 0;
                    $maintainance =  parseFloat(v.maintainance) || 0;
                    $closing =  parseFloat(v.closing) || 0;
                    $wdv =  parseFloat(v.wdv) || 0;
                    $bv =  parseFloat(v.bv) || 0;

                    $total_cost = $total_cost +  $cost
                    $total_opening = $total_opening + $opening;
                    $total_for_the_period = $total_for_the_period + $for_the_period;
                    $total_maintainance_charges = $total_maintainance_charges + $maintainance;
                    $total_closing = $total_closing + $closing;
                    $total_wdv = $total_wdv + $wdv;
                    $total_bv =  $total_bv + $bv;

                });

                    $td_data_rows +='<tr>';
                    $td_data_rows += '<td colspan="3" style="font-weight:bold;">Total:</td>';
                    $td_data_rows += '<td  style="font-weight:bold;">'+ addCommas($total_cost)+'</td>';
                    $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_opening)+'</td>';
                    $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_bv)+'</td>';
                    $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_for_the_period)+'</td>';
                    $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_maintainance_charges)+'</td>';
                    $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_closing)+'</td>';
                    $td_data_rows += '<td style="font-weight:bold;">'+addCommas($total_wdv)+'</td>';
                    $td_data_rows +='</tr>';



                      if (tab_type == 'depreciation') 
                    {
                        $('#tbl_data').html($td_data_rows);   
                    }


                     if (tab_type == 'sold') 
                    {
                        $('#tbl_data_tab2').html($td_data_rows);   
                    }
               

           }
        }
    })

    return false;
}


function addCommas(nStr)
{
    nStr += '';
    x = nStr.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
}


</script>

@stop