@extends('layouts.app')

@section('title')
Add Asset Sale
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Add Asset Sale</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Add  Asset Sale</h3>

                        @if(Session::has('error'))   
                            <div  class="alert alert-danger" role="alert">
                            {{ Session::get('error') }}
                            </div>
                        @endif




                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{ route('fixed.assets.sale.insert') }}">
                            	 {{csrf_field()}}
                                <div class="form-group">

                                          
                                <div class="col-md-6" >
                                <label >Assets <b style="color:red;">*</b></label>

                                 <select class="form-control chosen-select" name="asset" onchange="return getData(this)"> 
                                        
                                       <option value="0" >Select Asset For Sale</option> 
                                        @foreach($fixed_asset as $list)
                                         
                                        <option value="{{$list->id}}">
                                            {{$list->asset_tag}} - {{$list->name}} 
                                        </option>

                                        @endforeach

                                 </select>


                                @if ($errors->has('asset'))
                                <span >
                                <strong class="error_messages" >{{ $errors->first('asset') }}</strong>
                                </span>
                                @endif

                                </div>



                                <div class="col-md-6"  >
                                <label >Sale Date <b style="color:red;">*</b></label>
                                <input type="date"  class="form-control" max="{{date('Y-m-d')}}"  value="{{date('Y-m-d')}}" name="sale_date">
                                @if ($errors->has('sale_date'))
                                <span >
                                <strong class="error_messages" >{{ $errors->first('sale_date') }}</strong>
                                </span>
                                @endif

                                </div>
                                 
                                <div class="col-md-6" style="margin-top:1.5rem;">
                                <label >Maintainance Cost  <b style="color:red;">*</b></label>
                                <input type="text" readonly class="form-control" id="maiantainance_cost"  value="{{old('maiantainance_cost')}}" name="maiantainance_cost">
                                @if ($errors->has('maiantainance_cost'))
                                <span >
                                <strong class="error_messages" >{{ $errors->first('maiantainance_cost') }}</strong>
                                </span>
                                @endif

                                </div>




                                <div class="col-md-6" style="margin-top:1.5rem;">
                                <label >Writen Down Value <b style="color:red;">*</b></label>
                                <input type="text" class="form-control" id="wdv" readonly value="{{old('wdv')}}" name="wdv">
                                @if ($errors->has('wdv'))
                                <span >
                                <strong class="error_messages" >{{ $errors->first('wdv') }}</strong>
                                </span>
                                @endif

                                </div>


                                <div class="form-group" style="margin-top: 1rem; float: right;">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop

@section('js')  

<script type="text/javascript">

    function getData(self) {
    

 $.ajax({

        url:"{{ route('get.asset.data') }}",
        method:'GET',
        dataType:'json',
        data:{id:$(self).val()},
        success:function(data)
        {
              if (data.response == 'true') 
              {
                $('#maiantainance_cost').val(data.output.maintainance)
                $('#wdv').val(data.output.wdv)
              }
              else
              {
                 $('#maiantainance_cost').val('')
                 $('#wdv').val('')
              }
        }
    })

    return false;
}

</script>
@stop