@extends('layouts.app')

@section('title')
All Sold Assets
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li>
            <a href="{{route('home')}}">
            <i class="fa fa-dashboard"></i> 
            Home
        </a>
        </li>

        <li class="active">
           Sold Assets
        </li>
    </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
 <style type="text/css">
     .reassign_form
     {
        display: none;
     }
 </style>
@stop
@section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">
    <div class="white-box">

    <h3 style="text-align: right;" class="box-title m-b-0">
        <span style="float: left;">Sold Assets List</span>
        @permission('fixed-assets')
        <a class="btn btn-info btn-sm" href="{{ route('fixed.assets.add.sale') }}">Sale</a>
        @endpermission
      
    </h3>

    <div class="table-responsive">

    @if(Session::has('success'))   
        <div id="successMessage" class="alert alert-success" role="alert">
            {{ Session::get('success') }}
        </div>
    @endif

    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
    <thead>
    <tr role="row">

    <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 20px;">Asset Tag</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Maintainance Cost</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Writen Down Value</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Sold Date</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 10px;">Action</th>

    </tr>
    </thead>
    <tbody>

    @foreach( $fixed_asset_solds as $list )
   
    <tr class="active">
        <td >{{$list->asset->asset_tag }}</td>
        <td >{{ $list->maintainance_cost  }} </td>
        <td >{{$list->writen_down_value}}</td>
        <td >{{date('d-F-Y' , strtotime($list->sold_date))}}</td>
        <td>
           
            <a href="{{route('fixed.asset.sale.revert' , [$list->id])}}" title="revert" onclick="return validate()">
                <i class="fa fa-refresh" aria-hidden="true"></i>
            </a>
           
        </td>
    </tr>

    @endforeach   


    </tbody>
    </table>

    </div>
    </div>
    </div>
    </div>


    </div>

    </div>
    </div>

 
@stop



@section('js')  

<script type="text/javascript">
   

   function validate() 
   {
       if (confirm('Are you sure?')) 
       {
        return true;
       }

       return false;    
   }
</script>

@stop